/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.ContainsType;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.FigurePathFactory;
import net.perspective.draw.geom.FigurePointFactory;
import net.perspective.draw.geom.FigureType;
import net.perspective.draw.geom.PathFactory;
import net.perspective.draw.geom.PointFactory;
import net.perspective.draw.util.CanvasPoint;
import org.jhotdraw.geom.DoubleStroke;

public class Figure
implements DrawItem,
Serializable {
    protected List<CanvasPoint> points;
    protected CanvasPoint start;
    protected CanvasPoint end;
    protected FigureType type = FigureType.NONE;
    protected transient Path2D.Double path;
    protected transient PointFactory pointfactory;
    protected transient PathFactory pathfactory;
    protected transient Stroke stroke;
    private Color color;
    private Color fillcolor;
    private int transparency = 0;
    private boolean isVertical = false;
    protected double angle = 0.0;
    private boolean closed = false;
    private static final long serialVersionUID = 1L;

    public Figure() {
    }

    @ConstructorProperties(value={"type"})
    public Figure(FigureType type) {
        this();
        this.type = type;
        this.points = new ArrayList<CanvasPoint>();
        this.pathfactory = new FigurePathFactory();
        this.pointfactory = new FigurePointFactory();
        this.path = new Path2D.Double();
    }

    public void setFactory() {
        this.pointfactory = new FigurePointFactory();
        this.pathfactory = new FigurePathFactory();
    }

    @Override
    public void setStart(double x, double y) {
        if (this.start == null) {
            this.start = new CanvasPoint();
        }
        this.start.setLocation(x, y);
    }

    @Override
    public CanvasPoint getStart() {
        return this.start;
    }

    @Override
    public void setEnd(double x, double y) {
        if (this.end == null) {
            this.end = new CanvasPoint();
        }
        this.end.setLocation(x, y);
    }

    @Override
    public CanvasPoint getEnd() {
        return this.end;
    }

    public void setPoints(List<CanvasPoint> points) {
        this.points = points;
    }

    public void setPoints(DrawingType drawtype) {
        this.points = this.pointfactory.createPoints(drawtype, this.start.x, this.start.y, this.end.x, this.end.y);
    }

    public List<CanvasPoint> getPoints() {
        return this.points;
    }

    public void setEndPoints() {
        switch (this.getType()) {
            case CIRCLE: 
            case SQUARE: {
                this.start = new CanvasPoint(this.points.get((int)0).x, this.points.get((int)0).y);
                this.end = new CanvasPoint(this.points.get((int)2).x, this.points.get((int)2).y);
                break;
            }
            case TRIANGLE: {
                this.start = new CanvasPoint(this.points.get((int)1).x, this.points.get((int)0).y);
                this.end = new CanvasPoint(this.points.get((int)2).x, this.points.get((int)2).y);
                break;
            }
            case HEXAGON: {
                this.start = new CanvasPoint(this.points.get((int)1).x, this.points.get((int)0).y);
                this.end = new CanvasPoint(this.points.get((int)4).x, this.points.get((int)3).y);
                break;
            }
            case PENTAGRAM: {
                this.start = new CanvasPoint(this.points.get((int)8).x, this.points.get((int)6).y);
                this.end = new CanvasPoint(this.points.get((int)4).x, this.points.get((int)2).y);
                break;
            }
            default: {
                this.start = this.points.get(0);
                this.end = this.points.get(this.points.size() - 1);
            }
        }
    }

    public void addPoint(double x, double y) {
        this.points.add(new CanvasPoint(x, y));
    }

    public void setPath() {
        this.path = this.pathfactory.createPath(this);
        this.setClosed(true);
    }

    public void setPath(Path2D.Double path) {
        this.path = path;
        this.setClosed(true);
    }

    public Path2D.Double getPath() {
        return this.path;
    }

    public void setType(FigureType type) {
        this.type = type;
    }

    public FigureType getType() {
        return this.type;
    }

    @Override
    public void updateProperties(DrawingCanvas canvas) {
        this.setColor(canvas.getStrokeColor());
        this.setFillColor(canvas.getFillColor());
        this.setStroke(canvas.getStroke());
        this.setTransparency(canvas.getTransparency());
    }

    @Override
    public CanvasPoint[] getTop() {
        CanvasPoint[] p = this.getVertex(ContainsType.TL);
        CanvasPoint[] s = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
        return s;
    }

    @Override
    public CanvasPoint[] getUp() {
        CanvasPoint[] p = this.getVertex(ContainsType.TR);
        CanvasPoint[] up = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
        return up;
    }

    @Override
    public CanvasPoint[] getDown() {
        CanvasPoint[] p = this.getVertex(ContainsType.BL);
        CanvasPoint[] down = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
        return down;
    }

    @Override
    public CanvasPoint[] getBottom() {
        CanvasPoint[] p = this.getVertex(ContainsType.BR);
        CanvasPoint[] e = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
        return e;
    }

    protected CanvasPoint getTransform(CanvasPoint point) {
        CanvasPoint centre = this.rotationCentre();
        point.translate(-centre.x, -centre.y);
        if (this.getAngle() != 0.0 && !this.getType().equals((Object)FigureType.LINE)) {
            point.rotate(this.getAngle());
        }
        if (this.isVertical()) {
            point.rotate(-1.5707963267948966);
        }
        point.translate(centre.x, centre.y);
        return point;
    }

    protected AffineTransform getTransform() {
        CanvasPoint centre = this.rotationCentre();
        AffineTransform transform = new AffineTransform();
        transform.setToRotation((!this.getType().equals((Object)FigureType.LINE) ? this.getAngle() : 0.0) + (this.isVertical() ? -1.5707963267948966 : 0.0), centre.x, centre.y);
        return transform;
    }

    @Override
    public CanvasPoint rotationCentre() {
        CanvasPoint p = new CanvasPoint();
        if (this.start.x < this.end.x && this.start.y < this.end.y) {
            double x = this.start.x;
            double y = this.start.y;
            double w = this.end.x - this.start.x;
            double h = this.end.y - this.start.y;
            p = new CanvasPoint(x + w / 2.0, y + h / 2.0);
        } else if (this.start.x >= this.end.x && this.start.y >= this.end.y) {
            double x = this.end.x;
            double y = this.end.y;
            double w = this.start.x - this.end.x;
            double h = this.start.y - this.end.y;
            p = new CanvasPoint(x + w / 2.0, y + h / 2.0);
        } else if (this.start.x >= this.end.x && this.start.y < this.end.y) {
            double x = this.end.x;
            double y = this.start.y;
            double w = this.start.x - this.end.x;
            double h = this.end.y - this.start.y;
            p = new CanvasPoint(x + w / 2.0, y + h / 2.0);
        } else if (this.start.x < this.end.x && this.start.y >= this.end.y) {
            double x = this.start.x;
            double y = this.end.y;
            double w = this.end.x - this.start.x;
            double h = this.start.y - this.end.y;
            p = new CanvasPoint(x + w / 2.0, y + h / 2.0);
        }
        return p;
    }

    protected Rectangle2D getBounds2D() {
        Shape area = this.bounds();
        Rectangle2D bound = area.getBounds2D();
        return bound;
    }

    @Override
    public Shape bounds() {
        AffineTransform transform = this.getTransform();
        Path2D.Double p = (Path2D.Double)this.getPath().clone();
        p.transform(transform);
        return p;
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.getType().equals((Object)FigureType.NONE)) {
            return false;
        }
        return this.bounds().intersects(x - 5.0, y - 5.0, 10.0, 10.0);
    }

    @Override
    public void moveTo(double xinc, double yinc) {
        this.points.stream().forEach(p -> p.translate(xinc, yinc));
        this.setEndPoints();
        this.setPath();
    }

    @Override
    public void draw(Graphics2D g2, DrawingCanvas canvas) {
        AffineTransform defaultTransform = g2.getTransform();
        AffineTransform transform = this.getTransform();
        g2.transform(transform);
        if (this.isClosed()) {
            AlphaComposite ac = AlphaComposite.getInstance(3, (float)this.getTransparency() / 100.0f);
            g2.setComposite(ac);
            g2.setColor(Figure.awtToAlpha(this.getFillColor(), (float)this.getTransparency() / 100.0f));
            g2.fill(this.getPath());
            ac = AlphaComposite.getInstance(3, 1.0f);
            g2.setComposite(ac);
        }
        g2.setStroke(this.getStroke());
        g2.setColor(this.getColor());
        g2.draw(this.getPath());
        g2.setTransform(defaultTransform);
    }

    @Override
    public void sketch(Graphics2D g2, DrawingCanvas canvas) {
        g2.setStroke(canvas.getPlainStroke());
        g2.setColor(canvas.getThemeFillColor());
        g2.draw(this.getPath());
    }

    @Override
    public void drawAnchors(Graphics2D g2, DrawingCanvas canvas) {
        float[] dashes = new float[]{1.0f, 2.0f};
        AffineTransform defaultTransform = g2.getTransform();
        AffineTransform transform = this.getTransform();
        g2.transform(transform);
        CanvasPoint centre = this.rotationCentre();
        switch (this.getType()) {
            case CIRCLE: 
            case TRIANGLE: 
            case HEXAGON: 
            case PENTAGRAM: {
                g2.setStroke(new DoubleStroke(3.0, 1.0, 2, 2, 10.0, dashes, 0.0f));
                g2.setColor(canvas.getThemeFillColor());
                g2.draw(new RoundRectangle2D.Double(Math.min(this.start.x, this.end.x), Math.min(this.start.y, this.end.y), Math.abs(this.end.x - this.start.x), Math.abs(this.end.y - this.start.y), 5.0, 5.0));
                g2.setStroke(new BasicStroke(1.2f, 1, 1));
                this.anchor(g2, this.start.x, this.start.y, canvas);
                this.anchor(g2, this.start.x, this.end.y, canvas);
                this.anchor(g2, this.end.x, this.end.y, canvas);
                this.anchor(g2, this.end.x, this.start.y, canvas);
                this.edgeAnchor(g2, centre.x, this.start.y, canvas);
                this.edgeAnchor(g2, this.start.x, centre.y, canvas);
                this.edgeAnchor(g2, centre.x, this.end.y, canvas);
                this.edgeAnchor(g2, this.end.x, centre.y, canvas);
                break;
            }
            case SQUARE: {
                g2.setStroke(new BasicStroke(1.2f, 1, 1));
                for (CanvasPoint point : this.points) {
                    this.anchor(g2, point.x, point.y, canvas);
                }
                this.edgeAnchor(g2, centre.x, this.start.y, canvas);
                this.edgeAnchor(g2, this.start.x, centre.y, canvas);
                this.edgeAnchor(g2, centre.x, this.end.y, canvas);
                this.edgeAnchor(g2, this.end.x, centre.y, canvas);
                break;
            }
            case LINE: 
            case CURVE: 
            case SKETCH: 
            case POLYGON: 
            case VECTOR: {
                g2.setStroke(new BasicStroke(1.2f, 1, 1));
                this.anchor(g2, this.start.x, this.start.y, canvas);
                this.anchor(g2, this.end.x, this.end.y, canvas);
                break;
            }
            case NONE: {
                break;
            }
        }
        g2.setTransform(defaultTransform);
    }

    private void anchor(Graphics2D g2, double x, double y, DrawingCanvas canvas) {
        g2.setColor(canvas.getCanvasBackgroundColor());
        g2.fill(new Ellipse2D.Double(x - 4.0, y - 4.0, 8.0, 8.0));
        g2.setColor(canvas.getThemeAccentColor());
        g2.draw(new Ellipse2D.Double(x - 4.0, y - 4.0, 8.0, 8.0));
    }

    private void edgeAnchor(Graphics2D g2, double x, double y, DrawingCanvas canvas) {
        g2.setColor(canvas.getCanvasBackgroundColor());
        g2.fill(new Rectangle2D.Double(x - 3.0, y - 3.0, 6.0, 6.0));
        g2.setColor(canvas.getThemeAccentColor());
        g2.draw(new Rectangle2D.Double(x - 3.0, y - 3.0, 6.0, 6.0));
    }

    protected void setClosed(boolean closed) {
        this.closed = closed;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setFillColor(Color fillcolor) {
        this.fillcolor = fillcolor;
    }

    public Color getFillColor() {
        return this.fillcolor;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setTransparency(int transparency) {
        this.transparency = transparency;
    }

    public int getTransparency() {
        return this.transparency;
    }

    @Override
    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }

    @Override
    public boolean isVertical() {
        return this.isVertical;
    }

    @Override
    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    public double sgnd_area() {
        CanvasPoint p3;
        CanvasPoint p2;
        CanvasPoint p1;
        if (this.type.equals((Object)FigureType.PENTAGRAM)) {
            p1 = this.points.get(1);
            p2 = this.points.get(3);
            p3 = this.points.get(5);
        } else {
            p1 = this.points.get(0);
            p2 = this.points.get(1);
            p3 = this.points.get(2);
        }
        double _area = p1.x * p2.y - p2.x * p1.y + (p2.x * p3.y - p3.x * p2.y) + (p3.x * p1.y - p1.x * p3.y);
        return Math.signum(_area);
    }

    private CanvasPoint[] getVertex(ContainsType contains) {
        CanvasPoint[] canvasPointArray;
        double x = Math.min(this.start.x, this.end.x);
        double y = Math.min(this.start.y, this.end.y);
        double width = Math.abs(this.start.x - this.end.x);
        double height = Math.abs(this.start.y - this.end.y);
        double side = 0.25 * (width + height);
        CanvasPoint cxy = this.rotationCentre();
        block0 : switch (this.getType()) {
            case CIRCLE: 
            case SQUARE: 
            case TRIANGLE: 
            case HEXAGON: 
            case PENTAGRAM: {
                switch (contains) {
                    case TL: {
                        CanvasPoint[] canvasPointArray2 = new CanvasPoint[2];
                        canvasPointArray2[0] = new CanvasPoint(x, y);
                        canvasPointArray = canvasPointArray2;
                        canvasPointArray2[1] = new CanvasPoint(cxy.x - side, cxy.y - side);
                        break block0;
                    }
                    case BL: {
                        CanvasPoint[] canvasPointArray3 = new CanvasPoint[2];
                        canvasPointArray3[0] = new CanvasPoint(x, y + height);
                        canvasPointArray = canvasPointArray3;
                        canvasPointArray3[1] = new CanvasPoint(cxy.x - side, cxy.y + side);
                        break block0;
                    }
                    case BR: {
                        CanvasPoint[] canvasPointArray4 = new CanvasPoint[2];
                        canvasPointArray4[0] = new CanvasPoint(x + width, y + height);
                        canvasPointArray = canvasPointArray4;
                        canvasPointArray4[1] = new CanvasPoint(cxy.x + side, cxy.y + side);
                        break block0;
                    }
                    case TR: {
                        CanvasPoint[] canvasPointArray5 = new CanvasPoint[2];
                        canvasPointArray5[0] = new CanvasPoint(x + width, y);
                        canvasPointArray = canvasPointArray5;
                        canvasPointArray5[1] = new CanvasPoint(cxy.x + side, cxy.y - side);
                        break block0;
                    }
                }
                CanvasPoint[] canvasPointArray6 = new CanvasPoint[2];
                canvasPointArray6[0] = new CanvasPoint(x, y);
                canvasPointArray = canvasPointArray6;
                canvasPointArray6[1] = new CanvasPoint(cxy.x - side, cxy.y - side);
                break;
            }
            default: {
                CanvasPoint[] canvasPointArray7 = new CanvasPoint[2];
                canvasPointArray7[0] = new CanvasPoint(x, y);
                canvasPointArray = canvasPointArray7;
                canvasPointArray7[1] = new CanvasPoint(cxy.x - side, cxy.y - side);
            }
        }
        CanvasPoint[] p = canvasPointArray;
        return p;
    }

    public List<CanvasPoint[]> getVertices() {
        ArrayList<CanvasPoint[]> vert = new ArrayList<CanvasPoint[]>();
        ArrayList<CanvasPoint[]> vertices = new ArrayList<CanvasPoint[]>();
        switch (this.getType()) {
            case CIRCLE: 
            case SQUARE: 
            case TRIANGLE: 
            case HEXAGON: 
            case PENTAGRAM: {
                double ey;
                double sy;
                double ex;
                double sx;
                double width = Math.abs(this.start.x - this.end.x);
                double height = Math.abs(this.start.y - this.end.y);
                double side = 0.25 * (width + height);
                CanvasPoint cxy = this.rotationCentre();
                if (this.start.x < this.end.x) {
                    sx = cxy.x - side;
                    ex = cxy.x + side;
                } else {
                    sx = cxy.x + side;
                    ex = cxy.x - side;
                }
                if (this.start.y < this.end.y) {
                    sy = cxy.y - side;
                    ey = cxy.y + side;
                } else {
                    sy = cxy.y + side;
                    ey = cxy.y - side;
                }
                vert.add(new CanvasPoint[]{new CanvasPoint(this.start.x, this.start.y), new CanvasPoint(sx, sy)});
                vert.add(new CanvasPoint[]{new CanvasPoint(this.start.x, this.end.y), new CanvasPoint(sx, ey)});
                vert.add(new CanvasPoint[]{new CanvasPoint(this.end.x, this.end.y), new CanvasPoint(ex, ey)});
                vert.add(new CanvasPoint[]{new CanvasPoint(this.end.x, this.start.y), new CanvasPoint(ex, sy)});
                break;
            }
            default: {
                vert.add(new CanvasPoint[]{new CanvasPoint(this.start.x, this.start.y), new CanvasPoint(this.start.x, this.start.y)});
                vert.add(new CanvasPoint[]{new CanvasPoint(this.end.x, this.end.y), new CanvasPoint(this.end.x, this.end.y)});
            }
        }
        for (CanvasPoint[] p : vert) {
            CanvasPoint[] point = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
            vertices.add(point);
        }
        return vertices;
    }

    public List<CanvasPoint[]> getEdges() {
        ArrayList<CanvasPoint[]> vert = new ArrayList<CanvasPoint[]>();
        ArrayList<CanvasPoint[]> vertices = new ArrayList<CanvasPoint[]>();
        switch (this.getType()) {
            case CIRCLE: 
            case SQUARE: 
            case TRIANGLE: 
            case HEXAGON: 
            case PENTAGRAM: {
                double ey;
                double sy;
                double ex;
                double sx;
                double width = Math.abs(this.start.x - this.end.x);
                double height = Math.abs(this.start.y - this.end.y);
                double side = 0.25 * (width + height);
                CanvasPoint cxy = this.rotationCentre();
                if (this.start.x < this.end.x) {
                    sx = cxy.x - side;
                    ex = cxy.x + side;
                } else {
                    sx = cxy.x + side;
                    ex = cxy.x - side;
                }
                if (this.start.y < this.end.y) {
                    sy = cxy.y - side;
                    ey = cxy.y + side;
                } else {
                    sy = cxy.y + side;
                    ey = cxy.y - side;
                }
                vert.add(new CanvasPoint[]{new CanvasPoint(cxy.x, this.start.y), new CanvasPoint(cxy.x, sy)});
                vert.add(new CanvasPoint[]{new CanvasPoint(this.start.x, cxy.y), new CanvasPoint(sx, cxy.y)});
                vert.add(new CanvasPoint[]{new CanvasPoint(cxy.x, this.end.y), new CanvasPoint(cxy.x, ey)});
                vert.add(new CanvasPoint[]{new CanvasPoint(this.end.x, cxy.y), new CanvasPoint(ex, cxy.y)});
                break;
            }
            default: {
                vert.add(new CanvasPoint[]{new CanvasPoint(this.start.x, this.start.y), new CanvasPoint(this.start.x, this.start.y)});
                vert.add(new CanvasPoint[]{new CanvasPoint(this.end.x, this.end.y), new CanvasPoint(this.end.x, this.end.y)});
            }
        }
        for (CanvasPoint[] p : vert) {
            CanvasPoint[] point = new CanvasPoint[]{this.getTransform(p[0]), this.getTransform(p[1])};
            vertices.add(point);
        }
        return vertices;
    }

    public static Color awtToAlpha(Color color, float opacity) {
        return new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, opacity);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setStroke(Figure.readStroke(in));
        this.setPath(Figure.readPath(in));
        this.pointfactory = new FigurePointFactory();
        this.pathfactory = new FigurePathFactory();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Figure.writeStroke(this.getStroke(), out);
        Figure.writePath(this.getPath(), out);
    }

    public static Stroke readStroke(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Stroke result = null;
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            Class c = (Class)stream.readObject();
            if (c.equals(BasicStroke.class)) {
                float width = stream.readFloat();
                int cap = stream.readInt();
                int join = stream.readInt();
                float miterLimit = stream.readFloat();
                float[] dash = (float[])stream.readObject();
                float dashPhase = stream.readFloat();
                result = new BasicStroke(width, cap, join, miterLimit, dash, dashPhase);
            } else {
                result = (Stroke)stream.readObject();
            }
        }
        return result;
    }

    public static void writeStroke(Stroke stroke, ObjectOutputStream stream) throws IOException {
        if (stroke != null) {
            stream.writeBoolean(false);
            if (stroke instanceof BasicStroke) {
                BasicStroke s = (BasicStroke)stroke;
                stream.writeObject(BasicStroke.class);
                stream.writeFloat(s.getLineWidth());
                stream.writeInt(s.getEndCap());
                stream.writeInt(s.getLineJoin());
                stream.writeFloat(s.getMiterLimit());
                stream.writeObject(s.getDashArray());
                stream.writeFloat(s.getDashPhase());
            } else {
                stream.writeObject(stroke.getClass());
                stream.writeObject(stroke);
            }
        } else {
            stream.writeBoolean(true);
        }
    }

    public static Path2D.Double readPath(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Path2D.Double path = new Path2D.Double();
        boolean isNull = stream.readBoolean();
        if (!isNull) {
            double[][] pathData;
            block7: for (double[] segment : pathData = (double[][])stream.readObject()) {
                int segmentType = (int)segment[0];
                switch (segmentType) {
                    case 0: {
                        path.moveTo(segment[1], segment[2]);
                        continue block7;
                    }
                    case 1: {
                        path.lineTo(segment[1], segment[2]);
                        continue block7;
                    }
                    case 2: {
                        path.quadTo(segment[1], segment[2], segment[3], segment[4]);
                        continue block7;
                    }
                    case 3: {
                        path.curveTo(segment[1], segment[2], segment[3], segment[4], segment[5], segment[6]);
                        continue block7;
                    }
                    case 4: {
                        path.closePath();
                    }
                }
            }
        }
        return path;
    }

    public static void writePath(Path2D.Double path, ObjectOutputStream stream) throws IOException {
        if (path != null) {
            stream.writeBoolean(false);
            stream.writeObject(Figure.getPathData(path));
        } else {
            stream.writeBoolean(true);
        }
    }

    private static double[][] getPathData(Path2D.Double path) {
        ArrayList<double[]> pathData = new ArrayList<double[]>();
        double[] coords = new double[6];
        PathIterator iterator = path.getPathIterator(null);
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(coords);
            switch (segmentType) {
                case 0: {
                    pathData.add(new double[]{0.0, coords[0], coords[1]});
                    break;
                }
                case 1: {
                    pathData.add(new double[]{1.0, coords[0], coords[1]});
                    break;
                }
                case 2: {
                    pathData.add(new double[]{2.0, coords[0], coords[1], coords[2], coords[3]});
                    break;
                }
                case 3: {
                    pathData.add(new double[]{3.0, coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]});
                    break;
                }
                case 4: {
                    pathData.add(new double[]{4.0});
                }
            }
            iterator.next();
        }
        return (double[][])pathData.toArray(x$0 -> new double[x$0][]);
    }
}

