/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureType;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.V2;

public class Edge
extends Figure {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Edge.class.getName());

    public Edge() {
    }

    @ConstructorProperties(value={"type"})
    public Edge(FigureType type) {
        super(type);
    }

    @Override
    public void setPoints(DrawingType drawtype) {
        this.points = this.getType().equals((Object)FigureType.LINE) ? this.pointfactory.createPoints(drawtype, this.start.x, this.start.y, this.end.x, this.end.y) : new ArrayList();
    }

    @Override
    public void setEndPoints() {
        try {
            switch (this.getType()) {
                case VECTOR: {
                    CanvasPoint[] coords = this.getStartAndEndPoints(this.getPath());
                    this.start = coords[0];
                    this.end = coords[1];
                    Rectangle2D bounds = this.getBounds2D().getBounds2D();
                    this.start = new CanvasPoint(bounds.getMinX(), bounds.getMinY());
                    this.end = new CanvasPoint(bounds.getMaxX(), bounds.getMaxY());
                    break;
                }
                default: {
                    if (this.points == null || this.points.isEmpty()) {
                        throw new IllegalStateException("Points list is null or empty for non-VECTOR type");
                    }
                    this.start = (CanvasPoint)this.points.get(0);
                    this.end = (CanvasPoint)this.points.get(this.points.size() - 1);
                    break;
                }
            }
        }
        catch (IllegalStateException | IndexOutOfBoundsException | NullPointerException e) {
            logger.log(Level.WARNING, "Error setting endpoints: {0}", e.getMessage());
            e.printStackTrace();
            this.start = new CanvasPoint(0.0, 0.0);
            this.end = new CanvasPoint(0.0, 0.0);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unexpected error in setEndPoints(): {0}", e.getMessage());
            e.printStackTrace();
        }
    }

    private CanvasPoint[] getStartAndEndPoints(Path2D.Double curve) {
        PathIterator iterator = curve.getPathIterator(null);
        double[] coords = new double[6];
        CanvasPoint begin = null;
        CanvasPoint finish = null;
        CanvasPoint currentSubpathStart = null;
        while (!iterator.isDone()) {
            int operation = iterator.currentSegment(coords);
            switch (operation) {
                case 0: {
                    if (begin == null) {
                        begin = new CanvasPoint(coords[0], coords[1]);
                    }
                    finish = currentSubpathStart = new CanvasPoint(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    finish = new CanvasPoint(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    finish = new CanvasPoint(coords[2], coords[3]);
                    break;
                }
                case 3: {
                    finish = new CanvasPoint(coords[4], coords[5]);
                    break;
                }
            }
            iterator.next();
        }
        return new CanvasPoint[]{begin, finish};
    }

    @Override
    public void setPath() {
        this.path = this.pathfactory.createPath(this);
        switch (this.getType()) {
            case VECTOR: 
            case POLYGON: {
                this.setClosed(true);
                break;
            }
            default: {
                this.setClosed(false);
            }
        }
    }

    @Override
    public CanvasPoint[] getTop() {
        Rectangle2D bound = this.getBounds2D();
        CanvasPoint b = new CanvasPoint(bound.getX(), bound.getY());
        CanvasPoint[] s = new CanvasPoint[]{b, b};
        return s;
    }

    @Override
    public CanvasPoint[] getUp() {
        Rectangle2D bound = this.getBounds2D();
        CanvasPoint b = new CanvasPoint(bound.getX() + bound.getWidth(), bound.getY());
        CanvasPoint[] up = new CanvasPoint[]{b, b};
        return up;
    }

    @Override
    public CanvasPoint[] getDown() {
        Rectangle2D bound = this.getBounds2D();
        CanvasPoint b = new CanvasPoint(bound.getX(), bound.getY() + bound.getHeight());
        CanvasPoint[] down = new CanvasPoint[]{b, b};
        return down;
    }

    @Override
    public CanvasPoint[] getBottom() {
        Rectangle2D bound = this.getBounds2D();
        CanvasPoint b = new CanvasPoint(bound.getX() + bound.getWidth(), bound.getY() + bound.getHeight());
        CanvasPoint[] e = new CanvasPoint[]{b, b};
        return e;
    }

    @Override
    public CanvasPoint rotationCentre() {
        Path2D.Double pa = (Path2D.Double)this.getPath().clone();
        pa.closePath();
        Area area = new Area(pa);
        Rectangle2D bound = area.getBounds2D();
        CanvasPoint centre = bound.getBounds2D().getWidth() < 4.0 && bound.getBounds2D().getHeight() < 4.0 ? new CanvasPoint(0.5 * (this.start.x + this.end.x), 0.5 * (this.start.y + this.end.y)) : (this.points.size() < 3 ? new CanvasPoint(0.5 * (this.start.x + this.end.x), 0.5 * (this.start.y + this.end.y)) : new CanvasPoint(bound.getCenterX(), bound.getCenterY()));
        return centre;
    }

    @Override
    public void moveTo(double xinc, double yinc) {
        super.moveTo(xinc, yinc);
        if (this.type == FigureType.VECTOR) {
            this.setPath(this.translatePath(this.getPath(), xinc, yinc));
        }
    }

    private Path2D.Double translatePath(Path2D.Double path, double xinc, double yinc) {
        AffineTransform transform = AffineTransform.getTranslateInstance(xinc, yinc);
        return (Path2D.Double)path.createTransformedShape(transform);
    }

    @Override
    public Shape bounds() {
        Shape bounds;
        if (this.getType().equals((Object)FigureType.LINE)) {
            double length = V2.L2(new CanvasPoint(this.end.x - this.start.x, this.end.y - this.start.y));
            Rectangle2D.Double rectangle = new Rectangle2D.Double(-2.0, -2.0, length + 4.0, 4.0);
            double a = Math.atan2(this.end.y - this.start.y, this.end.x - this.start.x);
            Area area = new Area(rectangle);
            AffineTransform transform = new AffineTransform();
            transform.setToTranslation(this.start.x, this.start.y);
            transform.rotate(a);
            area.transform(transform);
            bounds = area;
        } else {
            bounds = super.bounds();
            if (bounds.getBounds2D().getWidth() < 4.0 && bounds.getBounds2D().getHeight() < 4.0) {
                Rectangle2D.Double rectangle = new Rectangle2D.Double(-2.0, -2.0, 4.0, 4.0);
                Area area = new Area(rectangle);
                AffineTransform transform = new AffineTransform();
                transform.setToTranslation(this.start.x, this.start.y);
                area.transform(transform);
                bounds = area;
            }
        }
        return bounds;
    }

    @Override
    public double getAngle() {
        if (!this.getType().equals((Object)FigureType.LINE)) {
            return this.angle;
        }
        CanvasPoint centre = new CanvasPoint(0.5 * (this.start.x + this.end.x), 0.5 * (this.start.y + this.end.y));
        CanvasPoint A = new CanvasPoint(1.0, 0.0);
        CanvasPoint B = new CanvasPoint(this.end.x - centre.x, this.end.y - centre.y);
        double h1 = V2.L2(A);
        CanvasPoint q1 = new CanvasPoint(A.x / h1, A.y / h1);
        double h2 = V2.L2(B);
        CanvasPoint q2 = new CanvasPoint(B.x / h2, B.y / h2);
        double cos_t = V2.dot(q1, q2);
        double sin_t = V2.dot(V2.rot90(q1), q2);
        double theta = Math.atan2(sin_t, cos_t);
        return theta;
    }
}

