/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.geom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.beans.ConstructorProperties;
import java.beans.Transient;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.geom.ArrowType;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureType;
import net.perspective.draw.util.CanvasPoint;

public class ArrowLine
extends Figure {
    public Figure line;
    public ArrowType arrowType;
    private double wedgeAngle;
    private double outerRadius;
    private double innerRadius;
    private static final long serialVersionUID = 1L;

    public ArrowLine() {
        this(0.25, 10.0, 9.3);
    }

    public ArrowLine(Figure line) {
        this(0.25, 10.0, 9.3);
        this.line = line;
    }

    @ConstructorProperties(value={"line", "arrowType"})
    public ArrowLine(Figure line, ArrowType arrowType) {
        this(0.25, 10.0, 9.3);
        this.line = line;
        this.arrowType = arrowType;
    }

    public ArrowLine(double angle, double outerRadius, double innerRadius) {
        this.wedgeAngle = angle;
        this.outerRadius = outerRadius;
        this.innerRadius = innerRadius;
    }

    public void setLine(Figure line) {
        this.line = line;
    }

    public Figure getLine() {
        return this.line;
    }

    @Override
    public void setFactory() {
        this.line.setFactory();
    }

    @Override
    public void setStart(double x, double y) {
        this.line.setStart(x, y);
    }

    @Override
    public CanvasPoint getStart() {
        return this.line.getStart();
    }

    @Override
    public void setEnd(double x, double y) {
        this.line.setEnd(x, y);
    }

    @Override
    public CanvasPoint getEnd() {
        return this.line.getEnd();
    }

    @Override
    public void setPoints(List<CanvasPoint> points) {
        this.line.setPoints(points);
    }

    @Override
    public void setPoints(DrawingType drawtype) {
        this.line.setPoints(drawtype);
    }

    @Override
    public void setEndPoints() {
        this.line.setEndPoints();
    }

    @Override
    public List<CanvasPoint> getPoints() {
        return this.line.getPoints();
    }

    @Override
    public void addPoint(double x, double y) {
        this.line.addPoint(x, y);
    }

    @Override
    @Transient
    public void setPath() {
        this.line.setPath();
    }

    @Override
    @Transient
    public Path2D.Double getPath() {
        return this.line.getPath();
    }

    @Override
    public FigureType getType() {
        return this.line.getType();
    }

    public void setArrowType(ArrowType arrowType) {
        this.arrowType = arrowType;
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    public void setArrowStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Stroke getArrowStroke() {
        return this.stroke;
    }

    @Override
    @Transient
    public Stroke getStroke() {
        return this.line.getStroke();
    }

    @Override
    public void updateProperties(DrawingCanvas canvas) {
        super.setColor(canvas.getStrokeColor());
        this.setArrowStroke(canvas.getPlainStroke());
        this.setArrowType(canvas.getArrow());
        this.line.updateProperties(canvas);
    }

    @Override
    public CanvasPoint[] getTop() {
        return this.line.getTop();
    }

    @Override
    public CanvasPoint[] getUp() {
        return this.line.getUp();
    }

    @Override
    public CanvasPoint[] getDown() {
        return this.line.getDown();
    }

    @Override
    public CanvasPoint[] getBottom() {
        return this.line.getBottom();
    }

    @Override
    public CanvasPoint rotationCentre() {
        return this.line.rotationCentre();
    }

    @Override
    public Shape bounds() {
        return this.line.bounds();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.line.contains(x, y);
    }

    @Override
    public void moveTo(double xinc, double yinc) {
        this.line.moveTo(xinc, yinc);
    }

    @Override
    public void draw(Graphics2D g2, DrawingCanvas canvas) {
        this.line.draw(g2, canvas);
        AffineTransform defaultTransform = g2.getTransform();
        AffineTransform transform = this.getTransform();
        g2.transform(transform);
        Path2D.Double e = this.getTransformedEndDecoratorPath();
        g2.setColor(this.getColor());
        g2.fill(e);
        g2.setStroke(this.getArrowStroke());
        g2.draw(e);
        if (this.getArrowType() == ArrowType.BOTH) {
            Path2D.Double s = this.getTransformedStartDecoratorPath();
            g2.setColor(this.getColor());
            g2.fill(s);
            g2.setStroke(this.getArrowStroke());
            g2.draw(s);
        }
        g2.setTransform(defaultTransform);
    }

    @Override
    public void sketch(Graphics2D g2, DrawingCanvas canvas) {
        this.line.sketch(g2, canvas);
        Path2D.Double e = this.getTransformedEndDecoratorPath();
        g2.setColor(canvas.getThemeFillColor());
        g2.fill(e);
        g2.setStroke(this.getArrowStroke());
        g2.draw(e);
        if (this.getArrowType() == ArrowType.BOTH) {
            Path2D.Double s = this.getTransformedStartDecoratorPath();
            g2.setColor(canvas.getThemeFillColor());
            g2.fill(s);
            g2.setStroke(this.getArrowStroke());
            g2.draw(s);
        }
    }

    @Override
    public void drawAnchors(Graphics2D g2, DrawingCanvas canvas) {
        this.line.drawAnchors(g2, canvas);
    }

    private Path2D.Double getTransformedStartDecoratorPath() {
        Path2D.Double decorator = this.getDecoratorPath();
        double strokeWidth = ((BasicStroke)this.getArrowStroke()).getLineWidth();
        CanvasPoint p1 = this.getP1();
        AffineTransform transform = new AffineTransform();
        transform.translate(this.line.getStart().getX(), this.line.getStart().getY());
        transform.rotate(Math.atan2(this.line.getStart().getX() - p1.x, p1.y - this.line.getStart().getY()));
        if (strokeWidth > 1.0) {
            transform.scale(1.0 + (strokeWidth - 1.0) / 2.0, 1.0 + (strokeWidth - 1.0) / 2.0);
        }
        decorator.transform(transform);
        return decorator;
    }

    private Path2D.Double getTransformedEndDecoratorPath() {
        Path2D.Double decorator = this.getDecoratorPath();
        double strokeWidth = ((BasicStroke)this.getArrowStroke()).getLineWidth();
        CanvasPoint p2 = this.getP2();
        AffineTransform transform = new AffineTransform();
        transform.translate(this.line.getEnd().getX(), this.line.getEnd().getY());
        transform.rotate(Math.atan2(this.line.getEnd().getX() - p2.x, p2.y - this.line.getEnd().getY()));
        if (strokeWidth > 1.0) {
            transform.scale(1.0 + (strokeWidth - 1.0) / 2.0, 1.0 + (strokeWidth - 1.0) / 2.0);
        }
        decorator.transform(transform);
        return decorator;
    }

    private Path2D.Double getDecoratorPath() {
        double offset = 0.0;
        Path2D.Double decorator = new Path2D.Double();
        decorator.moveTo(this.outerRadius * Math.sin(-this.wedgeAngle), offset + this.outerRadius * Math.cos(-this.wedgeAngle));
        decorator.lineTo(0.0, offset);
        decorator.lineTo(this.outerRadius * Math.sin(this.wedgeAngle), offset + this.outerRadius * Math.cos(this.wedgeAngle));
        if (this.innerRadius != 0.0) {
            decorator.lineTo(0.0, this.innerRadius + offset);
            decorator.closePath();
        }
        return decorator;
    }

    private CanvasPoint getP1() {
        CanvasPoint point;
        if (this.line.getType().equals((Object)FigureType.LINE)) {
            point = new CanvasPoint(this.line.getEnd().getX(), this.line.getEnd().getY());
        } else {
            List<CanvasPoint> coords = this.P_1();
            int size = coords.size();
            point = new CanvasPoint(coords.get((int)(size - 1)).x, coords.get((int)(size - 1)).y);
        }
        return point;
    }

    private CanvasPoint getP2() {
        List<CanvasPoint> coords;
        int size;
        CanvasPoint point = this.line.getType().equals((Object)FigureType.LINE) ? new CanvasPoint(this.line.getStart().getX(), this.line.getStart().getY()) : ((size = (coords = this.P_2()).size()) > 2 ? (this.getType().equals((Object)FigureType.CURVE) ? new CanvasPoint(coords.get((int)(size - 1)).x, coords.get((int)(size - 1)).y) : new CanvasPoint(coords.get((int)(size - 2)).x, coords.get((int)(size - 2)).y)) : new CanvasPoint(coords.get((int)0).x, coords.get((int)0).y));
        return point;
    }

    private List<CanvasPoint> P_1() {
        double[] pt1 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        ArrayList<CanvasPoint> P1 = new ArrayList<CanvasPoint>();
        Path2D.Double p = this.getPath();
        PathIterator iterator = p.getPathIterator(new AffineTransform());
        for (int i = 0; i < 2; ++i) {
            if (iterator.isDone()) continue;
            iterator.currentSegment(pt1);
            CanvasPoint point = new CanvasPoint(pt1[0], pt1[1]);
            P1.add(point);
            iterator.next();
        }
        return P1;
    }

    private List<CanvasPoint> P_2() {
        double[] pt1 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        ArrayList<CanvasPoint> P2 = new ArrayList<CanvasPoint>();
        Path2D.Double p = this.getPath();
        PathIterator iterator = p.getPathIterator(new AffineTransform());
        int i = 0;
        while (!iterator.isDone()) {
            iterator.currentSegment(pt1);
            CanvasPoint point = new CanvasPoint(pt1[0], pt1[1]);
            if (i < 3) {
                P2.add(point);
            } else {
                P2.add(point);
                P2.remove(0);
            }
            ++i;
            iterator.next();
        }
        return P2;
    }

    @Override
    public void setColor(Color color) {
        this.line.setColor(color);
    }

    @Override
    @Transient
    public Color getColor() {
        return this.line.getColor();
    }

    @Override
    @Transient
    public Color getFillColor() {
        return this.line.getFillColor();
    }

    @Override
    public void setTransparency(int transparency) {
        this.line.setTransparency(transparency);
    }

    @Override
    @Transient
    public int getTransparency() {
        return this.line.getTransparency();
    }

    @Override
    public void setVertical(boolean isVertical) {
        this.line.setVertical(isVertical);
    }

    @Override
    @Transient
    public boolean isVertical() {
        return this.line.isVertical();
    }

    @Override
    public void setAngle(double angle) {
        this.line.setAngle(angle);
    }

    @Override
    @Transient
    public double getAngle() {
        return this.line.getAngle();
    }

    @Override
    public List<CanvasPoint[]> getVertices() {
        return this.line.getVertices();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setArrowStroke(ArrowLine.readStroke(in));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ArrowLine.writeStroke(this.getArrowStroke(), out);
    }
}

