/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event.keyboard;

import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.AttributedCharacterIterator;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.enums.MouseHandlerType;
import net.perspective.draw.event.keyboard.KeyboardHandler;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Text;
import net.perspective.draw.text.Editor;

public class TextKeyboardHandler
extends KeyboardHandler
implements KeyListener,
InputMethodListener {
    private final CanvasView view;
    private DrawingType drawingtype;
    private MouseHandlerType handlerType = MouseHandlerType.SELECTION;
    private int selection = -1;
    private boolean isEditing = false;
    private boolean pressed = false;
    private boolean selectToLeft = false;
    private int composedTextStartIndex = -1;
    private int composedTextEndIndex = -1;
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");

    public TextKeyboardHandler(DrawingCanvas c) {
        super(c);
        this.view = c.getView();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        DrawItem drawitem;
        int key = e.getKeyCode();
        Editor editor = this.view.getTextController().getEditor();
        this.selection = this.view.getSelected();
        if (this.selection != -1 && this.view.isEditing() && (drawitem = this.view.getDrawings().get(this.selection)) instanceof Text) {
            Text item = (Text)drawitem;
            int metaMask = this.getKeyMask();
            int modifiersEx = e.getModifiersEx();
            int textlength = editor.getLength();
            switch (key) {
                case 65: {
                    if ((modifiersEx & metaMask) != metaMask) break;
                    editor.setCaretStart(0);
                    editor.setCaretEnd(textlength);
                    break;
                }
                case 66: {
                    if ((modifiersEx & metaMask) != metaMask) break;
                    this.view.getTextController().formatSelectedText(1);
                    break;
                }
                case 73: {
                    if ((modifiersEx & metaMask) != metaMask) break;
                    this.view.getTextController().formatSelectedText(2);
                    break;
                }
                case 85: {
                    if ((modifiersEx & metaMask) != metaMask) break;
                    this.view.getTextController().formatSelectedText(4);
                    break;
                }
                case 61: 
                case 107: 
                case 521: {
                    if ((modifiersEx & metaMask) != metaMask) break;
                    this.canvas.getToolPanel().incrementFontSize(this.canvas.getFontSize());
                    break;
                }
                case 45: 
                case 109: {
                    if ((modifiersEx & metaMask) != metaMask) break;
                    this.canvas.getToolPanel().decrementFontSize(this.canvas.getFontSize());
                    break;
                }
                case 59: {
                    if ((modifiersEx & metaMask) != metaMask) break;
                    this.view.insertDateAndTime(item);
                    break;
                }
                case 8: {
                    editor.backSpace();
                    editor.commitText(item);
                    break;
                }
                case 37: {
                    if ((modifiersEx & 0x40) == 64) {
                        if (editor.getCaretStart() == editor.getCaretEnd()) {
                            this.selectToLeft = true;
                        }
                        if (this.selectToLeft) {
                            if (editor.getCaretStart() <= 0) break;
                            editor.setCaretStart(editor.getCaretStart() - 1);
                            break;
                        }
                        if (editor.getCaretEnd() <= 0) break;
                        editor.setCaretEnd(editor.getCaretEnd() - 1);
                        break;
                    }
                    if (editor.getCaretStart() == editor.getCaretEnd() && editor.getCaretStart() > 0) {
                        editor.setCaretStart(editor.getCaretStart() - 1);
                    }
                    editor.setCaretEnd(editor.getCaretStart());
                    break;
                }
                case 39: {
                    if ((modifiersEx & 0x40) == 64) {
                        if (editor.getCaretStart() == editor.getCaretEnd()) {
                            this.selectToLeft = false;
                        }
                        if (this.selectToLeft) {
                            if (editor.getCaretStart() >= textlength) break;
                            editor.setCaretStart(editor.getCaretStart() + 1);
                            break;
                        }
                        if (editor.getCaretEnd() >= textlength) break;
                        editor.setCaretEnd(editor.getCaretEnd() + 1);
                        break;
                    }
                    if (editor.getCaretStart() == editor.getCaretEnd()) {
                        if (editor.getCaretStart() < textlength) {
                            editor.setCaretStart(editor.getCaretStart() + 1);
                        }
                        editor.setCaretEnd(editor.getCaretStart());
                        break;
                    }
                    editor.setCaretStart(editor.getCaretEnd());
                    break;
                }
                case 127: {
                    editor.deleteChar();
                    editor.commitText(item);
                    break;
                }
                case 36: {
                    editor.setCaretStart(0);
                    if ((modifiersEx & 0x40) == 64) break;
                    editor.setCaretEnd(0);
                    break;
                }
                case 35: {
                    if ((modifiersEx & 0x40) != 64) {
                        editor.setCaretStart(textlength);
                    }
                    editor.setCaretEnd(textlength);
                    break;
                }
                case 10: {
                    editor.commitText(item);
                    this.view.updateSelectedItem();
                    this.view.setSelected(-1);
                    this.view.setEditing(KeyboardHandlerType.MOVE);
                    editor.setCaretStart(0);
                    editor.setCaretEnd(0);
                    break;
                }
            }
            item.setDimensions(this.canvas);
            this.canvas.repaint();
        }
        switch (key) {
            case 18: {
                if (!this.pressed) {
                    this.drawingtype = this.canvas.getDrawType().orElse(null);
                    this.handlerType = this.canvas.getHandlerType();
                    this.selection = this.view.getSelected();
                    this.canvas.setDrawType(null);
                    this.canvas.changeHandler(MouseHandlerType.SELECTION);
                    this.isEditing = this.view.isEditing();
                    this.view.setEditing(false);
                    this.pressed = true;
                }
                this.canvas.setMultiSelectEnabled(true);
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 18: {
                this.canvas.setDrawType(this.drawingtype);
                this.canvas.changeHandler(this.handlerType);
                this.canvas.setMultiSelectEnabled(false);
                this.view.setEditing(this.isEditing);
                this.view.setSelected(this.selection);
                this.pressed = false;
                break;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        DrawItem drawitem;
        Editor editor = this.view.getTextController().getEditor();
        this.selection = this.view.getSelected();
        if (this.selection != -1 && this.view.isEditing() && (drawitem = this.view.getDrawings().get(this.selection)) instanceof Text) {
            Text item = (Text)drawitem;
            int metaMask = this.getKeyMask();
            char c = e.getKeyChar();
            int modifiersEx = e.getModifiersEx();
            if ((modifiersEx & metaMask) != metaMask && Character.getType(c) != 15) {
                editor.insertChar(c);
                editor.commitText(item);
            }
            item.setDimensions(this.canvas);
            this.canvas.repaint();
        }
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent e) {
        DrawItem drawitem;
        int commitCount = e.getCommittedCharacterCount();
        AttributedCharacterIterator text = e.getText();
        Editor editor = this.view.getTextController().getEditor();
        if (this.view.getSelected() != -1 && this.view.isEditing() && (drawitem = this.view.getDrawings().get(this.view.getSelected())) instanceof Text) {
            Text item = (Text)drawitem;
            if (this.composedTextExists()) {
                for (int i = 0; i < this.composedTextEndIndex; ++i) {
                    editor.backSpace();
                    editor.commitText(item);
                }
                item.setDimensions(this.canvas);
                this.canvas.repaint();
            }
            if (text != null) {
                char c;
                text.first();
                int committedTextStartIndex = 0;
                int committedTextEndIndex = 0;
                if (commitCount > 0) {
                    c = text.current();
                    while (commitCount > 0) {
                        ++committedTextEndIndex;
                        c = text.next();
                        --commitCount;
                    }
                }
                this.composedTextEndIndex = 0;
                c = text.first();
                while (c != '\uffff') {
                    if (Character.getType(c) != 15) {
                        editor.insertChar(c);
                        editor.commitText(item);
                    }
                    item.setDimensions(this.canvas);
                    this.canvas.repaint();
                    c = text.next();
                    ++this.composedTextEndIndex;
                }
                this.composedTextStartIndex = committedTextStartIndex != committedTextEndIndex ? -1 : 0;
            }
        }
    }

    @Override
    public void caretPositionChanged(InputMethodEvent e) {
    }

    private boolean composedTextExists() {
        return this.composedTextStartIndex != -1;
    }

    private int getKeyMask() {
        int metaMask = MAC_OS_X ? 256 : 128;
        return metaMask;
    }
}

