/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event.keyboard;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.enums.MouseHandlerType;
import net.perspective.draw.event.keyboard.KeyboardHandler;
import net.perspective.draw.geom.DrawItem;

public class MovementHandler
extends KeyboardHandler
implements KeyListener {
    private final CanvasView view;
    private DrawingType drawingtype;
    private MouseHandlerType handlertype;
    private boolean pressed = false;

    public MovementHandler(DrawingCanvas c) {
        super(c);
        this.view = c.getView();
        this.handlertype = MouseHandlerType.SELECTION;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (this.view.getSelected() != -1 && !this.view.isEditing()) {
            DrawItem item = this.view.getDrawings().get(this.view.getSelected());
            switch (key) {
                case 38: {
                    if (this.canvas.isRotationMode()) break;
                    this.canvas.snapUp(item);
                    break;
                }
                case 40: {
                    if (this.canvas.isRotationMode()) break;
                    this.canvas.snapDown(item);
                    break;
                }
                case 37: {
                    if (this.canvas.isRotationMode()) {
                        this.canvas.rotateLeft(item);
                        break;
                    }
                    this.canvas.snapLeft(item);
                    break;
                }
                case 39: {
                    if (this.canvas.isRotationMode()) {
                        this.canvas.rotateRight(item);
                        break;
                    }
                    this.canvas.snapRight(item);
                    break;
                }
                case 127: {
                    this.view.deleteSelectedItem();
                    break;
                }
            }
            this.view.updateSelectedItem();
        }
        switch (key) {
            case 18: {
                if (!this.pressed) {
                    this.drawingtype = this.canvas.getDrawType().orElse(null);
                    this.handlertype = this.canvas.getHandlerType();
                    this.canvas.setDrawType(null);
                    this.canvas.changeHandler(MouseHandlerType.SELECTION);
                    this.pressed = true;
                }
                this.canvas.setMultiSelectEnabled(true);
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 18: {
                this.canvas.setDrawType(this.drawingtype);
                this.canvas.changeHandler(this.handlertype);
                this.canvas.setMultiSelectEnabled(false);
                this.pressed = false;
                break;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

