/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event.keyboard;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.enums.MouseHandlerType;
import net.perspective.draw.event.keyboard.KeyboardHandler;

public class MapKeyboardHandler
extends KeyboardHandler
implements KeyListener {
    private final CanvasView view;
    private DrawingType drawingtype;
    private MouseHandlerType handlerType = MouseHandlerType.SELECTION;
    private int selection = -1;
    private boolean isMapping = false;
    private boolean pressed = false;

    public MapKeyboardHandler(DrawingCanvas c) {
        super(c);
        this.view = c.getView();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (this.view.getSelected() != -1 && this.view.isMapping()) {
            switch (key) {
                case 38: {
                    this.canvas.getMapController().moveMap(0, -20);
                    break;
                }
                case 40: {
                    this.canvas.getMapController().moveMap(0, 20);
                    break;
                }
                case 37: {
                    this.canvas.getMapController().moveMap(-20, 0);
                    break;
                }
                case 39: {
                    this.canvas.getMapController().moveMap(20, 0);
                    break;
                }
                case 27: {
                    this.canvas.exitMapping();
                    break;
                }
            }
        }
        switch (key) {
            case 18: {
                if (!this.pressed) {
                    this.drawingtype = this.canvas.getDrawType().orElse(null);
                    this.handlerType = this.canvas.getHandlerType();
                    this.selection = this.view.getSelected();
                    this.canvas.setDrawType(null);
                    this.canvas.changeHandler(MouseHandlerType.SELECTION);
                    this.isMapping = this.view.isMapping();
                    this.view.setMapping(false);
                    this.pressed = true;
                }
                this.canvas.setMultiSelectEnabled(true);
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 18: {
                this.canvas.setDrawType(this.drawingtype);
                this.canvas.changeHandler(this.handlerType);
                this.canvas.setMultiSelectEnabled(false);
                this.view.setMapping(this.isMapping);
                this.view.setSelected(this.selection);
                this.canvas.getMapController().initMap();
                this.pressed = false;
                break;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.view.getSelected() != -1 && this.view.isMapping()) {
            char c = e.getKeyChar();
            switch (c) {
                case '+': {
                    this.canvas.getMapController().zoomIn();
                    break;
                }
                case '-': {
                    this.canvas.getMapController().zoomOut();
                    break;
                }
            }
        }
    }
}

