/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event.behaviours;

import java.awt.Cursor;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.TextController;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.behaviours.BehaviourContext;
import net.perspective.draw.event.behaviours.ItemBehaviours;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Text;
import net.perspective.draw.text.Editor;

public class TextItemBehaviour
implements ItemBehaviours {
    @Override
    public boolean selectItem(BehaviourContext context, DrawItem item, int index) {
        CanvasMouseListener listener = context.getListener();
        Editor editor = context.getView().getTextController().getEditor();
        TextLayout layout = context.getCanvas().getTextLayout(item);
        TextHitInfo currentHit = item.isVertical() ? layout.hitTestChar((float)(listener.getTempX() - item.getTop()[0].x), (float)(listener.getTempY() - item.getTop()[0].y)) : layout.hitTestChar((float)(listener.getTempX() - item.getTop()[0].x), (float)(listener.getTempY() - item.getTop()[0].y));
        editor.setCaretStart(currentHit.getInsertionIndex());
        editor.setCaretEnd(editor.getCaretStart());
        return true;
    }

    @Override
    public void editItem(BehaviourContext context, DrawItem item, int index) {
        CanvasMouseListener listener = context.getListener();
        CanvasView view = context.getView();
        DrawingCanvas canvas = context.getCanvas();
        TextController textController = view.getTextController();
        if (textController.isRichText()) {
            canvas.setFontStyle(0);
            canvas.getToolPanel().resetFormattingButtons();
        }
        TextLayout layout = canvas.getTextLayout(item);
        TextHitInfo currentHit = item.isVertical() ? layout.hitTestChar((float)(listener.getTempX() - item.getTop()[0].x), (float)(listener.getTempY() - item.getTop()[0].y)) : layout.hitTestChar((float)(listener.getTempX() - item.getTop()[0].x), (float)(listener.getTempY() - item.getTop()[0].y));
        textController.editItem((Text)item, currentHit.getInsertionIndex());
        view.setSelected(index);
        view.setEditing(KeyboardHandlerType.TEXT);
    }

    @Override
    public void hoverItem(BehaviourContext context, DrawItem item) {
        CanvasMouseListener listener = context.getListener();
        DrawingCanvas canvas = context.getCanvas();
        if (((Text)item).contains(listener.getTempX(), listener.getTempY()) && context.getView().isEditing()) {
            canvas.setCursor(new Cursor(2));
        } else {
            canvas.setCursor(new Cursor(0));
        }
    }

    @Override
    public void alterItem(BehaviourContext context, DrawItem item, double x, double y) {
        CanvasMouseListener listener = context.getListener();
        CanvasView view = context.getView();
        Editor editor = view.getTextController().getEditor();
        TextLayout layout = context.getCanvas().getTextLayout(item);
        TextHitInfo currentHit = item.isVertical() ? layout.hitTestChar((float)(listener.getTempX() - item.getTop()[0].x), (float)(listener.getTempY() - item.getTop()[0].y)) : layout.hitTestChar((float)(listener.getTempX() - item.getTop()[0].x), (float)(listener.getTempY() - item.getTop()[0].y));
        int select = currentHit.getInsertionIndex();
        if (select > editor.getCaretStart()) {
            editor.setCaretEnd(select);
        } else if (select < editor.getCaretEnd()) {
            editor.setCaretStart(select);
        }
    }
}

