/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event.behaviours;

import java.awt.Cursor;
import java.util.List;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.ContainsType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.behaviours.BehaviourContext;
import net.perspective.draw.event.behaviours.ItemBehaviours;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.R2;
import net.perspective.draw.util.V2;

public class PictureItemBehaviour
implements ItemBehaviours {
    @Override
    public boolean selectItem(BehaviourContext context, DrawItem item, int index) {
        boolean found = false;
        CanvasMouseListener listener = context.getListener();
        CanvasView view = context.getView();
        List<CanvasPoint[]> vertices = ((Picture)item).getVertices();
        CanvasPoint centre = item.rotationCentre();
        for (CanvasPoint[] vertex : vertices) {
            if (!context.getRegion(vertex[0]).contains(listener.getStartX(), listener.getStartY())) continue;
            int quad = R2.quadrant(vertex[1], centre);
            switch (quad) {
                case 0: {
                    view.setSelected(index);
                    context.setContainment(ContainsType.TR);
                    found = true;
                    break;
                }
                case 1: {
                    view.setSelected(index);
                    context.setContainment(ContainsType.TL);
                    found = true;
                    break;
                }
                case 2: {
                    view.setSelected(index);
                    context.setContainment(ContainsType.BL);
                    found = true;
                    break;
                }
                case 3: {
                    view.setSelected(index);
                    context.setContainment(ContainsType.BR);
                    found = true;
                    break;
                }
            }
        }
        if (found) {
            context.setSgndArea(((Picture)item).sgnd_area());
        }
        if (!found && item.contains(listener.getStartX(), listener.getStartY())) {
            view.setSelected(index);
            context.setContainment(ContainsType.SHAPE);
            found = true;
        }
        return found;
    }

    @Override
    public void hoverItem(BehaviourContext context, DrawItem item) {
        CanvasPoint centre;
        CanvasMouseListener listener = context.getListener();
        DrawingCanvas canvas = context.getCanvas();
        List<CanvasPoint[]> vertices = ((Picture)item).getVertices();
        boolean found = this.switchVertices(context, vertices, centre = item.rotationCentre());
        if (!found) {
            if (item.contains(listener.getTempX(), listener.getTempY())) {
                canvas.setCursor(new Cursor(12));
            } else {
                canvas.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void alterItem(BehaviourContext context, DrawItem item, double xinc, double yinc) {
        if (context.getContainment().equals((Object)ContainsType.SHAPE)) {
            if (context.getListener().isSnapEnabled()) {
                xinc = context.getOmega().getX() - item.getStart().getX();
                yinc = context.getOmega().getY() - item.getStart().getY();
                context.getCanvas().moveToWithIncrements(item, xinc, yinc);
            } else {
                item.moveTo(xinc, yinc);
            }
        } else {
            ContainsType contains;
            CanvasPoint st = item.getStart();
            CanvasPoint en = item.getEnd();
            double scale = ((Picture)item).getScale();
            if (!context.getContainment().equals((Object)ContainsType.SHAPE) && !context.getContainment().equals((Object)ContainsType.NONE)) {
                if (context.getContains().equals((Object)ContainsType.NONE)) {
                    context.setContains(R2.permute(context.getContainment(), R2.quadrant(st, item.rotationCentre())));
                }
                contains = context.getContains();
            } else {
                contains = context.getContainment();
            }
            if (context.getQuad() == -1) {
                int quad = R2.quadrant(item.getTop()[1], item.rotationCentre());
                context.setQuad(quad);
            }
            CanvasPoint s = new CanvasPoint(st.x, st.y);
            CanvasPoint e = new CanvasPoint(st.x + en.x * scale, st.y + en.y * scale);
            int[] flip = R2.flip(context.getQuad());
            int cos_t = flip[0];
            int sin_t = flip[1];
            int csx_t = flip[2];
            int csy_t = flip[3];
            double t = item.getAngle() + (item.isVertical() ? -1.5707963267948966 : 0.0);
            double delta = V2.norm_angle(4.0 * t + Math.PI * 2) / 2.0;
            CanvasPoint inc = V2.rot(xinc, yinc, t - delta);
            if (context.getSgndArea() >= 0.0) {
                inc.x = -inc.x;
                inc.y = -inc.y;
            }
            double cni = Math.max(Math.abs(inc.x), Math.abs(inc.y));
            double sgnx = Math.signum(inc.x);
            double sgny = Math.signum(inc.y);
            inc.x = sgnx * cni;
            inc.y = sgny * cni * en.y / en.x;
            boolean sgnD = sgnx == sgny;
            switch (contains) {
                case TL: {
                    if (context.getQuad() == 0 || context.getQuad() == 2) {
                        s.translate((double)(cos_t - sin_t) * inc.x, (double)(cos_t + sin_t) * (sgnD ? -sgnx * Math.abs(inc.y) : inc.y));
                        e.translate((double)(-cos_t + sin_t + csy_t) * inc.x, (double)(-cos_t - sin_t + csx_t) * inc.y);
                    } else {
                        s.translate((double)(cos_t - sin_t) * (sgnD ? inc.x : -sgnx * Math.abs(inc.x)), (double)(cos_t + sin_t) * inc.y);
                        e.translate((double)(-cos_t + sin_t + csy_t) * inc.x, (double)(-cos_t - sin_t + csx_t) * inc.y);
                    }
                    item.setStart(s.x, s.y);
                    double sgn = Math.signum(e.x - s.x);
                    CanvasPoint end = new CanvasPoint(e.x - s.x, e.y - s.y);
                    ((Picture)item).setScale(V2.L2(end) * sgn / V2.L2(en));
                    break;
                }
                case BL: {
                    if (context.getQuad() == 0 || context.getQuad() == 2) {
                        s.translate((double)(cos_t + sin_t) * (sgnD ? inc.x : -sgnx * Math.abs(inc.x)), (double)(-cos_t + sin_t + csy_t) * inc.y);
                        e.translate((double)(-cos_t - sin_t + csx_t) * inc.x, (double)(cos_t - sin_t) * inc.y);
                    } else {
                        s.translate((double)(cos_t + sin_t) * (sgnD ? -sgnx * Math.abs(inc.x) : inc.x), (double)(-cos_t + sin_t + csy_t) * inc.y);
                        e.translate((double)(-cos_t - sin_t + csx_t) * inc.x, (double)(cos_t - sin_t) * (sgnD ? sgnx * Math.abs(inc.y) : inc.y));
                    }
                    item.setStart(s.x, s.y);
                    double sgn = Math.signum(e.y - s.y);
                    CanvasPoint end = new CanvasPoint(e.x - s.x, e.y - s.y);
                    ((Picture)item).setScale(V2.L2(end) * sgn / V2.L2(en));
                    break;
                }
                case BR: {
                    if (context.getQuad() == 0 || context.getQuad() == 2) {
                        s.translate((double)(-cos_t + sin_t + csy_t) * inc.x, (double)(-cos_t - sin_t + csx_t) * inc.y);
                        e.translate((double)(cos_t - sin_t) * inc.x, (double)(cos_t + sin_t) * (sgnD ? -sgnx * Math.abs(inc.y) : inc.y));
                    } else {
                        s.translate((double)(-cos_t + sin_t + csy_t) * inc.x, (double)(-cos_t - sin_t + csx_t) * inc.y);
                        e.translate((double)(cos_t - sin_t) * (sgnD ? inc.x : -sgnx * Math.abs(inc.x)), (double)(cos_t + sin_t) * inc.y);
                    }
                    item.setStart(s.x, s.y);
                    double sgn = Math.signum(e.x - s.x);
                    CanvasPoint end = new CanvasPoint(e.x - s.x, e.y - s.y);
                    ((Picture)item).setScale(V2.L2(end) * sgn / V2.L2(en));
                    break;
                }
                case TR: {
                    if (context.getQuad() == 0 || context.getQuad() == 2) {
                        s.translate((double)(-cos_t - sin_t + csx_t) * inc.x, (double)(cos_t - sin_t) * (sgnD ? inc.y : sgnx * Math.abs(inc.y)));
                        e.translate((double)(cos_t + sin_t) * inc.x, (double)(-cos_t + sin_t + csy_t) * inc.y);
                    } else {
                        s.translate((double)(-cos_t - sin_t + csx_t) * inc.x, (double)(cos_t - sin_t) * (sgnD ? sgnx * Math.abs(inc.y) : inc.y));
                        e.translate((double)(cos_t + sin_t) * (sgnD ? -sgnx * Math.abs(inc.x) : inc.x), (double)(-cos_t + sin_t + csy_t) * inc.y);
                    }
                    item.setStart(s.x, s.y);
                    double sgn = Math.signum(e.y - s.y);
                    CanvasPoint end = new CanvasPoint(e.x - s.x, e.y - s.y);
                    ((Picture)item).setScale(V2.L2(end) * sgn / V2.L2(en));
                    break;
                }
                case SHAPE: {
                    if (context.getListener().isSnapEnabled()) {
                        xinc = context.getOmega().getX() - item.getStart().getX();
                        yinc = context.getOmega().getY() - item.getStart().getY();
                        context.getCanvas().moveToWithIncrements(item, xinc, yinc);
                        break;
                    }
                    item.moveTo(xinc, yinc);
                    break;
                }
            }
        }
    }

    @Override
    public void editItem(BehaviourContext context, DrawItem item, int index) {
    }

    private boolean switchVertices(BehaviourContext context, List<CanvasPoint[]> vertices, CanvasPoint centre) {
        boolean found = false;
        CanvasMouseListener listener = context.getListener();
        DrawingCanvas canvas = context.getCanvas();
        for (CanvasPoint[] vertex : vertices) {
            if (context.getRegion(vertex[0]).contains(listener.getTempX(), listener.getTempY())) {
                int octa = R2.octant(vertex[1], centre);
                switch (octa) {
                    case 0: {
                        canvas.setCursor(new Cursor(11));
                        found = true;
                        break;
                    }
                    case 1: {
                        canvas.setCursor(new Cursor(7));
                        found = true;
                        break;
                    }
                    case 2: {
                        canvas.setCursor(new Cursor(8));
                        found = true;
                        break;
                    }
                    case 3: {
                        canvas.setCursor(new Cursor(6));
                        found = true;
                        break;
                    }
                    case 4: {
                        canvas.setCursor(new Cursor(10));
                        found = true;
                        break;
                    }
                    case 5: {
                        canvas.setCursor(new Cursor(4));
                        found = true;
                        break;
                    }
                    case 6: {
                        canvas.setCursor(new Cursor(9));
                        found = true;
                        break;
                    }
                    case 7: {
                        canvas.setCursor(new Cursor(5));
                        found = true;
                    }
                }
            }
            if (!found) continue;
            break;
        }
        return found;
    }
}

