/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event.behaviours;

import java.awt.Cursor;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.ContainsType;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.enums.MouseHandlerType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.behaviours.BehaviourContext;
import net.perspective.draw.event.behaviours.ItemBehaviours;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.StreetMap;
import net.perspective.draw.util.CanvasPoint;

public class MapItemBehaviour
implements ItemBehaviours {
    @Override
    public boolean selectItem(BehaviourContext context, DrawItem item, int index) {
        boolean found = false;
        CanvasMouseListener listener = context.getListener();
        CanvasView view = context.getView();
        if (context.getRegion(item.getTop()[0]).contains(listener.getStartX(), listener.getStartY())) {
            view.setSelected(index);
            context.setContainment(ContainsType.TL);
            found = true;
        } else if (context.getRegion(item.getDown()[0]).contains(listener.getStartX(), listener.getStartY())) {
            view.setSelected(index);
            context.setContainment(ContainsType.BL);
            found = true;
        } else if (context.getRegion(item.getBottom()[0]).contains(listener.getStartX(), listener.getStartY())) {
            view.setSelected(index);
            context.setContainment(ContainsType.BR);
            found = true;
        } else if (context.getRegion(item.getUp()[0]).contains(listener.getStartX(), listener.getStartY())) {
            view.setSelected(index);
            context.setContainment(ContainsType.TR);
            found = true;
        } else if (item.contains(listener.getStartX(), listener.getStartY())) {
            view.setSelected(index);
            context.setContainment(ContainsType.SHAPE);
            found = true;
        }
        context.zero_err();
        return found;
    }

    @Override
    public void editItem(BehaviourContext context, DrawItem item, int index) {
        CanvasView view = context.getView();
        DrawingCanvas canvas = context.getCanvas();
        view.setSelected(index);
        view.setEditing(KeyboardHandlerType.MAP);
        canvas.changeHandler(MouseHandlerType.MAP);
        canvas.getMapController().initMap();
    }

    @Override
    public void hoverItem(BehaviourContext context, DrawItem item) {
        CanvasMouseListener listener = context.getListener();
        DrawingCanvas canvas = context.getCanvas();
        if (item.contains(listener.getTempX(), listener.getTempY())) {
            canvas.setCursor(new Cursor(12));
        } else {
            canvas.setCursor(new Cursor(0));
        }
    }

    @Override
    public void alterItem(BehaviourContext context, DrawItem item, double xinc, double yinc) {
        DrawingCanvas canvas = context.getCanvas();
        CanvasPoint st = item.getStart();
        CanvasPoint e = item.getEnd();
        CanvasPoint en = new CanvasPoint(st.x + e.x, st.y + e.y);
        ContainsType contains = context.getContainment();
        double min_w = 248.0;
        double min_h = 180.0;
        double diffsx = en.x - st.x - xinc < min_w ? 0.0 : xinc;
        double diffsy = en.y - st.y - yinc < min_h ? 0.0 : yinc;
        double diffex = en.x - st.x + xinc < min_w ? 0.0 : xinc;
        double diffey = en.y - st.y + yinc < min_h ? 0.0 : yinc;
        switch (contains) {
            case TL: {
                st.translate(diffsx, diffsy);
                item.setStart(st.x, st.y);
                item.setEnd(en.x - st.x, en.y - st.y);
                canvas.getMapController().resizeMap((StreetMap)item, context.err_ix(-diffsx), context.err_iy(-diffsy));
                break;
            }
            case BL: {
                st.translate(diffsx, 0.0);
                en.translate(0.0, diffey);
                item.setStart(st.x, st.y);
                item.setEnd(en.x - st.x, en.y - st.y);
                canvas.getMapController().resizeMap((StreetMap)item, context.err_ix(-diffsx), context.err_iy(diffey));
                break;
            }
            case BR: {
                en.translate(diffex, diffey);
                item.setStart(st.x, st.y);
                item.setEnd(en.x - st.x, en.y - st.y);
                canvas.getMapController().resizeMap((StreetMap)item, context.err_ix(diffex), context.err_iy(diffey));
                break;
            }
            case TR: {
                st.translate(0.0, diffsy);
                en.translate(diffex, 0.0);
                item.setStart(st.x, st.y);
                item.setEnd(en.x - st.x, en.y - st.y);
                canvas.getMapController().resizeMap((StreetMap)item, context.err_ix(diffex), context.err_iy(-diffsy));
                break;
            }
            case SHAPE: {
                if (context.getListener().isSnapEnabled()) {
                    xinc = context.getOmega().getX() - item.getStart().getX();
                    yinc = context.getOmega().getY() - item.getStart().getY();
                    context.getCanvas().moveToWithIncrements(item, xinc, yinc);
                    break;
                }
                item.moveTo(xinc, yinc);
                break;
            }
        }
        canvas.getMapController().removeSlider();
    }
}

