/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event.behaviours;

import java.awt.Cursor;
import java.util.List;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.ContainsType;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.behaviours.BehaviourContext;
import net.perspective.draw.event.behaviours.ItemBehaviours;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureType;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.R2;
import net.perspective.draw.util.V2;

public class FigureItemBehaviour
implements ItemBehaviours {
    @Override
    public boolean selectItem(BehaviourContext context, DrawItem item, int index) {
        boolean found = false;
        CanvasMouseListener listener = context.getListener();
        CanvasView view = context.getView();
        FigureType type = ((Figure)item).getType();
        if (type.equals((Object)FigureType.CIRCLE) || type.equals((Object)FigureType.TRIANGLE) || type.equals((Object)FigureType.SQUARE) || type.equals((Object)FigureType.HEXAGON) || type.equals((Object)FigureType.PENTAGRAM)) {
            int quad;
            List<CanvasPoint[]> vertices = ((Figure)item).getVertices();
            CanvasPoint centre = item.rotationCentre();
            for (CanvasPoint[] vertex : vertices) {
                if (!context.getRegion(vertex[0]).contains(listener.getStartX(), listener.getStartY())) continue;
                quad = R2.quadrant(vertex[1], centre);
                switch (quad) {
                    case 0: {
                        view.setSelected(index);
                        context.setContainment(ContainsType.TR);
                        found = true;
                        break;
                    }
                    case 1: {
                        view.setSelected(index);
                        context.setContainment(ContainsType.TL);
                        found = true;
                        break;
                    }
                    case 2: {
                        view.setSelected(index);
                        context.setContainment(ContainsType.BL);
                        found = true;
                        break;
                    }
                    case 3: {
                        view.setSelected(index);
                        context.setContainment(ContainsType.BR);
                        found = true;
                        break;
                    }
                }
            }
            if (!found) {
                List<CanvasPoint[]> edges = ((Figure)item).getEdges();
                for (CanvasPoint[] edge : edges) {
                    if (!context.getRegion(edge[0]).contains(listener.getStartX(), listener.getStartY())) continue;
                    quad = R2.quarter(edge[1], centre);
                    switch (quad) {
                        case 0: {
                            view.setSelected(index);
                            context.setContainment(ContainsType.TT);
                            found = true;
                            break;
                        }
                        case 1: {
                            view.setSelected(index);
                            context.setContainment(ContainsType.LL);
                            found = true;
                            break;
                        }
                        case 2: {
                            view.setSelected(index);
                            context.setContainment(ContainsType.BB);
                            found = true;
                            break;
                        }
                        case 3: {
                            view.setSelected(index);
                            context.setContainment(ContainsType.RR);
                            found = true;
                            break;
                        }
                    }
                    context.setEdgeDetected(found);
                }
            }
            if (!found && item.contains(listener.getStartX(), listener.getStartY())) {
                view.setSelected(index);
                context.setContainment(ContainsType.SHAPE);
                found = true;
            }
        } else if (item.contains(listener.getStartX(), listener.getStartY())) {
            view.setSelected(index);
            context.setContainment(ContainsType.SHAPE);
            found = true;
        }
        return found;
    }

    @Override
    public void hoverItem(BehaviourContext context, DrawItem item) {
        CanvasMouseListener listener = context.getListener();
        DrawingCanvas canvas = context.getCanvas();
        switch (((Figure)item).getType()) {
            case LINE: {
                CanvasPoint st = item.getStart();
                CanvasPoint en = item.getEnd();
                if (context.getRegion(st).contains(listener.getTempX(), listener.getTempY())) {
                    canvas.setCursor(new Cursor(1));
                    break;
                }
                if (context.getRegion(en).contains(listener.getTempX(), listener.getTempY())) {
                    canvas.setCursor(new Cursor(1));
                    break;
                }
                if (item.contains(listener.getTempX(), listener.getTempY())) {
                    canvas.setCursor(new Cursor(12));
                    break;
                }
                canvas.setCursor(new Cursor(0));
                break;
            }
            case SQUARE: 
            case CIRCLE: 
            case TRIANGLE: 
            case HEXAGON: 
            case PENTAGRAM: {
                List<CanvasPoint[]> vertices = ((Figure)item).getVertices();
                CanvasPoint centre = item.rotationCentre();
                boolean found = this.switchVertices(context, vertices, centre);
                List<CanvasPoint[]> edges = ((Figure)item).getEdges();
                if (found |= this.switchVertices(context, edges, centre)) break;
                if (item.contains(listener.getTempX(), listener.getTempY())) {
                    canvas.setCursor(new Cursor(12));
                    break;
                }
                canvas.setCursor(new Cursor(0));
                break;
            }
            default: {
                if (item.contains(listener.getTempX(), listener.getTempY())) {
                    canvas.setCursor(new Cursor(12));
                    break;
                }
                canvas.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void alterItem(BehaviourContext context, DrawItem item, double xinc, double yinc) {
        CanvasMouseListener listener = context.getListener();
        FigureType type = ((Figure)item).getType();
        CanvasPoint st = item.getStart();
        CanvasPoint en = item.getEnd();
        if (context.getContainment().equals((Object)ContainsType.SHAPE)) {
            if (type == FigureType.LINE) {
                if (context.getRegion(st).contains(listener.getStartX(), listener.getStartY())) {
                    st.translate(xinc, yinc);
                    item.setStart(st.x, st.y);
                    item.setEnd(en.x, en.y);
                    ((Figure)item).setPoints(DrawingType.LINE);
                    ((Figure)item).setPath();
                } else if (context.getRegion(en).contains(listener.getStartX(), listener.getStartY())) {
                    en.translate(xinc, yinc);
                    item.setStart(st.x, st.y);
                    item.setEnd(en.x, en.y);
                    ((Figure)item).setPoints(DrawingType.LINE);
                    ((Figure)item).setPath();
                } else if (context.getListener().isSnapEnabled()) {
                    xinc = context.getOmega().getX() - item.getStart().getX();
                    yinc = context.getOmega().getY() - item.getStart().getY();
                    context.getCanvas().moveToWithIncrements(item, xinc, yinc);
                } else {
                    item.moveTo(xinc, yinc);
                }
            } else if (context.getListener().isSnapEnabled()) {
                xinc = context.getOmega().getX() - item.getStart().getX();
                yinc = context.getOmega().getY() - item.getStart().getY();
                context.getCanvas().moveToWithIncrements(item, xinc, yinc);
            } else {
                item.moveTo(xinc, yinc);
            }
        } else {
            block0 : switch (type) {
                case SQUARE: 
                case CIRCLE: 
                case TRIANGLE: 
                case HEXAGON: 
                case PENTAGRAM: {
                    ContainsType contains;
                    DrawingType drawType;
                    switch (type) {
                        case SQUARE: {
                            DrawingType drawingType = DrawingType.RECTANGLE;
                            break;
                        }
                        case CIRCLE: {
                            DrawingType drawingType = DrawingType.ELLIPSE;
                            break;
                        }
                        case TRIANGLE: {
                            DrawingType drawingType = DrawingType.ISOSCELES;
                            break;
                        }
                        case HEXAGON: {
                            DrawingType drawingType = DrawingType.HEXAGON;
                            break;
                        }
                        case PENTAGRAM: {
                            DrawingType drawingType = DrawingType.PENTAGRAM;
                            break;
                        }
                        default: {
                            DrawingType drawingType = drawType = DrawingType.RECTANGLE;
                        }
                    }
                    if (!context.getContainment().equals((Object)ContainsType.SHAPE) && !context.getContainment().equals((Object)ContainsType.NONE)) {
                        if (context.getContains().equals((Object)ContainsType.NONE) && !context.isEdgeDetected()) {
                            context.setContains(R2.permute(context.getContainment(), R2.quadrant(st, item.rotationCentre())));
                        }
                        if (context.getContains().equals((Object)ContainsType.NONE) && context.isEdgeDetected()) {
                            context.setContains(R2.mutate(context.getContainment(), R2.quadrant(st, item.rotationCentre())));
                        }
                        contains = context.getContains();
                    } else {
                        contains = context.getContainment();
                    }
                    if (context.getSgndArea() < 0.0) {
                        context.setSgndArea(((Figure)item).sgnd_area());
                    }
                    if (context.getQuad() == -1) {
                        int quad = R2.quadrant(item.getTop()[1], item.rotationCentre());
                        if (context.getSgndArea() >= 0.0 && (quad == 0 || quad == 2)) {
                            context.setQuad(R2.quadrant(item.getBottom()[1], item.rotationCentre()));
                        } else {
                            context.setQuad(quad);
                        }
                    }
                    int[] flip = R2.flip(context.getQuad());
                    int cos_t = flip[0];
                    int sin_t = flip[1];
                    double t = item.getAngle() + (item.isVertical() ? -1.5707963267948966 : 0.0);
                    double delta = V2.norm_angle(4.0 * t + Math.PI * 2) / 2.0;
                    CanvasPoint inc = V2.rot(xinc, yinc, t - delta);
                    switch (contains) {
                        case TL: {
                            st.translate((double)(cos_t - sin_t) * inc.x, (double)(cos_t + sin_t) * inc.y);
                            en.translate((double)(-cos_t + sin_t) * inc.x, (double)(-cos_t - sin_t) * inc.y);
                            item.setStart(st.x, st.y);
                            item.setEnd(en.x, en.y);
                            ((Figure)item).setPoints(drawType);
                            ((Figure)item).setPath();
                            break block0;
                        }
                        case BL: {
                            st.translate((double)(cos_t + sin_t) * inc.x, (double)(-cos_t + sin_t) * inc.y);
                            en.translate((double)(-cos_t - sin_t) * inc.x, (double)(cos_t - sin_t) * inc.y);
                            item.setStart(st.x, st.y);
                            item.setEnd(en.x, en.y);
                            ((Figure)item).setPoints(drawType);
                            ((Figure)item).setPath();
                            break block0;
                        }
                        case BR: {
                            st.translate((double)(-cos_t + sin_t) * inc.x, (double)(-cos_t - sin_t) * inc.y);
                            en.translate((double)(cos_t - sin_t) * inc.x, (double)(cos_t + sin_t) * inc.y);
                            item.setStart(st.x, st.y);
                            item.setEnd(en.x, en.y);
                            ((Figure)item).setPoints(drawType);
                            ((Figure)item).setPath();
                            break block0;
                        }
                        case TR: {
                            st.translate((double)(-cos_t - sin_t) * inc.x, (double)(cos_t - sin_t) * inc.y);
                            en.translate((double)(cos_t + sin_t) * inc.x, (double)(-cos_t + sin_t) * inc.y);
                            item.setStart(st.x, st.y);
                            item.setEnd(en.x, en.y);
                            ((Figure)item).setPoints(drawType);
                            ((Figure)item).setPath();
                            break block0;
                        }
                        case TT: {
                            st.translate((double)(0 - sin_t) * inc.x, (double)(cos_t + 0) * inc.y);
                            en.translate((double)(0 + sin_t) * inc.x, (double)(-cos_t - 0) * inc.y);
                            item.setStart(st.x, st.y);
                            item.setEnd(en.x, en.y);
                            ((Figure)item).setPoints(drawType);
                            ((Figure)item).setPath();
                            break block0;
                        }
                        case LL: {
                            st.translate((double)(cos_t + 0) * inc.x, (double)(0 + sin_t) * inc.y);
                            en.translate((double)(-cos_t - 0) * inc.x, (double)(0 - sin_t) * inc.y);
                            item.setStart(st.x, st.y);
                            item.setEnd(en.x, en.y);
                            ((Figure)item).setPoints(drawType);
                            ((Figure)item).setPath();
                            break block0;
                        }
                        case BB: {
                            st.translate((double)(0 + sin_t) * inc.x, (double)(-cos_t - 0) * inc.y);
                            en.translate((double)(0 - sin_t) * inc.x, (double)(cos_t + 0) * inc.y);
                            item.setStart(st.x, st.y);
                            item.setEnd(en.x, en.y);
                            ((Figure)item).setPoints(drawType);
                            ((Figure)item).setPath();
                            break block0;
                        }
                        case RR: {
                            st.translate((double)(-cos_t - 0) * inc.x, (double)(0 - sin_t) * inc.y);
                            en.translate((double)(cos_t + 0) * inc.x, (double)(0 + sin_t) * inc.y);
                            item.setStart(st.x, st.y);
                            item.setEnd(en.x, en.y);
                            ((Figure)item).setPoints(drawType);
                            ((Figure)item).setPath();
                            break block0;
                        }
                        case SHAPE: {
                            if (context.getListener().isSnapEnabled()) {
                                xinc = context.getOmega().getX() - item.getStart().getX();
                                yinc = context.getOmega().getY() - item.getStart().getY();
                                context.getCanvas().moveToWithIncrements(item, xinc, yinc);
                                break block0;
                            }
                            item.moveTo(xinc, yinc);
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    if (context.getListener().isSnapEnabled()) {
                        xinc = context.getOmega().getX() - item.getStart().getX();
                        yinc = context.getOmega().getY() - item.getStart().getY();
                        context.getCanvas().moveToWithIncrements(item, xinc, yinc);
                        break;
                    }
                    item.moveTo(xinc, yinc);
                }
            }
        }
    }

    @Override
    public void editItem(BehaviourContext context, DrawItem item, int index) {
    }

    private boolean switchVertices(BehaviourContext context, List<CanvasPoint[]> vertices, CanvasPoint centre) {
        boolean found = false;
        CanvasMouseListener listener = context.getListener();
        DrawingCanvas canvas = context.getCanvas();
        for (CanvasPoint[] vertex : vertices) {
            if (context.getRegion(vertex[0]).contains(listener.getTempX(), listener.getTempY())) {
                int octa = R2.octant(vertex[1], centre);
                switch (octa) {
                    case 0: {
                        canvas.setCursor(new Cursor(11));
                        found = true;
                        break;
                    }
                    case 1: {
                        canvas.setCursor(new Cursor(7));
                        found = true;
                        break;
                    }
                    case 2: {
                        canvas.setCursor(new Cursor(8));
                        found = true;
                        break;
                    }
                    case 3: {
                        canvas.setCursor(new Cursor(6));
                        found = true;
                        break;
                    }
                    case 4: {
                        canvas.setCursor(new Cursor(10));
                        found = true;
                        break;
                    }
                    case 5: {
                        canvas.setCursor(new Cursor(4));
                        found = true;
                        break;
                    }
                    case 6: {
                        canvas.setCursor(new Cursor(9));
                        found = true;
                        break;
                    }
                    case 7: {
                        canvas.setCursor(new Cursor(5));
                        found = true;
                    }
                }
            }
            if (!found) continue;
            break;
        }
        return found;
    }
}

