/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event.behaviours;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.ContainsType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.EventHandler;
import net.perspective.draw.event.behaviours.ItemBehaviours;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.util.CanvasPoint;
import org.openstreetmap.gui.jmapviewer.OsmMercator;

public class BehaviourContext {
    private final DrawingCanvas canvas;
    private final EventHandler handler;
    private ItemBehaviours strategy;
    private ContainsType containment;
    private ContainsType contains;
    private boolean edgeDetected;
    private int quad = -1;
    private double sgnd_area = -1.0;
    private double errX = 0.0;
    private double errY = 0.0;
    private CanvasPoint omega = new CanvasPoint(0.0, 0.0);

    public BehaviourContext(EventHandler handler, DrawingCanvas canvas) {
        this.canvas = canvas;
        this.handler = handler;
        this.containment = ContainsType.NONE;
        this.contains = ContainsType.NONE;
        this.edgeDetected = false;
    }

    public void setBehaviour(ItemBehaviours strategy) {
        this.strategy = strategy;
    }

    public boolean select(DrawItem item, int index) {
        return this.strategy.selectItem(this, item, index);
    }

    public void edit(DrawItem item, int index) {
        this.strategy.editItem(this, item, index);
    }

    public void hover(DrawItem item) {
        this.strategy.hoverItem(this, item);
    }

    public void alter(DrawItem item, double xinc, double yinc) {
        this.strategy.alterItem(this, item, xinc, yinc);
    }

    public CanvasMouseListener getListener() {
        return this.handler.getListener();
    }

    public DrawingCanvas getCanvas() {
        return this.canvas;
    }

    public CanvasView getView() {
        return this.canvas.getView();
    }

    public void setContainment(ContainsType containment) {
        this.containment = containment;
    }

    public ContainsType getContainment() {
        return this.containment;
    }

    public void setContains(ContainsType contains) {
        this.contains = contains;
    }

    public ContainsType getContains() {
        return this.contains;
    }

    public void resetContainment() {
        this.containment = ContainsType.NONE;
        this.contains = ContainsType.NONE;
        this.quad = -1;
        this.sgnd_area = -1.0;
        this.setEdgeDetected(false);
        this.setOmega(0.0, 0.0);
    }

    protected void setEdgeDetected(boolean edgeDetected) {
        this.edgeDetected = edgeDetected;
    }

    protected boolean isEdgeDetected() {
        return this.edgeDetected;
    }

    public void setQuad(int quad) {
        this.quad = quad;
    }

    public int getQuad() {
        return this.quad;
    }

    public void setSgndArea(double sgnd_area) {
        this.sgnd_area = sgnd_area;
    }

    public double getSgndArea() {
        return this.sgnd_area;
    }

    public Area getRegion(CanvasPoint p) {
        Rectangle2D.Double rect = new Rectangle2D.Double(p.x - 10.0, p.y - 10.0, 20.0, 20.0);
        return new Area(rect);
    }

    public void zero_err() {
        this.errX = 0.0;
        this.errY = 0.0;
    }

    public int err_ix(double inc) {
        if (OsmMercator.isRetina()) {
            inc *= 2.0;
        }
        this.errX += inc / 2.0;
        int err = (int)Math.round(this.errX);
        this.errX -= (double)err;
        return err;
    }

    public int err_iy(double inc) {
        if (OsmMercator.isRetina()) {
            inc *= 2.0;
        }
        this.errY += inc / 2.0;
        int err = (int)Math.round(this.errY);
        this.errY -= (double)err;
        return err;
    }

    public void setOmega(double x, double y) {
        this.omega = new CanvasPoint(x, y);
    }

    public CanvasPoint getOmega() {
        return this.omega;
    }
}

