/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event;

import java.awt.Cursor;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.EventHandler;
import net.perspective.draw.event.behaviours.BehaviourContext;
import net.perspective.draw.event.behaviours.TextItemBehaviour;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Text;

public class TextMouseHandler
implements EventHandler {
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final BehaviourContext context;
    private CanvasMouseListener listener;

    public TextMouseHandler(DrawingCanvas canvas) {
        this.canvas = canvas;
        this.view = canvas.getView();
        this.context = new BehaviourContext(this, canvas);
    }

    @Override
    public void setListener(CanvasMouseListener listener) {
        this.listener = listener;
    }

    @Override
    public CanvasMouseListener getListener() {
        return this.listener;
    }

    @Override
    public void upEvent() {
    }

    @Override
    public void downEvent() {
        this.canvas.requestFocusInWindow();
        if (this.view.isEditing() && !this.listener.getRightClick()) {
            DrawItem item = this.view.getDrawings().get(this.view.getSelected());
            this.context.setBehaviour(new TextItemBehaviour());
            this.context.select(item, 0);
        }
        this.canvas.repaint();
    }

    @Override
    public void clickEvent() {
        DrawItem item;
        if (!this.view.isEditing()) {
            if (this.view.getTextController().isRichText()) {
                this.canvas.setFontStyle(0);
                this.canvas.getToolPanel().resetFormattingButtons();
            }
            Text item2 = new Text(this.listener.getTempX(), this.listener.getTempY());
            item2 = this.view.getTextController().initializeItem(item2);
            this.view.addItemToCanvas(item2);
            int i = this.view.getDrawings().size() - 1;
            this.view.setSelected(i);
            this.view.setEditing(KeyboardHandlerType.TEXT);
        } else if (this.view.getSelected() != -1 && ((Text)(item = this.view.getDrawings().get(this.view.getSelected()))).getAcceptBounds().contains(this.listener.getTempX(), this.listener.getTempY())) {
            this.view.getTextController().getEditor().commitText((Text)item);
            this.view.updateSelectedItem();
            this.view.setSelected(-1);
            this.view.setEditing(KeyboardHandlerType.MOVE);
            this.view.getTextController().getEditor().setCaretStart(0);
            this.view.getTextController().getEditor().setCaretEnd(0);
        }
    }

    @Override
    public void moveEvent() {
        if (this.view.getSelected() != -1) {
            DrawItem item = this.view.getDrawings().get(this.view.getSelected());
            if (item instanceof Text) {
                this.context.setBehaviour(new TextItemBehaviour());
                this.context.hover(item);
            }
        } else {
            this.canvas.setCursor(new Cursor(0));
        }
    }

    @Override
    public void dragEvent() {
        if (this.view.isEditing() && this.view.getSelected() != -1) {
            DrawItem item = this.view.getDrawings().get(this.view.getSelected());
            this.context.setBehaviour(new TextItemBehaviour());
            this.context.alter(item, 0.0, 0.0);
        }
        this.canvas.repaint();
    }

    @Override
    public void enterEvent() {
    }

    @Override
    public void exitEvent() {
    }

    @Override
    public void wheelEvent() {
    }
}

