/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event;

import java.awt.Cursor;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.EventHandler;
import net.perspective.draw.geom.ArrowLine;
import net.perspective.draw.geom.ArrowType;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureFactory;
import net.perspective.draw.geom.FigureFactoryImpl;
import net.perspective.draw.geom.FigureType;

public class SketchMouseHandler
implements EventHandler {
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final FigureFactory figurefactory;
    private CanvasMouseListener listener;

    public SketchMouseHandler(DrawingCanvas canvas) {
        this.canvas = canvas;
        this.view = canvas.getView();
        this.figurefactory = new FigureFactoryImpl();
    }

    @Override
    public void setListener(CanvasMouseListener listener) {
        this.listener = listener;
    }

    @Override
    public CanvasMouseListener getListener() {
        return this.listener;
    }

    @Override
    public void upEvent() {
        this.view.setDrawing(false);
        if (this.view.getNewItem().isEmpty() || this.canvas.getDrawType().isEmpty()) {
            return;
        }
        Figure item = (Figure)this.view.getNewItem().get();
        item.setEndPoints();
        this.view.addItemToCanvas(item);
    }

    @Override
    public void downEvent() {
        this.canvas.requestFocusInWindow();
        Figure item = this.figurefactory.createFigure(this.canvas.getDrawType().orElse(DrawingType.POINT));
        item.setPoints(this.canvas.getDrawType().orElse(DrawingType.POINT));
        item.addPoint(this.listener.getStartX(), this.listener.getStartY());
        item.setEndPoints();
        item.setPath();
        this.view.setNewItem(item);
        this.view.setDrawing(true);
        this.canvas.repaint();
    }

    @Override
    public void clickEvent() {
    }

    @Override
    public void moveEvent() {
        this.canvas.setCursor(new Cursor(0));
        if (!this.view.isDrawing()) {
            return;
        }
        this.canvas.repaint();
    }

    @Override
    public void dragEvent() {
        Figure item = this.view.getNewItem().orElse(null);
        if (item == null) {
            return;
        }
        if (!(item instanceof ArrowLine) && (this.canvas.getArrow().equals((Object)ArrowType.END) || this.canvas.getArrow().equals((Object)ArrowType.BOTH)) && !item.getType().equals((Object)FigureType.POLYGON)) {
            ArrowLine arrow = new ArrowLine(item);
            arrow.setArrowStroke(this.canvas.getPlainStroke());
            arrow.setArrowType(this.canvas.getArrow());
            item = arrow;
        }
        item.addPoint(this.listener.getTempX(), this.listener.getTempY());
        item.setPath();
        item.setEndPoints();
        this.view.setNewItem(item);
        this.canvas.repaint();
    }

    @Override
    public void enterEvent() {
    }

    @Override
    public void exitEvent() {
    }

    @Override
    public void wheelEvent() {
    }
}

