/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.ContainsType;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.EventHandler;
import net.perspective.draw.event.behaviours.BehaviourContext;
import net.perspective.draw.event.behaviours.FigureItemBehaviour;
import net.perspective.draw.event.behaviours.GroupedItemBehaviour;
import net.perspective.draw.event.behaviours.MapItemBehaviour;
import net.perspective.draw.event.behaviours.PictureItemBehaviour;
import net.perspective.draw.event.behaviours.TextItemBehaviour;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureFactory;
import net.perspective.draw.geom.FigureFactoryImpl;
import net.perspective.draw.geom.Grouped;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.geom.StreetMap;
import net.perspective.draw.geom.Text;
import net.perspective.draw.util.CanvasPoint;

public class SelectionMouseHandler
implements EventHandler {
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final BehaviourContext context;
    private final FigureFactory figurefactory;
    private CanvasMouseListener listener;
    private List<Double> coordsX;
    private List<Double> coordsY;
    private List<Double> midX;
    private List<Double> midY;
    private static final BasicStroke marqueeStroke = new BasicStroke(1.0f, 1, 1);
    private static final Color MARQUEE_COLOR = new Color(204, 102, 255);
    private static final Color FILL_COLOR = new Color(48, 96, 255);

    public SelectionMouseHandler(DrawingCanvas canvas) {
        this.canvas = canvas;
        this.view = canvas.getView();
        this.context = new BehaviourContext(this, canvas);
        this.figurefactory = new FigureFactoryImpl();
    }

    @Override
    public void setListener(CanvasMouseListener listener) {
        this.listener = listener;
    }

    @Override
    public CanvasMouseListener getListener() {
        return this.listener;
    }

    @Override
    public void upEvent() {
        if (this.view.isMarquee()) {
            this.view.setMarquee(false);
            this.canvas.setMultiSelectEnabled(true);
            this.view.selectShapes(this.canvas.getMarquee());
            this.canvas.setMultiSelectEnabled(false);
        }
        if (this.view.getSelected() != -1 && !this.view.isEditing() && !this.listener.getRightClick()) {
            this.view.updateSelectedItem();
            this.context.resetContainment();
        }
        this.view.setGuides(false);
        this.canvas.resetGuides();
        this.canvas.repaint();
    }

    @Override
    public void downEvent() {
        DrawItem selectedItem;
        DrawItem item;
        this.canvas.requestFocusInWindow();
        List<DrawItem> drawings = this.view.getDrawings();
        if (this.view.isEditing()) {
            if (!this.listener.getRightClick() && (item = drawings.get(this.view.getSelected())) instanceof Text) {
                this.context.setBehaviour(new TextItemBehaviour());
                this.context.select(item, this.view.getSelected());
            }
        } else if (!drawings.isEmpty() && !this.listener.getRightClick()) {
            int i = drawings.size() - 1;
            this.context.setContainment(ContainsType.NONE);
            do {
                boolean found;
                DrawItem item2;
                if ((item2 = drawings.get(i)) instanceof Figure) {
                    this.context.setBehaviour(new FigureItemBehaviour());
                    found = this.context.select(item2, i);
                    if (!found) continue;
                    break;
                }
                if (item2 instanceof Picture) {
                    if (item2 instanceof StreetMap) {
                        this.context.setBehaviour(new MapItemBehaviour());
                        found = this.context.select(item2, i);
                        if (!found) continue;
                        break;
                    }
                    this.context.setBehaviour(new PictureItemBehaviour());
                    found = this.context.select(item2, i);
                    if (!found) continue;
                    break;
                }
                if (item2 instanceof Grouped) {
                    this.context.setBehaviour(new GroupedItemBehaviour());
                    found = this.context.select(item2, i);
                    if (!found) continue;
                    break;
                }
                if (item2 == null || !item2.contains(this.listener.getStartX(), this.listener.getStartY())) continue;
                this.view.setSelected(i);
                this.context.setContainment(ContainsType.SHAPE);
                break;
            } while (--i >= 0);
            if (!(!this.context.getContainment().equals((Object)ContainsType.NONE) || this.view.isMultiSelected() && this.canvas.isMultiSelectEnabled())) {
                this.view.setSelected(-1);
            }
        }
        if (this.view.getSelected() != -1 && this.listener.isSnapEnabled() && (selectedItem = drawings.get(this.view.getSelected())) != null) {
            CanvasPoint start = selectedItem.getStart();
            this.context.setOmega(start.getX(), start.getY());
        }
        if (this.view.getSelected() != -1 && !this.listener.isSnapEnabled() && this.canvas.isGuideEnabled() && drawings.size() < 15) {
            this.coordsX = new ArrayList<Double>();
            this.coordsY = new ArrayList<Double>();
            this.midX = new ArrayList<Double>();
            this.midY = new ArrayList<Double>();
            item = drawings.get(this.view.getSelected());
            if (item != null) {
                for (DrawItem drawing : drawings) {
                    if (drawings.indexOf(drawing) == this.view.getSelected() || item.bounds().intersects(drawing.bounds().getBounds2D())) continue;
                    this.computeCoords(drawing);
                }
            }
        }
        this.canvas.repaint();
    }

    @Override
    public void clickEvent() {
        DrawItem item;
        this.context.setContainment(ContainsType.NONE);
        if (this.listener.doubleClicked()) {
            List<DrawItem> drawings = this.view.getDrawings();
            if (!drawings.isEmpty()) {
                int i = drawings.size() - 1;
                do {
                    DrawItem item2;
                    if (!(item2 = drawings.get(i)).contains(this.listener.getTempX(), this.listener.getTempY())) continue;
                    if (item2 instanceof Text) {
                        this.context.setBehaviour(new TextItemBehaviour());
                        this.context.edit(item2, i);
                        break;
                    }
                    if (!(item2 instanceof StreetMap)) continue;
                    this.context.setBehaviour(new MapItemBehaviour());
                    this.context.edit(item2, i);
                    break;
                } while (--i >= 0);
            }
            this.canvas.repaint();
        } else if (this.view.isEditing() && ((Text)(item = this.view.getDrawings().get(this.view.getSelected()))).getAcceptBounds().contains(this.listener.getTempX(), this.listener.getTempY())) {
            this.view.getTextController().getEditor().commitText((Text)item);
            this.view.updateSelectedItem();
            this.view.setSelected(-1);
            this.view.setEditing(KeyboardHandlerType.MOVE);
            this.view.getTextController().getEditor().setCaretStart(0);
            this.view.getTextController().getEditor().setCaretEnd(0);
        }
    }

    @Override
    public void moveEvent() {
        if (this.view.getSelected() != -1) {
            DrawItem item = this.view.getDrawings().get(this.view.getSelected());
            if (item instanceof Figure) {
                this.context.setBehaviour(new FigureItemBehaviour());
                this.context.hover(item);
            } else if (item instanceof Picture) {
                this.context.setBehaviour(new PictureItemBehaviour());
                this.context.hover(item);
            } else if (item instanceof Grouped) {
                this.context.setBehaviour(new GroupedItemBehaviour());
                this.context.hover(item);
            } else if (item instanceof Text) {
                this.context.setBehaviour(new TextItemBehaviour());
                this.context.hover(item);
            }
        } else if (this.canvas.getDropperDisabled()) {
            this.canvas.setCursor(new Cursor(0));
        } else {
            this.canvas.setCursor(new Cursor(12));
        }
    }

    @Override
    public void dragEvent() {
        if (this.view.getSelected() != -1) {
            double xinc = this.listener.getTempX() - this.listener.getStartX();
            double yinc = this.listener.getTempY() - this.listener.getStartY();
            for (Integer selection : this.view.getMultiSelection()) {
                DrawItem item = this.view.getDrawings().get(selection);
                if (this.listener.isSnapEnabled()) {
                    this.context.setOmega(this.context.getOmega().getX() + xinc, this.context.getOmega().getY() + yinc);
                } else if (this.canvas.isGuideEnabled() && this.view.getDrawings().size() < 15) {
                    this.view.setGuides(false);
                    this.canvas.resetGuides();
                    Double topX = item.getTop()[0].getX();
                    Double upX = item.getUp()[0].getX();
                    Double downX = item.getDown()[0].getX();
                    Double botX = item.getBottom()[0].getX();
                    Double minx = this.minimum(topX, upX, downX, botX);
                    Double maxx = this.maximum(topX, upX, downX, botX);
                    Double midx = (minx + maxx) / 2.0;
                    Double topY = item.getTop()[0].getY();
                    Double upY = item.getUp()[0].getY();
                    Double downY = item.getDown()[0].getY();
                    Double botY = item.getBottom()[0].getY();
                    Double miny = this.minimum(topY, upY, downY, botY);
                    Double maxy = this.maximum(topY, upY, downY, botY);
                    Double midy = (miny + maxy) / 2.0;
                    for (Double coord : this.coordsX) {
                        if (minx.intValue() == coord.intValue()) {
                            this.view.setGuides(true);
                            this.canvas.addGuide(false, minx);
                        }
                        if (maxx.intValue() != coord.intValue()) continue;
                        this.view.setGuides(true);
                        this.canvas.addGuide(false, maxx);
                    }
                    for (Double coord : this.coordsY) {
                        if (miny.intValue() == coord.intValue()) {
                            this.view.setGuides(true);
                            this.canvas.addGuide(true, miny);
                        }
                        if (maxy.intValue() != coord.intValue()) continue;
                        this.view.setGuides(true);
                        this.canvas.addGuide(true, maxy);
                    }
                    for (Double coord : this.midX) {
                        if (midx.intValue() != coord.intValue()) continue;
                        this.view.setGuides(true);
                        this.canvas.addGuide(false, midx);
                    }
                    for (Double coord : this.midY) {
                        if (midy.intValue() != coord.intValue()) continue;
                        this.view.setGuides(true);
                        this.canvas.addGuide(true, midy);
                    }
                }
                if (item instanceof Text) {
                    if (!this.context.getView().isEditing()) {
                        if (this.listener.isSnapEnabled()) {
                            xinc = this.context.getOmega().getX() - item.getStart().getX();
                            yinc = this.context.getOmega().getY() - item.getStart().getY();
                            this.canvas.moveToWithIncrements(item, xinc, yinc);
                        } else {
                            item.moveTo(xinc, yinc);
                        }
                    } else {
                        this.context.setBehaviour(new TextItemBehaviour());
                        this.context.alter(item, 0.0, 0.0);
                    }
                } else if (item instanceof Figure) {
                    this.context.setBehaviour(new FigureItemBehaviour());
                    this.context.alter(item, xinc, yinc);
                } else if (item instanceof Picture) {
                    if (item instanceof StreetMap) {
                        this.context.setBehaviour(new MapItemBehaviour());
                        this.context.alter(item, xinc, yinc);
                    } else {
                        this.context.setBehaviour(new PictureItemBehaviour());
                        this.context.alter(item, xinc, yinc);
                    }
                } else if (item instanceof Grouped) {
                    this.context.setBehaviour(new GroupedItemBehaviour());
                    this.context.alter(item, xinc, yinc);
                } else if (this.listener.isSnapEnabled()) {
                    xinc = this.context.getOmega().getX() - item.getStart().getX();
                    yinc = this.context.getOmega().getY() - item.getStart().getY();
                    this.canvas.moveToWithIncrements(item, xinc, yinc);
                } else {
                    item.moveTo(xinc, yinc);
                }
                item.updateProperties(this.canvas);
            }
            this.listener.setStartX(this.listener.getTempX());
            this.listener.setStartY(this.listener.getTempY());
        } else {
            this.view.setMarquee(true);
            Figure marquee = this.figurefactory.createFigure(DrawingType.RECTANGLE);
            marquee.setStart(this.listener.getStartX(), this.listener.getStartY());
            marquee.setEnd(this.listener.getTempX(), this.listener.getTempY());
            marquee.setPoints(DrawingType.RECTANGLE);
            marquee.setEndPoints();
            marquee.setPath();
            marquee.setStroke(marqueeStroke);
            marquee.setColor(MARQUEE_COLOR);
            marquee.setFillColor(FILL_COLOR);
            marquee.setTransparency(25);
            this.canvas.setMarquee(marquee);
        }
        this.canvas.repaint();
    }

    @Override
    public void enterEvent() {
    }

    @Override
    public void exitEvent() {
    }

    @Override
    public void wheelEvent() {
    }

    private void computeCoords(DrawItem item) {
        Double topX = item.getTop()[0].getX();
        Double upX = item.getUp()[0].getX();
        Double downX = item.getDown()[0].getX();
        Double botX = item.getBottom()[0].getX();
        Double minx = this.minimum(topX, upX, downX, botX);
        this.coordsX.add(minx);
        Double maxx = this.maximum(topX, upX, downX, botX);
        this.coordsX.add(maxx);
        this.midX.add((minx + maxx) / 2.0);
        Double topY = item.getTop()[0].getY();
        Double upY = item.getUp()[0].getY();
        Double downY = item.getDown()[0].getY();
        Double botY = item.getBottom()[0].getY();
        Double miny = this.minimum(topY, upY, downY, botY);
        this.coordsY.add(miny);
        Double maxy = this.maximum(topY, upY, downY, botY);
        this.coordsY.add(maxy);
        this.midY.add((miny + maxy) / 2.0);
    }

    private Double minimum(Double a, Double b, Double c, Double d) {
        Double min1 = Math.min(a, b);
        Double min2 = Math.min(c, d);
        Double min3 = Math.min(min1, min2);
        return min3;
    }

    private Double maximum(Double a, Double b, Double c, Double d) {
        Double max1 = Math.max(a, b);
        Double max2 = Math.max(c, d);
        Double max3 = Math.max(max1, max2);
        return max3;
    }
}

