/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event;

import java.awt.Cursor;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.EventHandler;
import net.perspective.draw.geom.ArrowLine;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Edge;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureType;
import net.perspective.draw.geom.Grouped;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.geom.StreetMap;
import net.perspective.draw.geom.Text;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.V2;

public class RotationMouseHandler
implements EventHandler {
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private CanvasMouseListener listener;
    private double omega;
    private final Map<CanvasPoint, Area> regionCache = new HashMap<CanvasPoint, Area>();
    private static final Cursor DEFAULT_CURSOR = new Cursor(0);
    private static final Cursor CROSSHAIR_CURSOR = new Cursor(1);
    private static final Cursor HAND_CURSOR = new Cursor(12);

    public RotationMouseHandler(DrawingCanvas canvas) {
        this.canvas = canvas;
        this.view = canvas.getView();
    }

    @Override
    public void setListener(CanvasMouseListener listener) {
        this.listener = listener;
    }

    @Override
    public CanvasMouseListener getListener() {
        return this.listener;
    }

    @Override
    public void upEvent() {
        this.canvas.setCursor(DEFAULT_CURSOR);
        if (this.view.getSelected() != -1) {
            this.view.updateSelectedItem();
        }
        this.canvas.repaint();
    }

    @Override
    public void downEvent() {
        this.canvas.requestFocusInWindow();
        this.view.setSelected(-1);
        List<DrawItem> drawings = this.view.getDrawings();
        if (!drawings.isEmpty()) {
            int i = drawings.size() - 1;
            do {
                DrawItem item;
                if ((item = drawings.get(i)) instanceof Figure && !((Figure)item).getType().equals((Object)FigureType.LINE) || item instanceof Text || item instanceof Grouped || item instanceof Picture && !(item instanceof StreetMap)) {
                    if (this.getRegion(item.getTop()[0]).contains(this.listener.getStartX(), this.listener.getStartY())) {
                        this.view.setSelected(i);
                        break;
                    }
                    if (this.getRegion(item.getDown()[0]).contains(this.listener.getStartX(), this.listener.getStartY())) {
                        this.view.setSelected(i);
                        break;
                    }
                    if (this.getRegion(item.getBottom()[0]).contains(this.listener.getStartX(), this.listener.getStartY())) {
                        this.view.setSelected(i);
                        break;
                    }
                    if (this.getRegion(item.getUp()[0]).contains(this.listener.getStartX(), this.listener.getStartY())) {
                        this.view.setSelected(i);
                        break;
                    }
                    if (item.contains(this.listener.getStartX(), this.listener.getStartY())) {
                        this.view.setSelected(i);
                        break;
                    }
                }
                if (!(item instanceof Figure) || !((Figure)item).getType().equals((Object)FigureType.LINE) || !item.contains(this.listener.getStartX(), this.listener.getStartY())) continue;
                this.view.setSelected(i);
                break;
            } while (--i >= 0);
        }
        if (this.view.getSelected() != -1) {
            this.omega = this.view.getDrawings().get(this.view.getSelected()).getAngle();
        }
        this.canvas.repaint();
    }

    @Override
    public void clickEvent() {
    }

    @Override
    public void moveEvent() {
        if (this.view.getSelected() != -1) {
            DrawItem item = this.view.getDrawings().get(this.view.getSelected());
            if (!(item instanceof Text || item instanceof Edge || item instanceof ArrowLine)) {
                if (this.getRegion(item.getTop()[0]).contains(this.listener.getTempX(), this.listener.getTempY())) {
                    this.canvas.setCursor(CROSSHAIR_CURSOR);
                } else if (this.getRegion(item.getDown()[0]).contains(this.listener.getTempX(), this.listener.getTempY())) {
                    this.canvas.setCursor(CROSSHAIR_CURSOR);
                } else if (this.getRegion(item.getBottom()[0]).contains(this.listener.getTempX(), this.listener.getTempY())) {
                    this.canvas.setCursor(CROSSHAIR_CURSOR);
                } else if (this.getRegion(item.getUp()[0]).contains(this.listener.getTempX(), this.listener.getTempY())) {
                    this.canvas.setCursor(CROSSHAIR_CURSOR);
                } else if (item.contains(this.listener.getTempX(), this.listener.getTempY())) {
                    this.canvas.setCursor(HAND_CURSOR);
                } else {
                    this.canvas.setCursor(DEFAULT_CURSOR);
                }
            } else if (item.contains(this.listener.getTempX(), this.listener.getTempY())) {
                this.canvas.setCursor(HAND_CURSOR);
            } else {
                this.canvas.setCursor(DEFAULT_CURSOR);
            }
        } else {
            this.canvas.setCursor(DEFAULT_CURSOR);
        }
    }

    @Override
    public void dragEvent() {
        if (this.view.getSelected() != -1) {
            CanvasPoint B;
            DrawItem item = this.view.getDrawings().get(this.view.getSelected());
            CanvasPoint centre = item.rotationCentre();
            CanvasPoint A = B = new CanvasPoint(1.0, 1.0);
            if (item instanceof Figure || item instanceof Text || item instanceof Grouped || item instanceof Picture && !(item instanceof StreetMap)) {
                A = new CanvasPoint(this.listener.getStartX() - centre.x, this.listener.getStartY() - centre.y);
                B = new CanvasPoint(this.listener.getTempX() - centre.x, this.listener.getTempY() - centre.y);
            }
            double h1 = V2.L2(A);
            CanvasPoint q1 = new CanvasPoint(A.x / h1, A.y / h1);
            double h2 = V2.L2(B);
            CanvasPoint q2 = new CanvasPoint(B.x / h2, B.y / h2);
            double cos_t = V2.dot(q1, q2);
            double sin_t = V2.dot(V2.rot90(q1), q2);
            double theta = Math.atan2(sin_t, cos_t);
            if (this.listener.isSnapEnabled()) {
                this.omega += theta;
                theta = this.omega - item.getAngle();
                this.canvas.rotateWithIncrements(item, theta);
            } else {
                this.canvas.rotateTo(item, theta);
            }
            this.view.updateSelectedItem();
            this.listener.setStartX(this.listener.getTempX());
            this.listener.setStartY(this.listener.getTempY());
        }
        this.canvas.repaint();
    }

    @Override
    public void enterEvent() {
    }

    @Override
    public void exitEvent() {
    }

    @Override
    public void wheelEvent() {
    }

    protected Area getRegion(CanvasPoint p) {
        return this.regionCache.computeIfAbsent(p, key -> {
            Rectangle2D.Double rect = new Rectangle2D.Double(p.x - 10.0, p.y - 10.0, 20.0, 20.0);
            return new Area(rect);
        });
    }
}

