/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event;

import java.awt.Point;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.EventHandler;
import net.perspective.draw.event.behaviours.BehaviourContext;
import net.perspective.draw.event.behaviours.MapItemBehaviour;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.StreetMap;
import net.perspective.draw.util.CanvasPoint;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;

public class MapMouseHandler
implements EventHandler {
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private CanvasMouseListener listener;
    protected BehaviourContext context;
    private Point lastDragPoint;

    public MapMouseHandler(DrawingCanvas canvas) {
        this.canvas = canvas;
        this.view = canvas.getView();
        this.context = new BehaviourContext(this, canvas);
    }

    @Override
    public void setListener(CanvasMouseListener listener) {
        this.listener = listener;
    }

    @Override
    public CanvasMouseListener getListener() {
        return this.listener;
    }

    @Override
    public void upEvent() {
        this.lastDragPoint = null;
    }

    @Override
    public void downEvent() {
        this.lastDragPoint = null;
    }

    @Override
    public void clickEvent() {
        if (this.view.getSelected() != -1) {
            if (this.listener.doubleClicked()) {
                DrawItem item = this.view.getDrawings().get(this.view.getSelected());
                CanvasPoint st = ((StreetMap)item).getStart();
                Point p = new Point((int)this.listener.getTempX() - (int)st.x, (int)this.listener.getTempY() - (int)st.y);
                this.canvas.getMapController().zoomIn(p);
            } else if (this.listener.getRightClick()) {
                DrawItem item = this.view.getDrawings().get(this.view.getSelected());
                ICoordinate loc = this.canvas.getMapController().getLocation(this.listener.getTempX() - item.getTop()[0].x, this.listener.getTempY() - item.getTop()[0].y);
                this.canvas.getMapController().putLocation(this.listener.getTempX() - item.getTop()[0].x, this.listener.getTempY() - item.getTop()[0].y);
                Logger.getLogger(MapMouseHandler.class.getName()).log(Level.FINE, "Geolocation: {0}, {1}", new Object[]{loc.getLat(), loc.getLon()});
            }
        }
    }

    @Override
    public void moveEvent() {
        DrawItem item;
        if (this.view.getSelected() != -1 && (item = this.view.getDrawings().get(this.view.getSelected())) instanceof StreetMap) {
            this.context.setBehaviour(new MapItemBehaviour());
            this.context.hover(item);
        }
    }

    @Override
    public void dragEvent() {
        Point p = new Point((int)this.listener.getTempX(), (int)this.listener.getTempY());
        if (this.lastDragPoint != null) {
            int diffx = this.lastDragPoint.x - p.x;
            int diffy = this.lastDragPoint.y - p.y;
            this.canvas.getMapController().moveMap(diffx, diffy);
        }
        this.lastDragPoint = p;
    }

    @Override
    public void enterEvent() {
    }

    @Override
    public void exitEvent() {
    }

    @Override
    public void wheelEvent() {
        if (this.view.getSelected() != -1) {
            DrawItem item = this.view.getDrawings().get(this.view.getSelected());
            CanvasPoint st = ((StreetMap)item).getStart();
            Point p = new Point((int)this.listener.getTempX() - (int)st.x, (int)this.listener.getTempY() - (int)st.y);
            int wheel = this.listener.getWheel();
            this.canvas.getMapController().setZoom(this.canvas.getMapController().getZoom() - wheel, p);
        }
    }
}

