/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event;

import java.awt.Cursor;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.EventHandler;
import net.perspective.draw.geom.ArrowLine;
import net.perspective.draw.geom.ArrowType;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureFactory;
import net.perspective.draw.geom.FigureFactoryImpl;

public class FigureMouseHandler
implements EventHandler {
    private final DrawingCanvas canvas;
    private final CanvasView view;
    private final FigureFactory figurefactory;
    private CanvasMouseListener listener;

    public FigureMouseHandler(DrawingCanvas canvas) {
        this.canvas = canvas;
        this.view = canvas.getView();
        this.figurefactory = new FigureFactoryImpl();
    }

    @Override
    public void setListener(CanvasMouseListener listener) {
        this.listener = listener;
    }

    @Override
    public CanvasMouseListener getListener() {
        return this.listener;
    }

    @Override
    public void upEvent() {
        this.view.setDrawing(false);
        if (this.view.getNewItem().isEmpty() || this.canvas.getDrawType().isEmpty()) {
            return;
        }
        Figure item = (Figure)this.view.getNewItem().get();
        item.setEndPoints();
        this.view.addItemToCanvas(item);
    }

    @Override
    public void downEvent() {
        this.canvas.requestFocusInWindow();
    }

    @Override
    public void clickEvent() {
        DrawingType drawType = this.canvas.getDrawType().orElse(DrawingType.POINT);
        if (drawType == DrawingType.LINE || drawType == DrawingType.HORIZONTAL || drawType == DrawingType.VERTICAL) {
            Figure item = this.figurefactory.createFigure(drawType);
            item.setStart(this.listener.getTempX(), this.listener.getTempY());
            item.setEnd(this.listener.getTempX(), this.listener.getTempY());
            item.setPoints(DrawingType.POINT);
            item.setPath();
            this.view.setNewItem(item);
            this.view.addItemToCanvas(item);
        }
    }

    @Override
    public void moveEvent() {
        this.canvas.setCursor(new Cursor(0));
        if (!this.view.isDrawing()) {
            return;
        }
        this.canvas.repaint();
    }

    @Override
    public void dragEvent() {
        DrawingType drawType = this.canvas.getDrawType().orElse(DrawingType.POINT);
        Figure item = this.figurefactory.createFigure(drawType);
        item.setStart(this.listener.getStartX(), this.listener.getStartY());
        item.setEnd(this.listener.getTempX(), this.listener.getTempY());
        item.setPoints(drawType);
        item.setPath();
        if ((drawType == DrawingType.LINE || drawType == DrawingType.HORIZONTAL || drawType == DrawingType.VERTICAL) && (this.canvas.getArrow().equals((Object)ArrowType.END) || this.canvas.getArrow().equals((Object)ArrowType.BOTH))) {
            ArrowLine arrow = new ArrowLine(item);
            arrow.setArrowStroke(this.canvas.getPlainStroke());
            arrow.setArrowType(this.canvas.getArrow());
            arrow.setEndPoints();
            item = arrow;
        }
        this.view.setNewItem(item);
        this.view.setDrawing(true);
        this.canvas.repaint();
    }

    @Override
    public void enterEvent() {
    }

    @Override
    public void exitEvent() {
    }

    @Override
    public void wheelEvent() {
    }
}

