/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw.event;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import net.perspective.draw.event.EventHandler;

public class CanvasMouseListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private EventHandler handler;
    private double startX;
    private double startY;
    private double tempX;
    private double tempY;
    private boolean leftbutton;
    private boolean rightbutton;
    private boolean doubleclick;
    private int wheel;
    private boolean snapEnabled;

    public void setEventHandler(EventHandler h) {
        h.setListener(this);
        this.handler = h;
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.rightbutton = 3 == (3 & me.getButton());
        this.handler.upEvent();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.startX = me.getX();
        this.startY = me.getY();
        this.rightbutton = 3 == (3 & me.getButton());
        this.handler.downEvent();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.tempX = me.getX();
        this.tempY = me.getY();
        this.leftbutton = 1 == (1 & me.getButton());
        this.rightbutton = 3 == (3 & me.getButton());
        this.doubleclick = me.getClickCount() > 1 && 1 == (1 & me.getButton());
        this.handler.clickEvent();
        me.consume();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.tempX = me.getX();
        this.tempY = me.getY();
        this.handler.moveEvent();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.tempX = me.getX();
        this.tempY = me.getY();
        this.handler.dragEvent();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.handler.enterEvent();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.handler.exitEvent();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        this.tempX = mwe.getX();
        this.tempY = mwe.getY();
        this.wheel = mwe.getWheelRotation();
        this.handler.wheelEvent();
    }

    public void setStartX(double startX) {
        this.startX = startX;
    }

    public double getStartX() {
        return this.startX;
    }

    public void setStartY(double startY) {
        this.startY = startY;
    }

    public double getStartY() {
        return this.startY;
    }

    public double getTempX() {
        return this.tempX;
    }

    public double getTempY() {
        return this.tempY;
    }

    public boolean getLeftClick() {
        return this.leftbutton;
    }

    public boolean getRightClick() {
        return this.rightbutton;
    }

    public boolean doubleClicked() {
        return this.doubleclick;
    }

    public int getWheel() {
        return this.wheel;
    }

    public void setSnapEnabled(boolean snapEnabled) {
        this.snapEnabled = snapEnabled;
    }

    public boolean isSnapEnabled() {
        return this.snapEnabled;
    }
}

