/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.perspective.draw.DrawingCanvas;

public class TextItemTransferHandler
extends TransferHandler {
    private DrawingCanvas source;
    private static final Logger logger = Logger.getLogger(TextItemTransferHandler.class.getName());

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasStringFlavor(flavors);
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        DrawingCanvas canvas = (DrawingCanvas)c;
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        if (this.hasStringFlavor(t.getTransferDataFlavors())) {
            try {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                canvas.getView().getTextController().setClipboard(str);
                canvas.getView().getTextController().pasteSelectedText();
                logger.fine("Pasted text");
                return true;
            }
            catch (UnsupportedFlavorException e) {
                logger.warning("importData: Unsupported data flavor.");
            }
            catch (IOException e) {
                logger.warning("importData: I/O exception.");
            }
        }
        logger.finer("ImportData");
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.source = (DrawingCanvas)c;
        this.source.getView().getTextController().copySelectedText();
        String data = this.source.getView().getTextController().getClipboard();
        logger.log(Level.FINER, "Transfer data: {0}", data);
        return new StringSelection(data);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        DrawingCanvas canvas = (DrawingCanvas)c;
        if (action == 2) {
            canvas.getView().getTextController().cutSelectedText();
            logger.fine("Removed selected text");
        } else {
            logger.fine("Copied selected text");
        }
        this.source = null;
        logger.finer("ExportDone");
    }

    protected boolean hasStringFlavor(DataFlavor[] flavors) {
        for (DataFlavor f : flavors) {
            if (!DataFlavor.stringFlavor.equals(f)) continue;
            return true;
        }
        return false;
    }
}

