/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.util.Set;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.geom.Text;
import net.perspective.draw.text.Editor;
import net.perspective.draw.text.RichTextEditor;
import net.perspective.draw.text.Styler;
import net.perspective.draw.text.TextEditor;

public class TextController {
    private DrawingCanvas canvas;
    private CanvasView view;
    private Editor editor;
    private Styler styler;
    private boolean isRichText;
    public static final int FONT_BOLD = 1;
    public static final int FONT_ITALIC = 2;
    public static final int FONT_UNDERLINED = 4;

    private TextController() {
    }

    public TextController(CanvasView view, DrawingCanvas canvas) {
        this();
        this.canvas = canvas;
        this.view = view;
    }

    public void enableRichText(boolean isRichText) {
        if (!this.view.isEditing()) {
            Styler styler1;
            this.editor = isRichText ? new RichTextEditor() : new TextEditor();
            Editor editor = this.editor;
            this.styler = editor instanceof Styler ? (styler1 = (Styler)((Object)editor)) : null;
            this.isRichText = isRichText;
        }
    }

    public Editor getEditor() {
        return this.editor;
    }

    public Text initializeItem(Text item) {
        item.setFont(this.canvas.getFontFamily());
        item.setStyle(this.canvas.getFontStyle());
        item.setSize(this.canvas.getFontSize());
        this.editor.editText(item);
        this.editor.commitText(item);
        this.editor.setCaretStart(0);
        this.editor.setCaretEnd(this.editor.readPlainText().length());
        item.setDimensions(this.canvas);
        return item;
    }

    public void editItem(Text item, int start) {
        item.setFont(this.canvas.getFontFamily());
        item.setStyle(this.canvas.getFontStyle());
        item.setSize(this.canvas.getFontSize());
        this.editor.editText(item);
        this.editor.commitText(item);
        this.editor.setCaretStart(start);
        this.editor.setCaretEnd(start);
        item.setDimensions(this.canvas);
    }

    public void editItem(Text item) {
        item.setFont(this.canvas.getFontFamily());
        item.setStyle(this.canvas.getFontStyle());
        item.setSize(this.canvas.getFontSize());
        this.editor.editText(item);
        this.editor.commitText(item);
        this.editor.setCaretStart(0);
        this.editor.setCaretEnd(this.editor.readPlainText().length());
        item.setDimensions(this.canvas);
    }

    public void cutSelectedText() {
        if (this.view.isEditing()) {
            Text item = (Text)this.view.getDrawings().get(this.view.getSelected());
            this.editor.editText(item);
            this.editor.cutText();
            this.editor.commitText(item);
            item.setDimensions(this.canvas);
        }
        this.canvas.repaint();
    }

    public void copySelectedText() {
        if (this.view.isEditing()) {
            Text item = (Text)this.view.getDrawings().get(this.view.getSelected());
            this.editor.editText(item);
            this.editor.copyText();
            this.editor.commitText(item);
        }
    }

    public void pasteSelectedText() {
        if (this.view.isEditing()) {
            Text item = (Text)this.view.getDrawings().get(this.view.getSelected());
            this.editor.editText(item);
            this.editor.pasteText();
            this.editor.commitText(item);
            item.setDimensions(this.canvas);
        }
        this.canvas.repaint();
    }

    public void formatSelectedText(int format) {
        if (this.styler == null) {
            this.formatSelected(format);
        } else {
            this.formatSelectedRichText(format);
        }
        this.canvas.repaint();
    }

    private void formatSelected(int format) {
        switch (format) {
            case 1: {
                if ((this.canvas.getFontStyle() & 1) == 1) {
                    this.canvas.getToolPanel().toggleFormattingButton(1, false);
                    this.canvas.updateFontStyle(this.canvas.getFontStyle() ^ 1);
                    break;
                }
                this.canvas.getToolPanel().toggleFormattingButton(1, true);
                this.canvas.updateFontStyle(this.canvas.getFontStyle() | 1);
                break;
            }
            case 2: {
                if ((this.canvas.getFontStyle() & 2) == 2) {
                    this.canvas.getToolPanel().toggleFormattingButton(2, false);
                    this.canvas.updateFontStyle(this.canvas.getFontStyle() ^ 2);
                    break;
                }
                this.canvas.getToolPanel().toggleFormattingButton(2, true);
                this.canvas.updateFontStyle(this.canvas.getFontStyle() | 2);
                break;
            }
            case 4: {
                if ((this.canvas.getFontStyle() & 4) == 4) {
                    this.canvas.getToolPanel().toggleFormattingButton(4, false);
                    this.canvas.updateFontStyle(this.canvas.getFontStyle() ^ 4);
                    break;
                }
                this.canvas.getToolPanel().toggleFormattingButton(4, true);
                this.canvas.updateFontStyle(this.canvas.getFontStyle() | 4);
                break;
            }
        }
    }

    private void formatSelectedRichText(int format) {
        if (this.view.isEditing()) {
            Text item = (Text)this.view.getDrawings().get(this.view.getSelected());
            this.editor.editText(item);
            Set<String> styles = this.styler.detectStyles();
            this.editor.commitText(item);
            switch (format) {
                case 1: {
                    if (styles.contains("b")) {
                        this.editor.editText(item);
                        this.styler.removeStyle("b");
                        this.editor.commitText(item);
                        this.canvas.getToolPanel().toggleFormattingButton(1, false);
                        break;
                    }
                    this.editor.editText(item);
                    this.styler.createStyle("b");
                    this.editor.commitText(item);
                    this.canvas.getToolPanel().toggleFormattingButton(1, true);
                    break;
                }
                case 2: {
                    if (styles.contains("i")) {
                        this.editor.editText(item);
                        this.styler.removeStyle("i");
                        this.editor.commitText(item);
                        this.canvas.getToolPanel().toggleFormattingButton(2, false);
                        break;
                    }
                    this.editor.editText(item);
                    this.styler.createStyle("i");
                    this.editor.commitText(item);
                    this.canvas.getToolPanel().toggleFormattingButton(2, true);
                    break;
                }
                case 4: {
                    if (styles.contains("u")) {
                        this.editor.editText(item);
                        this.styler.removeStyle("u");
                        this.editor.commitText(item);
                        this.canvas.getToolPanel().toggleFormattingButton(4, false);
                        break;
                    }
                    this.editor.editText(item);
                    this.styler.createStyle("u");
                    this.editor.commitText(item);
                    this.canvas.getToolPanel().toggleFormattingButton(4, true);
                    break;
                }
            }
            item.setDimensions(this.canvas);
        }
    }

    public String getClipboard() {
        return this.editor.getClipboard();
    }

    public void setClipboard(String str) {
        this.editor.setClipboard(str);
    }

    public boolean isRichText() {
        return this.isRichText;
    }
}

