/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JFileChooser;
import javax.swing.Timer;
import net.perspective.draw.CanvasView;
import net.perspective.draw.MainFrame;
import net.perspective.draw.util.AwtCanvasFilter;
import net.perspective.draw.util.AwtImageFilter;
import net.perspective.draw.util.AwtPdfFilter;
import net.perspective.draw.util.AwtPngFilter;
import net.perspective.draw.util.AwtSvgFilter;
import net.perspective.draw.util.FileUtils;
import net.perspective.draw.util.JCanvasFilter;
import net.perspective.draw.util.JImageFilter;
import net.perspective.draw.util.JPdfFilter;
import net.perspective.draw.util.JPngFilter;
import net.perspective.draw.util.JSvgFilter;
import net.perspective.draw.workers.ImageLoadWorker;
import net.perspective.draw.workers.PDFWorker;
import net.perspective.draw.workers.PNGWorker;
import net.perspective.draw.workers.ReadInFunnel;
import net.perspective.draw.workers.SVGVectorWorker;
import net.perspective.draw.workers.SVGWorker;
import net.perspective.draw.workers.Worker;
import net.perspective.draw.workers.WriteOutStreamer;

public class ShareUtils {
    private MainFrame application;
    private CanvasView view;
    private ImageLoadWorker imageLoader;
    private List<File> imageFiles;
    private Timer timer;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final double margin;
    private static final int TICK = 50;
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final boolean MAC_OS_X = OS_NAME.startsWith("mac os x");
    private static final boolean PC_WIN = OS_NAME.startsWith("windows");
    private static final boolean PC_LINUX = OS_NAME.startsWith("linux");

    public ShareUtils() {
        this.margin = 5.0;
    }

    public ShareUtils(MainFrame application) {
        this();
        this.application = application;
        this.view = application.getCanvas().getView();
    }

    public void setImageFiles(List<File> imageFiles) {
        this.imageFiles = imageFiles;
    }

    public List<File> getImageFiles() {
        return this.imageFiles;
    }

    public List<File> chooseImages() {
        if (MAC_OS_X || PC_LINUX) {
            FileDialog dialog = new FileDialog((Frame)this.application, "Choose Pictures...", 0);
            dialog.setDirectory(System.getProperty("user.home"));
            dialog.setMultipleMode(true);
            dialog.setFilenameFilter(new AwtImageFilter());
            dialog.setVisible(true);
            File[] files = dialog.getFiles();
            if (files == null || files.length == 0) {
                return Collections.emptyList();
            }
            return Arrays.asList(files);
        }
        JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle("Choose Pictures...");
        chooser.setMultiSelectionEnabled(true);
        JImageFilter filter = new JImageFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        int result = chooser.showOpenDialog(this.application);
        if (result == 1) {
            return null;
        }
        List<File> files = Arrays.asList(chooser.getSelectedFiles());
        return files;
    }

    public void readPictures() {
        this.readPictures(this.chooseImages());
    }

    public void readPictures(List<File> files) {
        this.setImageFiles(files);
        if (this.getImageFiles() != null) {
            this.imageLoader = new ImageLoadWorker(this.application);
            this.executor.submit(this.imageLoader);
        }
        this.application.getToolButtons().setButtonMode(0);
    }

    public File chooseCanvas() {
        if (MAC_OS_X || PC_LINUX) {
            FileDialog dialog = new FileDialog((Frame)this.application, "Open drawing...", 0);
            dialog.setDirectory(System.getProperty("user.home"));
            dialog.setFilenameFilter(new AwtCanvasFilter());
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            String dirName = dialog.getDirectory();
            if (fileName == null) {
                return null;
            }
            return new File(dirName, fileName);
        }
        JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle("Open drawing...");
        JCanvasFilter filter = new JCanvasFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        int result = chooser.showOpenDialog(this.application);
        if (result == 1) {
            return null;
        }
        File file = chooser.getSelectedFile();
        return file;
    }

    public void exportCanvas() {
        File f;
        if (this.view.getDrawings().isEmpty()) {
            return;
        }
        if (MAC_OS_X || PC_LINUX) {
            FileDialog dialog = new FileDialog((Frame)this.application, "Save As...", 1);
            dialog.setDirectory(System.getProperty("user.home"));
            dialog.setFile("Untitled.gst");
            dialog.setFilenameFilter(new AwtCanvasFilter());
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            String dirName = dialog.getDirectory();
            if (fileName == null) {
                return;
            }
            f = new File(dirName, fileName);
        } else {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle("Save As...");
            JCanvasFilter filter = new JCanvasFilter();
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            chooser.setSelectedFile(new File("Untitled.gst"));
            int result = chooser.showSaveDialog(this.application);
            if (result == 1) {
                return;
            }
            f = chooser.getSelectedFile();
        }
        File file = FileUtils.cleanseFileName(f, "gst");
        this.writeCanvas(file);
        this.application.setCanvasFile(file);
    }

    public void loadCanvas(String path) {
        File file = new File(path);
        this.readCanvas(file);
    }

    public void readCanvas(File file) {
        this.application.getProgress().setValue(0);
        this.application.getProgress().setVisible(true);
        ReadInFunnel reader = new ReadInFunnel(this.application, file);
        this.timer = new Timer(50, new TimerListener(reader));
        this.executor.submit(reader);
        this.timer.start();
    }

    public void writeCanvas(File file) {
        this.application.getProgress().setValue(0);
        this.application.getProgress().setVisible(true);
        WriteOutStreamer streamer = new WriteOutStreamer(this.application, file);
        this.timer = new Timer(50, new TimerListener(streamer));
        this.executor.submit(streamer);
        this.timer.start();
        this.application.setStatus("Save begins...");
    }

    public void exportPDF() {
        File f;
        if (this.view.getDrawings().isEmpty()) {
            return;
        }
        if (MAC_OS_X || PC_LINUX) {
            FileDialog dialog = new FileDialog((Frame)this.application, "Export PDF...", 1);
            dialog.setDirectory(System.getProperty("user.home"));
            dialog.setFile("Untitled.pdf");
            dialog.setFilenameFilter(new AwtPdfFilter());
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            String dirName = dialog.getDirectory();
            if (fileName == null) {
                return;
            }
            f = new File(dirName, fileName);
        } else {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle("Export PDF...");
            JPdfFilter filter = new JPdfFilter();
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            chooser.setSelectedFile(new File("Untitled.pdf"));
            int result = chooser.showSaveDialog(this.application);
            if (result == 1) {
                return;
            }
            f = chooser.getSelectedFile();
        }
        File file = FileUtils.cleanseFileName(f, "pdf");
        this.application.getProgress().setValue(0);
        this.application.getProgress().setVisible(true);
        this.application.getProgress().setIndeterminate(true);
        PDFWorker pdfWorker = new PDFWorker(this.application, file);
        pdfWorker.setMargin(this.margin);
        this.executor.submit(pdfWorker);
        this.application.setStatus("PDF export started.");
    }

    public void exportSVG() {
        File f;
        if (this.view.getDrawings().isEmpty()) {
            return;
        }
        if (MAC_OS_X || PC_LINUX) {
            FileDialog dialog = new FileDialog((Frame)this.application, "Export SVG...", 1);
            dialog.setDirectory(System.getProperty("user.home"));
            dialog.setFile("Untitled.svg");
            dialog.setFilenameFilter(new AwtSvgFilter());
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            String dirName = dialog.getDirectory();
            if (fileName == null) {
                return;
            }
            f = new File(dirName, fileName);
        } else {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle("Export SVG...");
            JSvgFilter filter = new JSvgFilter();
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            chooser.setSelectedFile(new File("Untitled.svg"));
            int result = chooser.showSaveDialog(this.application);
            if (result == 1) {
                return;
            }
            f = chooser.getSelectedFile();
        }
        File file = FileUtils.cleanseFileName(f, "svg");
        this.application.getProgress().setValue(0);
        this.application.getProgress().setVisible(true);
        this.application.getProgress().setIndeterminate(true);
        SVGWorker svgWorker = new SVGWorker(this.application, file);
        svgWorker.setMargin(this.margin);
        this.executor.submit(svgWorker);
        this.application.setStatus("SVG export started.");
    }

    public void exportPNG() {
        File f;
        if (this.view.getDrawings().isEmpty()) {
            return;
        }
        if (MAC_OS_X || PC_LINUX) {
            FileDialog dialog = new FileDialog((Frame)this.application, "Export Image...", 1);
            dialog.setDirectory(System.getProperty("user.home"));
            dialog.setFile("Untitled.png");
            dialog.setFilenameFilter(new AwtPngFilter());
            dialog.setVisible(true);
            String fileName = dialog.getFile();
            String dirName = dialog.getDirectory();
            if (fileName == null) {
                return;
            }
            f = new File(dirName, fileName);
        } else {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle("Export Image...");
            JPngFilter filter = new JPngFilter();
            chooser.addChoosableFileFilter(filter);
            chooser.setFileFilter(filter);
            chooser.setSelectedFile(new File("Untitled.png"));
            int result = chooser.showSaveDialog(this.application);
            if (result == 1) {
                return;
            }
            f = chooser.getSelectedFile();
        }
        File file = FileUtils.cleanseFileName(f, "png");
        this.application.getProgress().setValue(0);
        this.application.getProgress().setVisible(true);
        this.application.getProgress().setIndeterminate(true);
        PNGWorker pngWorker = new PNGWorker(this.application, file);
        pngWorker.setMargin(this.margin);
        pngWorker.setOpacity(false);
        this.executor.submit(pngWorker);
        this.application.setStatus("PNG export started.");
    }

    public void snapshotPNG() {
        Date d = new Date();
        if (this.view.getDrawings().isEmpty()) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd' at 'HH.mm.ss");
        TimeZone tz = TimeZone.getDefault();
        df.setTimeZone(tz);
        String now = df.format(d);
        String userHome = System.getProperty("user.home");
        String userPath = Optional.ofNullable(System.getenv("OneDrive")).orElse(userHome);
        String path = String.valueOf(Paths.get(userPath, new String[0])) + File.separator + "Desktop" + File.separator + "Snap Shot " + now + ".png";
        File file = new File(path);
        this.application.getProgress().setValue(0);
        this.application.getProgress().setVisible(true);
        this.application.getProgress().setIndeterminate(true);
        PNGWorker pngWorker = new PNGWorker(this.application, file);
        pngWorker.setMargin(this.margin);
        pngWorker.setOpacity(true);
        this.executor.submit(pngWorker);
        this.application.getToolPanel().enablePNGButton(false);
        this.application.setStatus("Snapshot started.");
    }

    public List<File> chooseVectorImages() {
        if (MAC_OS_X || PC_LINUX) {
            FileDialog dialog = new FileDialog((Frame)this.application, "Choose Pictures...", 0);
            dialog.setDirectory(System.getProperty("user.home"));
            dialog.setMultipleMode(true);
            dialog.setFilenameFilter(new AwtSvgFilter());
            dialog.setVisible(true);
            File[] files = dialog.getFiles();
            if (files == null || files.length == 0) {
                return Collections.emptyList();
            }
            return Arrays.asList(files);
        }
        JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle("Choose Pictures...");
        chooser.setMultiSelectionEnabled(true);
        JSvgFilter filter = new JSvgFilter();
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        int result = chooser.showOpenDialog(this.application);
        if (result == 1) {
            return null;
        }
        List<File> files = Arrays.asList(chooser.getSelectedFiles());
        return files;
    }

    public void readSVG() {
        this.readSVG(this.chooseVectorImages());
    }

    public void readSVG(List<File> files) {
        if (files == null || files.isEmpty()) {
            return;
        }
        this.application.getProgress().setValue(0);
        this.application.getProgress().setVisible(true);
        this.application.getProgress().setIndeterminate(true);
        SVGVectorWorker svgWorker = new SVGVectorWorker(this.application, files);
        this.executor.submit(svgWorker);
    }

    class TimerListener
    implements ActionListener {
        private final Worker worker;

        TimerListener(Worker w) {
            this.worker = w;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ShareUtils.this.application.getProgress().setMaximum(this.worker.getLengthOfTask());
            ShareUtils.this.application.getProgress().setValue(this.worker.getCurrent());
            if (this.worker.isDone()) {
                ShareUtils.this.timer.stop();
            }
        }
    }
}

