/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import net.perspective.draw.CanvasView;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.ImageItem;
import net.perspective.draw.geom.QuitIcon;
import net.perspective.draw.geom.StreetMap;
import net.perspective.draw.maps.Mapping;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;

public class MapController {
    private DrawingCanvas canvas;
    private CanvasView view;
    private Mapping mapping;
    protected JSlider zoomSlider;
    protected JButton zoomInButton;
    protected JButton zoomOutButton;
    protected JTextField geoLocation;
    protected JButton quiticon;
    private ExecutorService executor;
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static final Logger logger = Logger.getLogger(MapController.class.getName());

    private MapController() {
    }

    public MapController(DrawingCanvas canvas, CanvasView view) {
        this();
        this.canvas = canvas;
        this.view = view;
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>(1000));
    }

    public void createMap() {
        int width = 900;
        int height = 675;
        StreetMap map = new StreetMap(10.0, 10.0);
        BufferedImage image = this.createCompatibleImage(width, height);
        ImageItem img = new ImageItem(image);
        int index = this.view.setImageItem(img);
        map.setImage(index, width, height);
        map.setLatitude(50.0);
        map.setLongitude(9.0);
        map.setZoom(4);
        this.view.setNewItem(map);
        this.view.addItemToCanvas(map);
        int i = this.view.getDrawings().size() - 1;
        this.view.setSelected(i);
        this.initMap();
    }

    public void initMap() {
        if (this.view.isMapping()) {
            StreetMap map = (StreetMap)this.view.getDrawings().get(this.view.getSelected());
            this.mapping = Mapping.getInstance();
            if (OsmMercator.isRetina()) {
                this.mapping.setWidth((int)map.getEnd().getX() * 2);
                this.mapping.setHeight((int)map.getEnd().getY() * 2);
            } else {
                this.mapping.setWidth((int)map.getEnd().getX());
                this.mapping.setHeight((int)map.getEnd().getY());
            }
            Future<Void> future = this.executor.submit(() -> {
                this.mapping.connect(this.canvas, map);
                return null;
            });
            try {
                future.get(1500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    public void resizeMap(StreetMap map, int diffx, int diffy) {
        int index = map.getImageIndex();
        BufferedImage image = this.createCompatibleImage((int)map.getEnd().getX(), (int)map.getEnd().getY());
        this.view.replaceImage(index, image);
        this.mapping = Mapping.getInstance();
        if (OsmMercator.isRetina()) {
            this.mapping.setWidth((int)map.getEnd().getX() * 2);
            this.mapping.setHeight((int)map.getEnd().getY() * 2);
        } else {
            this.mapping.setWidth((int)map.getEnd().getX());
            this.mapping.setHeight((int)map.getEnd().getY());
        }
        Future<Void> future = this.executor.submit(() -> {
            this.mapping.connect(this.canvas, map);
            this.mapping.moveMap(diffx, diffy);
            return null;
        });
        try {
            future.get(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public void initializeZoomSlider(StreetMap map) {
        ImageIcon icon;
        int left = (int)map.getStart().x;
        int top = (int)map.getStart().y;
        this.zoomSlider = new JSlider(this.mapping.getMinZoom(), this.mapping.getMaxZoom());
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setBounds(left + 10, top + 10, 30, 150);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.setFocusable(false);
        this.zoomSlider.setValue(map.getZoom());
        this.zoomSlider.addChangeListener(e -> this.setZoom(this.zoomSlider.getValue()));
        this.canvas.add(this.zoomSlider);
        BufferedImage quitimage = new BufferedImage(QuitIcon.getOrigWidth(), QuitIcon.getOrigHeight(), 2);
        QuitIcon.paint((Graphics2D)((Image)quitimage).getGraphics());
        ImageIcon imageicon = new ImageIcon(quitimage);
        this.quiticon = new JButton(imageicon);
        this.quiticon.setBounds((int)map.getUp()[0].x - QuitIcon.getOrigWidth() - 5, (int)map.getUp()[0].y + (MAC_OS_X ? 5 : 7), QuitIcon.getOrigWidth(), QuitIcon.getOrigHeight());
        this.quiticon.setOpaque(false);
        this.quiticon.setContentAreaFilled(false);
        this.quiticon.setBorderPainted(false);
        this.quiticon.addActionListener(e -> this.canvas.exitMapping());
        this.canvas.add(this.quiticon);
        this.geoLocation = new JTextField();
        this.geoLocation.setFocusable(true);
        this.geoLocation.setText("");
        if (MAC_OS_X) {
            this.geoLocation.setBounds((int)map.getUp()[0].x - 187 - QuitIcon.getOrigWidth(), (int)map.getUp()[0].y + 5, 180, 25);
        } else {
            this.geoLocation.setBounds((int)map.getUp()[0].x - 189 - QuitIcon.getOrigWidth(), (int)map.getUp()[0].y + 5, 180, 30);
            this.geoLocation.setFont(this.geoLocation.getFont().deriveFont(15.0f));
        }
        this.canvas.add(this.geoLocation);
        int size = 18;
        try {
            icon = new ImageIcon(JMapViewer.class.getResource("/org/openstreetmap/gui/jmapviewer/images/plus.png"));
            this.zoomInButton = new JButton(icon);
        }
        catch (Exception e2) {
            this.zoomInButton = new JButton("+");
            this.zoomInButton.setFont(new Font("Inter", 1, 9));
            this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomInButton.setFocusable(false);
        this.zoomInButton.setBounds(left + 4, top + 155, size, size);
        this.zoomInButton.addActionListener(e -> this.zoomIn());
        this.canvas.add(this.zoomInButton);
        try {
            icon = new ImageIcon(JMapViewer.class.getResource("/org/openstreetmap/gui/jmapviewer/images/minus.png"));
            this.zoomOutButton = new JButton(icon);
        }
        catch (Exception e3) {
            this.zoomOutButton = new JButton("-");
            this.zoomOutButton.setFont(new Font("Inter", 1, 9));
            this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        }
        this.zoomOutButton.setFocusable(false);
        this.zoomOutButton.setBounds(left + 8 + size, top + 155, size, size);
        this.zoomOutButton.addActionListener(e -> this.zoomOut());
        this.canvas.add(this.zoomOutButton);
    }

    public void setSlider(int zoom) {
        this.zoomSlider.setValue(zoom);
    }

    public int getSlider() {
        return this.zoomSlider.getValue();
    }

    public void setSliderRange(int min, int max) {
        this.zoomSlider.setMinimum(min);
        this.zoomSlider.setMaximum(max);
    }

    public void removeSlider() {
        this.canvas.removeAll();
    }

    public void zoomChanged(int zoom) {
        this.zoomSlider.setToolTipText("Zoom level " + zoom);
        this.zoomInButton.setToolTipText("Zoom to level " + (zoom + 1));
        this.zoomOutButton.setToolTipText("Zoom to level " + (zoom - 1));
        this.zoomOutButton.setEnabled(zoom > this.mapping.getMinZoom());
        this.zoomInButton.setEnabled(zoom < this.mapping.getMaxZoom());
    }

    public void putLocation(double x, double y) {
        if (this.view.isMapping()) {
            if (OsmMercator.isRetina()) {
                x = 2.0 * x;
                y = 2.0 * y;
            }
            ICoordinate loc = this.mapping.getPosition((int)x, (int)y);
            this.geoLocation.setText(String.format("%.6f %.6f", loc.getLat(), loc.getLon()));
        }
    }

    public ICoordinate getLocation(double x, double y) {
        if (OsmMercator.isRetina()) {
            x = 2.0 * x;
            y = 2.0 * y;
        }
        return this.mapping.getPosition((int)x, (int)y);
    }

    public BufferedImage getImage(int i) {
        BufferedImage image = this.view.getImageItems().get(i).getImage();
        return image;
    }

    public void setZoom(int i, Point point) {
        if (OsmMercator.isRetina()) {
            point.setLocation(2 * point.x, 2 * point.y);
        }
        this.mapping.setZoom(i, point);
    }

    public void setZoom(int zoom) {
        this.mapping.setZoom(zoom);
    }

    public int getZoom() {
        return this.mapping.getZoom();
    }

    public void zoomIn() {
        this.mapping.zoomIn();
    }

    public void zoomIn(Point point) {
        if (OsmMercator.isRetina()) {
            point.setLocation(2 * point.x, 2 * point.y);
        }
        this.mapping.zoomIn(point);
    }

    public void zoomOut() {
        this.mapping.zoomOut();
    }

    public void moveMap(int diffx, int diffy) {
        this.mapping.moveMap(diffx, diffy);
    }

    public StreetMap copyMap(StreetMap item) {
        this.view.getImageItems().add(new ImageItem(Instant.now()));
        item.setImageIndex(this.view.getImageItems().size() - 1);
        this.mapping = Mapping.getInstance();
        this.mapping.refresh(item);
        return item;
    }

    public BufferedImage createCompatibleImage(int width, int height) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsConfiguration gc = device.getDefaultConfiguration();
        BufferedImage image = OsmMercator.isRetina() ? gc.createCompatibleImage(width * 2, height * 2, 3) : gc.createCompatibleImage(width, height, 3);
        return image;
    }
}

