/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.FilesEvent;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import net.perspective.draw.AboutBox;
import net.perspective.draw.CanvasItemTransferHandler;
import net.perspective.draw.CanvasView;
import net.perspective.draw.ConfigSetup;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.Gesticulate;
import net.perspective.draw.ShareUtils;
import net.perspective.draw.TransferActionListener;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.enums.MouseHandlerType;
import net.perspective.draw.geom.AcceptIcon;
import net.perspective.draw.geom.QuitIcon;
import net.perspective.draw.maps.MapService;
import net.perspective.draw.network.Document;
import net.perspective.draw.network.Endpoint;
import net.perspective.draw.swing.EditMenuBean;
import net.perspective.draw.swing.IconLibrary;
import net.perspective.draw.swing.KeyboardHelp;
import net.perspective.draw.swing.LicenceScreen;
import net.perspective.draw.swing.ToolButtons;
import net.perspective.draw.swing.ToolPanel;
import net.perspective.draw.util.FileUtils;

public final class MainFrame
extends JFrame
implements ActionListener,
PropertyChangeListener {
    private DrawingCanvas canvas;
    private Endpoint document;
    private ToolPanel toolPanel;
    private ToolButtons toolButtons;
    private AboutBox aboutBox;
    private KeyboardHelp helpBox;
    private LicenceScreen licenceBox;
    private IconLibrary libraryBox;
    private ShareUtils share;
    private ConfigSetup config;
    private EditMenuBean editMenuBean;
    private File canvasFile = null;
    private boolean isDarkTheme;
    private Color themeBackgroundColor;
    private Color themeFillColor;
    private Color themeAccentColor;
    private Color canvasBackgroundColor;
    private final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private final int sceneWidth = 1000;
    private final int sceneHeight = this.screenSize.getHeight() < 960.0 ? (int)this.screenSize.getHeight() : 864;
    private final int frameLeft = (int)(this.screenSize.getWidth() - 1000.0) / 3;
    private final int frameTop = (int)(this.screenSize.getHeight() - (double)this.sceneHeight) / 5;
    public static final int MENU_LINE = 0;
    public static final int MENU_HORIZ = 1;
    public static final int MENU_VERT = 2;
    public static final int MENU_CIRC = 3;
    public static final int MENU_SQUARE = 4;
    public static final int MENU_TRI = 5;
    public static final int MENU_HEX = 6;
    public static final int MENU_PENT = 7;
    public static final int MENU_POLY = 8;
    public static final int MENU_SKETCH = 9;
    public static final int MENU_TEXT = 10;
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static final Logger logger = Logger.getLogger(MainFrame.class.getName());
    private JMenuBar jMenuBar;
    private JMenu jEditMenu;
    private JMenu jFileMenu;
    private JMenu jInsertMenu;
    private JMenu jToolsMenu;
    private JMenu jHelpMenu;
    private JMenuItem jMenuEnact;
    private JMenuItem jMenuKeyHelp;
    private JMenuItem jMenuLicenceHelp;
    private ButtonGroup jMapGroup;
    private JRadioButtonMenuItem jMenuOpenStreetmap;
    private JRadioButtonMenuItem jMenuOsmLandscape;
    private JRadioButtonMenuItem jMenuOsmOutdoors;
    private JRadioButtonMenuItem jMenuOsmTransport;
    private JRadioButtonMenuItem jMenuBingAerial;
    private JRadioButtonMenuItem jMenuBingMaps;
    private JRadioButtonMenuItem jMenuSlope;
    private ButtonGroup jInsertGroup;
    private JRadioButtonMenuItem jMenuHorizontal;
    private JRadioButtonMenuItem jMenuVertical;
    private JRadioButtonMenuItem jMenuCircle;
    private JRadioButtonMenuItem jMenuSquare;
    private JRadioButtonMenuItem jMenuTriangle;
    private JRadioButtonMenuItem jMenuHexagon;
    private JRadioButtonMenuItem jMenuPentagram;
    private JRadioButtonMenuItem jMenuPolygon;
    private JRadioButtonMenuItem jMenuSketch;
    private JRadioButtonMenuItem jMenuText;
    private ButtonGroup jThemeGroup;
    private JRadioButtonMenuItem jMenuSetDarkLaf;
    private JRadioButtonMenuItem jMenuSetLightLaf;
    private JMenuItem jMenuPicture;
    private JMenuItem jMenuSVGItem;
    private JMenuItem jMenuStreetMap;
    private JMenuItem jMenuSync;
    private JMenuItem jNewItem;
    private JMenuItem jQuitItem;
    private JMenuItem jAboutItem;
    private JMenuItem jOpenItem;
    private JMenuItem jPDFItem;
    private JMenuItem jPNGItem;
    private JMenuItem jPrintItem;
    private JMenuItem jSVGItem;
    private JMenuItem jSaveAsItem;
    private JMenuItem jSaveItem;
    private JMenuItem jCanvasBackground;
    private JTextArea jStatusArea;
    private JPanel jStatusPanel;
    private JProgressBar jProgressBar;
    private JMenuItem jCutItem;
    private JMenuItem jCopyItem;
    private JMenuItem jPasteItem;
    private JMenuItem jCutContextItem;
    private JMenuItem jCopyContextItem;
    private JMenuItem jPasteContextItem;
    private JMenuItem jSendToBackItem;
    private JMenuItem jBringToFrontItem;
    private JMenuItem jSendBackwardsItem;
    private JMenuItem jBringForwardsItem;
    private JMenuItem jSendToBackContextItem;
    private JMenuItem jBringToFrontContextItem;
    private JMenuItem jSendBackwardsContextItem;
    private JMenuItem jBringForwardsContextItem;
    private JMenuItem jGroupItem;
    private JMenuItem jUngroupItem;
    private JMenuItem jGroupContextItem;
    private JMenuItem jUngroupContextItem;
    private JMenuItem jEditTextItem;
    private JMenuItem jEditMapItem;
    private JCheckBoxMenuItem jMenuFormattedText;
    private JPopupMenu contextMenu;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JSeparator jSeparator15;
    private JScrollPane jScrollCanvas;

    public void initializeFrame(ConfigSetup config) {
        this.config = config;
        this.isDarkTheme = Boolean.parseBoolean(config.getUserPreferences().getProperty("darkTheme"));
        if (this.isDarkTheme) {
            this.themeBackgroundColor = new Color(51, 51, 51);
            this.themeAccentColor = new Color(192, 196, 129);
        } else {
            this.themeBackgroundColor = Color.white;
            this.themeAccentColor = Color.black;
        }
        Optional<String> canvasColor = Optional.ofNullable(config.getUserPreferences().getProperty("canvasColor"));
        this.canvasBackgroundColor = canvasColor.isPresent() ? this.fromRGBCode(canvasColor.get()) : this.themeBackgroundColor;
        this.themeFillColor = canvasColor.isPresent() ? this.getThemeColor(this.fromRGBCode(canvasColor.get())) : this.getThemeColor(this.themeBackgroundColor);
        this.initComponents();
        this.canvas = new DrawingCanvas(this);
        this.canvas.init();
        this.canvas.setPreferredSize(new Dimension(920, 1300));
        this.toolPanel = new ToolPanel(this);
        if (!MAC_OS_X) {
            this.getContentPane().add((Component)this.toolPanel, "North");
        } else {
            JPanel buttonPanel = new JPanel();
            buttonPanel.putClientProperty("FlatLaf.fullWindowContent.buttonsPlaceholder", "mac");
            JPanel toolBarPanel = new JPanel(new BorderLayout());
            toolBarPanel.add((Component)buttonPanel, "West");
            toolBarPanel.add((Component)this.toolPanel, "Center");
            this.getContentPane().add((Component)toolBarPanel, "North");
        }
        this.toolButtons = new ToolButtons(this);
        this.getContentPane().add((Component)this.toolButtons, "Before");
        this.jInsertGroup.setSelected(this.jMenuHorizontal.getModel(), true);
        this.jMapGroup.setSelected(this.jMenuOpenStreetmap.getModel(), true);
        Font font = new JLabel().getFont();
        font = font.deriveFont(0, 12.0f);
        this.jStatusArea.setFont(font);
        AcceptIcon.setColor(this.themeFillColor);
        QuitIcon.setColor(this.isDarkTheme ? this.themeFillColor : new Color(0xA8A8A8));
        int keyModifier = 4;
        this.jScrollCanvas = new JScrollPane();
        this.jScrollCanvas.getVerticalScrollBar().setUnitIncrement(15);
        this.jScrollCanvas.setHorizontalScrollBarPolicy(31);
        this.jScrollCanvas.setBorder(BorderFactory.createEmptyBorder());
        this.jScrollCanvas.setPreferredSize(new Dimension(940, this.sceneHeight - 75));
        this.jScrollCanvas.setViewportView(this.canvas);
        if (!MAC_OS_X) {
            keyModifier = 2;
            this.jSeparator7 = new JSeparator();
            this.jFileMenu.add(this.jSeparator7);
            this.jQuitItem = new JMenuItem();
            this.jQuitItem.setText("Quit");
            this.jQuitItem.setAccelerator(KeyStroke.getKeyStroke(81, keyModifier));
            this.jQuitItem.setActionCommand("Quit");
            this.makeMenuListener(this.jQuitItem);
            this.jFileMenu.add(this.jQuitItem);
            this.jAboutItem = new JMenuItem();
            this.jAboutItem.setText("About Gesticulate...");
            this.jAboutItem.setActionCommand("About");
            this.makeMenuListener(this.jAboutItem);
            this.jHelpMenu.add(this.jAboutItem);
        }
        AbstractAction doNothing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        InputMap imap = this.canvas.getInputMap();
        imap.put(KeyStroke.getKeyStroke(36, 0), "doNothing");
        imap.put(KeyStroke.getKeyStroke(35, 0), "doNothing");
        imap.put(KeyStroke.getKeyStroke(37, 0), "doNothing");
        imap.put(KeyStroke.getKeyStroke(39, 0), "doNothing");
        imap.put(KeyStroke.getKeyStroke(40, 0), "doNothing");
        imap.put(KeyStroke.getKeyStroke(38, 0), "doNothing");
        this.canvas.getActionMap().put("doNothing", doNothing);
        this.jNewItem.setAccelerator(KeyStroke.getKeyStroke(78, keyModifier));
        this.jOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, keyModifier));
        this.jSaveItem.setAccelerator(KeyStroke.getKeyStroke(83, keyModifier));
        this.jSaveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, 1 | keyModifier));
        this.jPrintItem.setAccelerator(KeyStroke.getKeyStroke(80, keyModifier));
        this.canvas.setTransferHandler(new CanvasItemTransferHandler());
        imap.put(KeyStroke.getKeyStroke(88, keyModifier), TransferHandler.getCutAction().getValue("Name"));
        imap.put(KeyStroke.getKeyStroke(67, keyModifier), TransferHandler.getCopyAction().getValue("Name"));
        imap.put(KeyStroke.getKeyStroke(86, keyModifier), TransferHandler.getPasteAction().getValue("Name"));
        ActionMap map = this.canvas.getActionMap();
        map.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        map.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        map.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        TransferActionListener actionListener = new TransferActionListener().initialize();
        this.jCutItem = new JMenuItem("Cut");
        this.jCutItem.setActionCommand((String)TransferHandler.getCutAction().getValue("Name"));
        this.jCutItem.addActionListener(actionListener);
        this.jEditMenu.add(this.jCutItem);
        this.jCopyItem = new JMenuItem("Copy");
        this.jCopyItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        this.jCopyItem.addActionListener(actionListener);
        this.jEditMenu.add(this.jCopyItem);
        this.jPasteItem = new JMenuItem("Paste");
        this.jPasteItem.setActionCommand((String)TransferHandler.getPasteAction().getValue("Name"));
        this.jPasteItem.addActionListener(actionListener);
        this.jEditMenu.add(this.jPasteItem);
        this.jCutItem.setAccelerator(KeyStroke.getKeyStroke(88, keyModifier));
        this.jCopyItem.setAccelerator(KeyStroke.getKeyStroke(67, keyModifier));
        this.jPasteItem.setAccelerator(KeyStroke.getKeyStroke(86, keyModifier));
        this.jSeparator3 = new JSeparator();
        this.jEditMenu.add(this.jSeparator3);
        this.jGroupItem = new JMenuItem("Group Selection");
        this.jGroupItem.setActionCommand("Group");
        this.jEditMenu.add(this.jGroupItem);
        this.makeMenuListener(this.jGroupItem);
        this.jUngroupItem = new JMenuItem("Ungroup Selection");
        this.jUngroupItem.setActionCommand("Ungroup");
        this.jEditMenu.add(this.jUngroupItem);
        this.makeMenuListener(this.jUngroupItem);
        this.jSeparator4 = new JSeparator();
        this.jEditMenu.add(this.jSeparator4);
        this.jSendBackwardsItem = new JMenuItem("Send Backwards");
        this.jSendBackwardsItem.setActionCommand("SendBackwards");
        this.jEditMenu.add(this.jSendBackwardsItem);
        this.makeMenuListener(this.jSendBackwardsItem);
        this.jBringForwardsItem = new JMenuItem("Bring Fowards");
        this.jBringForwardsItem.setActionCommand("BringForwards");
        this.jEditMenu.add(this.jBringForwardsItem);
        this.makeMenuListener(this.jBringForwardsItem);
        this.jSendToBackItem = new JMenuItem("Send to Back");
        this.jSendToBackItem.setActionCommand("SendToBack");
        this.jEditMenu.add(this.jSendToBackItem);
        this.makeMenuListener(this.jSendToBackItem);
        this.jBringToFrontItem = new JMenuItem("Bring to Front");
        this.jBringToFrontItem.setActionCommand("BringToFront");
        this.jEditMenu.add(this.jBringToFrontItem);
        this.makeMenuListener(this.jBringToFrontItem);
        this.jSeparator11 = new JSeparator();
        this.jEditMenu.add(this.jSeparator11);
        this.jMenuFormattedText = new JCheckBoxMenuItem();
        this.jMenuFormattedText.setText("Formatted Text");
        this.jMenuFormattedText.setActionCommand("RichText");
        this.jMenuFormattedText.setSelected(true);
        this.jEditMenu.add(this.jMenuFormattedText);
        this.makeMenuListener(this.jMenuFormattedText);
        this.jMenuSetLightLaf = new JRadioButtonMenuItem();
        this.jMenuSetLightLaf.setText("Light Theme");
        this.jMenuSetLightLaf.setActionCommand("LightTheme");
        this.jThemeGroup.add(this.jMenuSetLightLaf);
        this.jMenuSetDarkLaf = new JRadioButtonMenuItem();
        this.jMenuSetDarkLaf.setText("Dark Theme");
        this.jMenuSetDarkLaf.setActionCommand("DarkTheme");
        this.jThemeGroup.add(this.jMenuSetDarkLaf);
        if (this.isDarkTheme) {
            this.jThemeGroup.setSelected(this.jMenuSetDarkLaf.getModel(), true);
        } else {
            this.jThemeGroup.setSelected(this.jMenuSetLightLaf.getModel(), true);
        }
        this.jSeparator14 = new JSeparator();
        this.jToolsMenu.add(this.jSeparator14);
        this.jToolsMenu.add(this.jMenuSetLightLaf);
        this.makeMenuListener(this.jMenuSetLightLaf);
        this.jToolsMenu.add(this.jMenuSetDarkLaf);
        this.makeMenuListener(this.jMenuSetDarkLaf);
        this.jSeparator15 = new JSeparator();
        this.jToolsMenu.add(this.jSeparator15);
        this.jCanvasBackground = new JMenuItem();
        this.jCanvasBackground.setText("Background...");
        this.jCanvasBackground.setActionCommand("Background");
        this.jToolsMenu.add(this.jCanvasBackground);
        this.makeMenuListener(this.jCanvasBackground);
        this.contextMenu = new JPopupMenu();
        this.jCutContextItem = new JMenuItem("Cut");
        this.jCutContextItem.setActionCommand((String)TransferHandler.getCutAction().getValue("Name"));
        this.jCutContextItem.addActionListener(actionListener);
        this.jCopyContextItem = new JMenuItem("Copy");
        this.jCopyContextItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        this.jCopyContextItem.addActionListener(actionListener);
        this.jPasteContextItem = new JMenuItem("Paste");
        this.jPasteContextItem.setActionCommand((String)TransferHandler.getPasteAction().getValue("Name"));
        this.jPasteContextItem.addActionListener(actionListener);
        this.jGroupContextItem = new JMenuItem("Group Selection");
        this.jGroupContextItem.setActionCommand("Group");
        this.makeMenuListener(this.jGroupContextItem);
        this.jUngroupContextItem = new JMenuItem("Ungroup Selection");
        this.jUngroupContextItem.setActionCommand("Ungroup");
        this.makeMenuListener(this.jUngroupContextItem);
        this.jSendBackwardsContextItem = new JMenuItem("Send Backwards");
        this.jSendBackwardsContextItem.setActionCommand("SendBackwards");
        this.makeMenuListener(this.jSendBackwardsContextItem);
        this.jBringForwardsContextItem = new JMenuItem("Bring Forwards");
        this.jBringForwardsContextItem.setActionCommand("BringForwards");
        this.makeMenuListener(this.jBringForwardsContextItem);
        this.jSendToBackContextItem = new JMenuItem("Send to Back");
        this.jSendToBackContextItem.setActionCommand("SendToBack");
        this.makeMenuListener(this.jSendToBackContextItem);
        this.jBringToFrontContextItem = new JMenuItem("Bring to Front");
        this.jBringToFrontContextItem.setActionCommand("BringToFront");
        this.makeMenuListener(this.jBringToFrontContextItem);
        this.jEditTextItem = new JMenuItem("Edit");
        this.jEditTextItem.setActionCommand("EditText");
        this.makeMenuListener(this.jEditTextItem);
        this.jEditMapItem = new JMenuItem("Edit");
        this.jEditMapItem.setActionCommand("EditMap");
        this.makeMenuListener(this.jEditMapItem);
        this.jSeparator5 = new JSeparator();
        this.jSeparator6 = new JSeparator();
        this.jSeparator12 = new JSeparator();
        this.jSeparator13 = new JSeparator();
        this.contextMenu.add(this.jCutContextItem);
        this.contextMenu.add(this.jCopyContextItem);
        this.contextMenu.add(this.jPasteContextItem);
        this.contextMenu.add(this.jSeparator5);
        this.contextMenu.add(this.jGroupContextItem);
        this.contextMenu.add(this.jUngroupContextItem);
        this.contextMenu.add(this.jSeparator6);
        this.contextMenu.add(this.jSendBackwardsContextItem);
        this.contextMenu.add(this.jBringForwardsContextItem);
        this.contextMenu.add(this.jSendToBackContextItem);
        this.contextMenu.add(this.jBringToFrontContextItem);
        this.canvas.setPopup(this.contextMenu);
        try {
            Class.forName("org.apache.fop.svg.PDFDocumentGraphics2D");
        }
        catch (ClassNotFoundException e) {
            this.jPDFItem.setEnabled(false);
        }
        try {
            Class.forName("org.apache.batik.svggen.SVGGraphics2D");
        }
        catch (ClassNotFoundException e) {
            this.jSVGItem.setEnabled(false);
        }
        this.jProgressBar.setVisible(false);
        this.setIconImage(FileUtils.createMultiDpiImageIcon("/gesticulate-48.png").getImage());
        this.getContentPane().add((Component)this.jScrollCanvas, "Center");
        this.setSize(new Dimension(1000, this.sceneHeight));
        this.setLocation(this.frameLeft, this.frameTop);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MainFrame.this.exitForm(evt);
            }
        });
        this.setDefaultCloseOperation(3);
        this.registerForMacOSXEvents();
    }

    public void initializeDocument() {
        this.document = new Document();
        CanvasView view = this.canvas.getView();
        view.initializeView();
        view.setDocument(this.document);
        view.enableRichText(true);
        view.setEnableSync(false);
        this.canvas.initializeHandlers();
        this.editMenuBean = new EditMenuBean();
        this.editMenuBean.addPropertyChangeListener(this);
        this.canvas.setEditMenuBean(this.editMenuBean);
        this.share = new ShareUtils(this);
        this.setStatus("Selection mode.");
    }

    private void exitForm(WindowEvent event) {
        this.saveUserPreferences();
        System.exit(0);
    }

    private void saveUserPreferences() {
        Properties userPrefs = this.config.getUserPreferences();
        userPrefs.setProperty("darkTheme", Boolean.toString(this.isDarkTheme()));
        userPrefs.setProperty("canvasColor", this.toRGBCode(this.canvasBackgroundColor));
        this.config.setUserPreferences(userPrefs);
        logger.finest("set user preferences");
    }

    public void registerForMacOSXEvents() {
        if (MAC_OS_X && Desktop.isDesktopSupported()) {
            Desktop.getDesktop().setAboutHandler(this::about);
            Desktop.getDesktop().setQuitHandler(this::quit);
            Desktop.getDesktop().setOpenFileHandler(this::openCanvas);
        }
    }

    public void about(AboutEvent event) {
        if (this.aboutBox == null) {
            this.aboutBox = new AboutBox();
        }
        this.aboutBox.setLocation(500 + this.getLocationOnScreen().x, this.sceneHeight / 2 + this.getLocationOnScreen().y);
        this.aboutBox.setResizable(false);
        SwingUtilities.updateComponentTreeUI(this.aboutBox);
        this.aboutBox.setVisible(true);
    }

    public boolean quit(QuitEvent event, QuitResponse response) {
        this.saveUserPreferences();
        response.performQuit();
        return true;
    }

    public void preferences(PreferencesEvent event) {
    }

    public void keyHelp() {
        if (this.helpBox == null) {
            this.helpBox = new KeyboardHelp(this);
            this.helpBox.init();
        }
        this.helpBox.readDocument(this.isDarkTheme);
        this.helpBox.setLocation(500 + this.getLocationOnScreen().x, this.sceneHeight / 2 + this.getLocationOnScreen().y);
        SwingUtilities.updateComponentTreeUI(this.helpBox);
        this.helpBox.setVisible(true);
    }

    public void licenceHelp() {
        if (this.licenceBox == null) {
            this.licenceBox = new LicenceScreen(this);
            this.licenceBox.init();
        }
        this.licenceBox.readDocument(this.isDarkTheme);
        this.licenceBox.setLocation(500 + this.getLocationOnScreen().x, this.sceneHeight / 2 + this.getLocationOnScreen().y);
        SwingUtilities.updateComponentTreeUI(this.licenceBox);
        this.licenceBox.setVisible(true);
    }

    public void showIconLibrary() {
        if (this.libraryBox == null) {
            this.libraryBox = new IconLibrary(this);
            this.libraryBox.init();
            this.libraryBox.setLocation(1000 + this.getLocationOnScreen().x, this.sceneHeight / 4 + this.getLocationOnScreen().y);
        }
        this.libraryBox.setVisible(!this.libraryBox.isVisible());
        this.libraryBox.resetShift();
    }

    private void initComponents() {
        this.jInsertGroup = new ButtonGroup();
        this.jMapGroup = new ButtonGroup();
        this.jThemeGroup = new ButtonGroup();
        this.jStatusPanel = new JPanel();
        this.jStatusArea = new JTextArea();
        this.jProgressBar = new JProgressBar();
        this.jSeparator8 = new JSeparator();
        this.jMenuBar = new JMenuBar();
        this.jFileMenu = new JMenu();
        this.jNewItem = new JMenuItem();
        this.jOpenItem = new JMenuItem();
        this.makeMenuListener(this.jOpenItem);
        this.jSaveItem = new JMenuItem();
        this.makeMenuListener(this.jSaveItem);
        this.jSaveAsItem = new JMenuItem();
        this.makeMenuListener(this.jSaveAsItem);
        this.jSeparator1 = new JSeparator();
        this.jPrintItem = new JMenuItem();
        this.jPDFItem = new JMenuItem();
        this.jSVGItem = new JMenuItem();
        this.jPNGItem = new JMenuItem();
        this.jEditMenu = new JMenu();
        this.jInsertMenu = new JMenu();
        this.jMenuSlope = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuSlope);
        this.jMenuHorizontal = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuHorizontal);
        this.jMenuVertical = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuVertical);
        this.jMenuCircle = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuCircle);
        this.jMenuSquare = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuSquare);
        this.jMenuTriangle = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuTriangle);
        this.jMenuHexagon = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuHexagon);
        this.jMenuPentagram = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuPentagram);
        this.jMenuPolygon = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuPolygon);
        this.jMenuSketch = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuSketch);
        this.jMenuText = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuText);
        this.jSeparator2 = new JSeparator();
        this.jMenuStreetMap = new JMenuItem();
        this.makeMenuListener(this.jMenuStreetMap);
        this.jSeparator9 = new JSeparator();
        this.jMenuOpenStreetmap = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuOpenStreetmap);
        this.jMenuOsmTransport = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuOsmTransport);
        this.jMenuOsmOutdoors = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuOsmOutdoors);
        this.jMenuOsmLandscape = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuOsmLandscape);
        this.jMenuBingMaps = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuBingMaps);
        this.jMenuBingAerial = new JRadioButtonMenuItem();
        this.makeMenuListener(this.jMenuBingAerial);
        this.jSeparator10 = new JSeparator();
        this.jMenuPicture = new JMenuItem();
        this.makeMenuListener(this.jMenuPicture);
        this.jMenuSVGItem = new JMenuItem();
        this.makeMenuListener(this.jMenuSVGItem);
        this.jToolsMenu = new JMenu();
        this.jMenuEnact = new JMenuItem();
        this.makeMenuListener(this.jMenuEnact);
        this.jMenuSync = new JMenuItem();
        this.makeMenuListener(this.jMenuSync);
        this.jHelpMenu = new JMenu();
        this.jMenuKeyHelp = new JMenuItem();
        this.makeMenuListener(this.jMenuKeyHelp);
        this.jMenuLicenceHelp = new JMenuItem();
        this.makeMenuListener(this.jMenuLicenceHelp);
        this.setDefaultCloseOperation(3);
        this.jStatusPanel.setFocusable(false);
        this.jStatusPanel.setRequestFocusEnabled(false);
        this.jStatusPanel.setLayout(new BoxLayout(this.jStatusPanel, 0));
        this.jStatusArea.setEditable(false);
        this.jStatusArea.setColumns(1);
        this.jStatusArea.setRows(1);
        this.jStatusArea.setFocusable(false);
        this.jStatusArea.setMargin(new Insets(2, 5, 2, 2));
        this.jStatusArea.setMinimumSize(new Dimension(7, 16));
        this.jStatusArea.setOpaque(false);
        this.jStatusArea.setPreferredSize(new Dimension(300, 20));
        this.jStatusPanel.add(Box.createHorizontalStrut(5));
        this.jStatusPanel.add(this.jStatusArea);
        this.jStatusPanel.add(Box.createHorizontalGlue());
        this.jStatusArea.setBorder(BorderFactory.createEmptyBorder());
        this.jStatusArea.setBackground(new Color(0, 0, 0, 0));
        this.jProgressBar.setFocusable(false);
        this.jProgressBar.setPreferredSize(new Dimension(50, 20));
        this.jStatusPanel.add(this.jProgressBar);
        this.jStatusPanel.add(Box.createHorizontalStrut(50));
        this.getContentPane().add((Component)this.jStatusPanel, "Last");
        this.getContentPane().add((Component)this.jSeparator8, "Center");
        this.jFileMenu.setText("File");
        this.jFileMenu.setFocusable(false);
        this.jNewItem.setText("New");
        this.makeMenuListener(this.jNewItem);
        this.jFileMenu.add(this.jNewItem);
        this.jOpenItem.setText("Open...");
        this.jOpenItem.setActionCommand("Open");
        this.jFileMenu.add(this.jOpenItem);
        this.jSaveItem.setText("Save");
        this.jFileMenu.add(this.jSaveItem);
        this.jSaveAsItem.setText("Save As...");
        this.jSaveAsItem.setActionCommand("SaveAs");
        this.jFileMenu.add(this.jSaveAsItem);
        this.jFileMenu.add(this.jSeparator1);
        this.jPrintItem.setText("Print...");
        this.jPrintItem.setActionCommand("Print");
        this.makeMenuListener(this.jPrintItem);
        this.jFileMenu.add(this.jPrintItem);
        this.jPDFItem.setText("Export to PDF...");
        this.jPDFItem.setActionCommand("exportPDF");
        this.makeMenuListener(this.jPDFItem);
        this.jFileMenu.add(this.jPDFItem);
        this.jSVGItem.setText("Export to SVG...");
        this.jSVGItem.setActionCommand("exportSVG");
        this.makeMenuListener(this.jSVGItem);
        this.jFileMenu.add(this.jSVGItem);
        this.jPNGItem.setText("Export Image...");
        this.jPNGItem.setActionCommand("exportPNG");
        this.makeMenuListener(this.jPNGItem);
        this.jFileMenu.add(this.jPNGItem);
        this.jMenuBar.add(this.jFileMenu);
        this.jEditMenu.setText("Edit");
        this.jEditMenu.setFocusable(false);
        this.jMenuBar.add(this.jEditMenu);
        this.jInsertMenu.setText("Insert");
        this.jInsertMenu.setFocusable(false);
        this.jInsertGroup.add(this.jMenuSlope);
        this.jMenuSlope.setText("Line");
        this.jInsertMenu.add(this.jMenuSlope);
        this.jInsertGroup.add(this.jMenuHorizontal);
        this.jMenuHorizontal.setSelected(true);
        this.jMenuHorizontal.setText("Horizontal");
        this.jInsertMenu.add(this.jMenuHorizontal);
        this.jInsertGroup.add(this.jMenuVertical);
        this.jMenuVertical.setText("Vertical");
        this.jInsertMenu.add(this.jMenuVertical);
        this.jInsertGroup.add(this.jMenuCircle);
        this.jMenuCircle.setText("Circle");
        this.jInsertMenu.add(this.jMenuCircle);
        this.jInsertGroup.add(this.jMenuSquare);
        this.jMenuSquare.setText("Square");
        this.jInsertMenu.add(this.jMenuSquare);
        this.jInsertGroup.add(this.jMenuTriangle);
        this.jMenuTriangle.setText("Triangle");
        this.jInsertMenu.add(this.jMenuTriangle);
        this.jInsertGroup.add(this.jMenuHexagon);
        this.jMenuHexagon.setText("Hexagon");
        this.jInsertMenu.add(this.jMenuHexagon);
        this.jInsertGroup.add(this.jMenuPentagram);
        this.jMenuPentagram.setText("Pentagram");
        this.jInsertMenu.add(this.jMenuPentagram);
        this.jInsertGroup.add(this.jMenuPolygon);
        this.jMenuPolygon.setText("Polygon");
        this.jInsertMenu.add(this.jMenuPolygon);
        this.jInsertGroup.add(this.jMenuSketch);
        this.jMenuSketch.setText("Sketch");
        this.jInsertMenu.add(this.jMenuSketch);
        this.jInsertGroup.add(this.jMenuText);
        this.jMenuText.setText("Text");
        this.jInsertMenu.add(this.jMenuText);
        this.jInsertMenu.add(this.jSeparator2);
        this.jMenuStreetMap.setText("Mapping...");
        this.jMenuStreetMap.setActionCommand("InsertMap");
        this.jInsertMenu.add(this.jMenuStreetMap);
        this.jInsertMenu.add(this.jSeparator9);
        this.jMapGroup.add(this.jMenuOpenStreetmap);
        this.jMenuOpenStreetmap.setSelected(true);
        this.jMenuOpenStreetmap.setText("OpenStreetMap");
        this.jMenuOpenStreetmap.setActionCommand("StreetMap");
        this.jInsertMenu.add(this.jMenuOpenStreetmap);
        this.jMapGroup.add(this.jMenuOsmTransport);
        this.jMenuOsmTransport.setText("Transport Map");
        this.jMenuOsmTransport.setActionCommand("OsmTransport");
        this.jInsertMenu.add(this.jMenuOsmTransport);
        this.jMapGroup.add(this.jMenuOsmOutdoors);
        this.jMenuOsmOutdoors.setText("Outdoors Map");
        this.jMenuOsmOutdoors.setActionCommand("OsmOutdoors");
        this.jInsertMenu.add(this.jMenuOsmOutdoors);
        this.jMapGroup.add(this.jMenuOsmLandscape);
        this.jMenuOsmLandscape.setText("Landscape Map");
        this.jMenuOsmLandscape.setActionCommand("OsmLandscape");
        this.jInsertMenu.add(this.jMenuOsmLandscape);
        this.jMapGroup.add(this.jMenuBingMaps);
        this.jMenuBingMaps.setText("Bing Maps");
        this.jMenuBingMaps.setActionCommand("BingMaps");
        this.jInsertMenu.add(this.jMenuBingMaps);
        this.jMapGroup.add(this.jMenuBingAerial);
        this.jMenuBingAerial.setText("Bing Aerial");
        this.jMenuBingAerial.setActionCommand("BingAerial");
        this.jInsertMenu.add(this.jMenuBingAerial);
        this.jInsertMenu.add(this.jSeparator10);
        this.jMenuPicture.setText("Image...");
        this.jMenuPicture.setActionCommand("Picture");
        this.jInsertMenu.add(this.jMenuPicture);
        this.jMenuSVGItem.setText("Vector Image...");
        this.jMenuSVGItem.setActionCommand("SVGImage");
        this.jInsertMenu.add(this.jMenuSVGItem);
        this.jMenuBar.add(this.jInsertMenu);
        this.jToolsMenu.setText("Tools");
        this.jToolsMenu.setFocusable(false);
        this.jMenuEnact.setText("Enable Sync");
        this.jMenuEnact.setActionCommand("Enact");
        this.jToolsMenu.add(this.jMenuEnact);
        this.jMenuSync.setText("Sync");
        this.jToolsMenu.add(this.jMenuSync);
        this.jMenuBar.add(this.jToolsMenu);
        this.jHelpMenu.setText("Help");
        this.jMenuKeyHelp.setText("Keyboard...");
        this.jMenuKeyHelp.setActionCommand("KeyHelp");
        this.jHelpMenu.add(this.jMenuKeyHelp);
        this.jMenuLicenceHelp.setText("Terms...");
        this.jMenuLicenceHelp.setActionCommand("LicenceHelp");
        this.jHelpMenu.add(this.jMenuLicenceHelp);
        this.jMenuBar.add(this.jHelpMenu);
        this.setJMenuBar(this.jMenuBar);
    }

    private JMenuItem makeMenuListener(JMenuItem m) {
        m.addActionListener(this);
        return m;
    }

    public void setInsertMenu(int control) {
        switch (control) {
            case 0: {
                this.setStatus("Draw Line selected.");
                this.jInsertGroup.setSelected(this.jMenuSlope.getModel(), true);
                break;
            }
            case 1: {
                this.setStatus("Draw Horizontal Line selected.");
                this.jInsertGroup.setSelected(this.jMenuHorizontal.getModel(), true);
                break;
            }
            case 2: {
                this.setStatus("Draw Vertical Line selected.");
                this.jInsertGroup.setSelected(this.jMenuVertical.getModel(), true);
                break;
            }
            case 3: {
                this.setStatus("Draw Circle selected.");
                this.jInsertGroup.setSelected(this.jMenuCircle.getModel(), true);
                break;
            }
            case 4: {
                this.setStatus("Draw Square selected.");
                this.jInsertGroup.setSelected(this.jMenuSquare.getModel(), true);
                break;
            }
            case 5: {
                this.setStatus("Draw Triangle selected.");
                this.jInsertGroup.setSelected(this.jMenuTriangle.getModel(), true);
                break;
            }
            case 6: {
                this.setStatus("Draw Hexagon selected.");
                this.jInsertGroup.setSelected(this.jMenuHexagon.getModel(), true);
                break;
            }
            case 7: {
                this.setStatus("Draw Pentagram selected.");
                this.jInsertGroup.setSelected(this.jMenuPentagram.getModel(), true);
                break;
            }
            case 8: {
                this.setStatus("Draw Polygon selected.");
                this.jInsertGroup.setSelected(this.jMenuPolygon.getModel(), true);
                break;
            }
            case 9: {
                this.setStatus("Draw Sketch selected.");
                this.jInsertGroup.setSelected(this.jMenuSketch.getModel(), true);
                break;
            }
            case 10: {
                this.setStatus("Draw Text selected.");
                this.jInsertGroup.setSelected(this.jMenuText.getModel(), true);
                break;
            }
            default: {
                this.jInsertGroup.setSelected(this.jMenuHorizontal.getModel(), true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String cmd;
        switch (cmd = actionEvent.getActionCommand()) {
            case "Quit": {
                this.saveUserPreferences();
                System.exit(0);
                break;
            }
            case "About": {
                this.about(null);
                break;
            }
            case "KeyHelp": {
                this.keyHelp();
                break;
            }
            case "LicenceHelp": {
                this.licenceHelp();
                break;
            }
            case "New": {
                this.canvas.getView().clearDocument();
                this.canvasFile = null;
                break;
            }
            case "Open": {
                this.setStatus("Open drawing.");
                File file = this.share.chooseCanvas();
                if (file == null) break;
                this.canvas.getView().clearDocument();
                this.share.readCanvas(file);
                this.canvasFile = file;
                this.toolButtons.setButtonMode(0);
                break;
            }
            case "Save": {
                if (this.canvasFile == null) {
                    this.share.exportCanvas();
                    break;
                }
                this.share.writeCanvas(this.canvasFile);
                break;
            }
            case "SaveAs": {
                this.share.exportCanvas();
                break;
            }
            case "Print": {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                printJob.setPrintable(this.canvas);
                if (!printJob.printDialog()) break;
                try {
                    printJob.print();
                }
                catch (PrinterException ex) {
                    logger.severe("Printing failed.");
                }
                break;
            }
            case "exportPDF": {
                this.share.exportPDF();
                break;
            }
            case "exportSVG": {
                this.share.exportSVG();
                break;
            }
            case "exportPNG": {
                this.share.exportPNG();
                break;
            }
            case "Sync": {
                this.setStatus("Synchronisation initiated.");
                this.canvas.getView().synchronise();
                break;
            }
            case "Picture": {
                this.setStatus("Reading pictures.");
                this.share.readPictures();
                break;
            }
            case "SVGImage": {
                this.setStatus("Reading vector images.");
                this.share.readSVG();
                break;
            }
            case "InsertMap": {
                this.canvas.getView().setEditing(KeyboardHandlerType.MAP);
                this.canvas.changeHandler(MouseHandlerType.MAP);
                this.canvas.getMapController().createMap();
                break;
            }
            case "EditMap": {
                this.canvas.editMapItem();
                break;
            }
            case "EditText": {
                this.canvas.editTextItem();
                break;
            }
            case "Enact": {
                boolean isSync = this.canvas.getView().getEnableSync();
                if (!isSync) {
                    this.jMenuEnact.setText("Disable Sync");
                    this.canvas.getView().unlinkDocument();
                    this.canvas.getView().setEnableSync(true);
                    this.canvas.getView().initDocument();
                    this.setStatus("Synchronisation enabled.");
                    break;
                }
                this.jMenuEnact.setText("Enable Sync");
                this.canvas.getView().unlinkDocument();
                this.canvas.getView().setEnableSync(false);
                this.canvas.getView().initDocument();
                this.setStatus("Synchronisation disabled.");
                break;
            }
            case "SendToBack": {
                if (this.canvas.getView().getSelected() == -1 || this.canvas.getView().isMapping() || this.canvas.getView().isEditing()) break;
                this.canvas.getView().sendToBack();
                break;
            }
            case "BringToFront": {
                if (this.canvas.getView().getSelected() == -1 || this.canvas.getView().isMapping() || this.canvas.getView().isEditing()) break;
                this.canvas.getView().bringToFront();
                break;
            }
            case "SendBackwards": {
                if (this.canvas.getView().getSelected() == -1 || this.canvas.getView().isMapping() || this.canvas.getView().isEditing()) break;
                this.canvas.getView().sendBackwards();
                break;
            }
            case "BringForwards": {
                if (this.canvas.getView().getSelected() == -1 || this.canvas.getView().isMapping() || this.canvas.getView().isEditing()) break;
                this.canvas.getView().bringForwards();
                break;
            }
            case "Group": {
                if (this.canvas.getView().getSelected() == -1 || this.canvas.getView().isMapping() || this.canvas.getView().isEditing()) break;
                this.canvas.getView().groupSelection();
                break;
            }
            case "Ungroup": {
                if (this.canvas.getView().getSelected() == -1 || this.canvas.getView().isMapping() || this.canvas.getView().isEditing()) break;
                this.canvas.getView().ungroupSelection();
                break;
            }
            case "Line": {
                this.setInsertMenu(0);
                this.toolButtons.setButtonMode(2);
                break;
            }
            case "Horizontal": {
                this.setInsertMenu(1);
                this.toolButtons.setButtonMode(3);
                break;
            }
            case "Vertical": {
                this.setInsertMenu(2);
                this.toolButtons.setButtonMode(4);
                break;
            }
            case "Circle": {
                this.setInsertMenu(3);
                this.toolButtons.setButtonMode(5);
                break;
            }
            case "Square": {
                this.setInsertMenu(4);
                this.toolButtons.setButtonMode(6);
                break;
            }
            case "Triangle": {
                this.setInsertMenu(5);
                this.toolButtons.setButtonMode(7);
                break;
            }
            case "Hexagon": {
                this.setInsertMenu(6);
                this.toolButtons.setButtonMode(8);
                break;
            }
            case "Pentagram": {
                this.setInsertMenu(7);
                this.toolButtons.setButtonMode(9);
                break;
            }
            case "Polygon": {
                this.setInsertMenu(8);
                this.toolButtons.setButtonMode(10);
                break;
            }
            case "Sketch": {
                this.setInsertMenu(9);
                this.toolButtons.setButtonMode(11);
                break;
            }
            case "Text": {
                this.setInsertMenu(10);
                this.toolButtons.setButtonMode(12);
                break;
            }
            case "StreetMap": {
                this.canvas.setMapSource(MapService.STREETMAP);
                break;
            }
            case "OsmTransport": {
                this.canvas.setMapSource(MapService.TRANSPORT);
                break;
            }
            case "OsmLandscape": {
                this.canvas.setMapSource(MapService.LANDSCAPE);
                break;
            }
            case "OsmOutdoors": {
                this.canvas.setMapSource(MapService.OUTDOORS);
                break;
            }
            case "BingMaps": {
                this.canvas.setMapSource(MapService.BING);
                break;
            }
            case "BingAerial": {
                this.canvas.setMapSource(MapService.AERIAL);
                break;
            }
            case "RichText": {
                if (this.canvas.getView().isEditing()) {
                    this.jMenuFormattedText.setSelected(!this.jMenuFormattedText.getModel().isSelected());
                    break;
                }
                this.canvas.getView().enableRichText(this.jMenuFormattedText.getModel().isSelected());
                break;
            }
            case "LightTheme": {
                this.setTheme(false);
                break;
            }
            case "DarkTheme": {
                this.setTheme(true);
                break;
            }
            case "Background": {
                Color thisColor = JColorChooser.showDialog(this, "Choose background colour", this.themeBackgroundColor);
                if (thisColor != null) {
                    this.canvasBackgroundColor = new Color(thisColor.getRGB());
                    this.themeFillColor = this.getThemeColor(this.canvasBackgroundColor);
                }
                this.canvas.setBackground(this.canvasBackgroundColor);
                break;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "textItemSelected": {
                if (this.editMenuBean.getTextItemSelected().booleanValue()) {
                    this.contextMenu.insert(this.jSeparator12, 0);
                    this.contextMenu.insert(this.jEditTextItem, 0);
                    SwingUtilities.updateComponentTreeUI(this.contextMenu);
                    this.contextMenu.pack();
                    break;
                }
                this.contextMenu.remove(this.jEditTextItem);
                this.contextMenu.remove(this.jSeparator12);
                this.contextMenu.validate();
                break;
            }
            case "mapItemSelected": {
                if (this.editMenuBean.getMapItemSelected().booleanValue()) {
                    this.contextMenu.insert(this.jSeparator13, 0);
                    this.contextMenu.insert(this.jEditMapItem, 0);
                    SwingUtilities.updateComponentTreeUI(this.contextMenu);
                    this.contextMenu.pack();
                    break;
                }
                this.contextMenu.remove(this.jEditMapItem);
                this.contextMenu.remove(this.jSeparator13);
                this.contextMenu.validate();
                break;
            }
        }
    }

    public void setCanvasFile(File file) {
        this.canvasFile = file;
    }

    public void loadCanvas(List<File> files) {
        File file = files.get(0);
        if (FileUtils.getExtension(file).equals("gst")) {
            this.share.readCanvas(file);
            this.setCanvasFile(file);
        } else {
            this.share.readPictures(files);
        }
    }

    public void openCanvas(FilesEvent event) {
        List<File> files = event.getFiles();
        if (files.get(0) instanceof File && FileUtils.getExtension(files.get(0)).equals("gst")) {
            this.canvas.getView().clearDocument();
            this.share.readCanvas(files.get(0));
            this.setCanvasFile(files.get(0));
        } else {
            this.share.readPictures(files);
        }
    }

    public List<File> getImageFiles() {
        return this.share.getImageFiles();
    }

    public void snapshotPNG() {
        this.share.snapshotPNG();
    }

    public void enablePNGButton(boolean isEnabled) {
        this.toolPanel.enablePNGButton(isEnabled);
    }

    public void setStatus(String s) {
        this.jStatusArea.setText(s);
    }

    public void setTransparency(boolean isSet) {
        if (isSet) {
            this.canvas.setTransparency(0);
            this.setStatus("Outline drawing.");
        } else {
            this.canvas.setTransparency(100);
            this.setStatus("Outline drawing off.");
        }
    }

    public void setDropperTool(boolean selected) {
        if (selected) {
            this.canvas.setDropperTool(true);
            this.setStatus("Dropper tool selected.");
        } else {
            this.canvas.setDropperTool(false);
            this.setStatus("Dropper tool off.");
        }
    }

    public void setTheme(boolean isDarkTheme) {
        if (isDarkTheme) {
            this.themeBackgroundColor = new Color(51, 51, 51);
            this.themeAccentColor = new Color(192, 196, 129);
            this.canvasBackgroundColor = this.themeBackgroundColor;
            this.themeFillColor = this.getThemeColor(this.themeBackgroundColor);
        } else {
            this.themeBackgroundColor = Color.white;
            this.themeAccentColor = Color.black;
            this.canvasBackgroundColor = this.themeBackgroundColor;
            this.themeFillColor = this.getThemeColor(this.themeBackgroundColor);
        }
        Gesticulate.installTheme(isDarkTheme);
        this.canvas.setTheme();
        AcceptIcon.setColor(this.canvas.getThemeFillColor());
        QuitIcon.setColor(isDarkTheme ? this.canvas.getThemeFillColor() : new Color(0xA8A8A8));
        this.getToolPanel().setImageIcons(isDarkTheme);
        this.getToolPanel().updateComponentUI();
        this.getToolButtons().setImageIcons(isDarkTheme);
        this.getToolButtons().updateComponentUI();
        SwingUtilities.updateComponentTreeUI(this.contextMenu);
        SwingUtilities.updateComponentTreeUI(this);
        if (this.libraryBox != null) {
            this.libraryBox.redraw();
        }
        this.pack();
        this.isDarkTheme = isDarkTheme;
    }

    private Color getThemeColor(Color color) {
        int rgb = color.getRGB();
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        Color newColor = rgb < -8355712 ? new Color((float)(r >= 26 ? r - 26 : 0) / 255.0f, (float)(g >= 26 ? g - 26 : 0) / 255.0f, (float)(b >= 26 ? b - 26 : 0) / 255.0f, 1.0f) : new Color((float)(r >= 44 ? r - 44 : 0) / 255.0f, (float)(g >= 44 ? g - 44 : 0) / 255.0f, (float)(b >= 44 ? b - 44 : 0) / 255.0f, 1.0f);
        return newColor;
    }

    public String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
    }

    public Color fromRGBCode(String colorStr) {
        return new Color(Integer.parseInt(colorStr.substring(1, 3), 16), Integer.parseInt(colorStr.substring(3, 5), 16), Integer.parseInt(colorStr.substring(5, 7), 16), 255);
    }

    public boolean isDarkTheme() {
        return this.isDarkTheme;
    }

    public Color getThemeFillColor() {
        return this.themeFillColor;
    }

    public Color getThemeBackgroundColor() {
        return this.themeBackgroundColor;
    }

    public Color getThemeAccentColor() {
        return this.themeAccentColor;
    }

    public Color getCanvasBackgroundColor() {
        return this.canvasBackgroundColor;
    }

    public DrawingCanvas getCanvas() {
        return this.canvas;
    }

    public ToolPanel getToolPanel() {
        return this.toolPanel;
    }

    public JProgressBar getProgress() {
        return this.jProgressBar;
    }

    public ToolButtons getToolButtons() {
        return this.toolButtons;
    }
}

