/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.image.BufferedImage;
import java.beans.ConstructorProperties;
import java.beans.Transient;
import java.time.Instant;
import java.util.Date;

public class ImageItem {
    private transient BufferedImage image;
    private String format;
    private int referenceCount;
    private Instant timestamp;

    public ImageItem() {
        this.image = null;
        this.format = "";
        this.referenceCount = 0;
        this.timestamp = Instant.now();
    }

    public ImageItem(BufferedImage image, String format, int count) {
        this.image = image;
        this.format = format;
        this.referenceCount = count;
        this.timestamp = Instant.now();
    }

    public ImageItem(ImageItem item) {
        this(item.getImage(), item.getFormat(), item.getReferenceCount());
        item.setTimestamp(this.timestamp);
    }

    public ImageItem(ImageItem item, long offset) {
        this(item.getImage(), item.getFormat(), item.getReferenceCount());
        this.timestamp = Instant.ofEpochMilli(Instant.now().toEpochMilli() + offset);
        item.setTimestamp(this.timestamp);
    }

    @ConstructorProperties(value={"timestamp"})
    public ImageItem(Instant timestamp) {
        this();
        this.timestamp = timestamp;
    }

    public ImageItem(BufferedImage image) {
        this();
        this.image = image;
        ++this.referenceCount;
    }

    public void setReferenceCount(int referenceCount) {
        this.referenceCount = referenceCount;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    @Transient
    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @Transient
    public BufferedImage getImage() {
        return this.image;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp.toInstant();
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }
}

