/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.fonts.inter.FlatInterFont;
import com.formdev.flatlaf.fonts.roboto_mono.FlatRobotoMonoFont;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.perspective.draw.ConfigSetup;
import net.perspective.draw.MainFrame;

public class Gesticulate {
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    private static final boolean PC_WIN = System.getProperty("os.name").toLowerCase().startsWith("windows");

    public static void main(String[] args) {
        ArrayList<File> files = new ArrayList<File>();
        if (args.length > 0) {
            for (String arg : args) {
                files.add(new File(arg));
            }
        }
        ConfigSetup config = new ConfigSetup();
        if (MAC_OS_X) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.application.appearance", "system");
        }
        boolean isDarkMode = Boolean.parseBoolean(config.getUserPreferences().getProperty("darkTheme"));
        Gesticulate.initLookAndFeel(isDarkMode);
        SwingUtilities.invokeLater(() -> {
            MainFrame newFrame = new MainFrame();
            if (MAC_OS_X && SystemInfo.isMacFullWindowContentSupported) {
                newFrame.getRootPane().putClientProperty("apple.awt.fullWindowContent", true);
                newFrame.getRootPane().putClientProperty("apple.awt.transparentTitleBar", true);
                newFrame.getRootPane().putClientProperty("apple.awt.windowTitleVisible", false);
                newFrame.getRootPane().putClientProperty("apple.awt.fullscreenable", true);
                newFrame.getRootPane().putClientProperty("FlatLaf.macOS.windowButtonsSpacing", "large");
                newFrame.setTitle(null);
            }
            newFrame.initializeFrame(config);
            newFrame.initializeDocument();
            if (!MAC_OS_X) {
                newFrame.setTitle("Gesticulate");
            }
            newFrame.pack();
            newFrame.setVisible(true);
            if (!files.isEmpty()) {
                newFrame.loadCanvas(files);
            }
        });
    }

    private static void initLookAndFeel(boolean isDarkMode) {
        Gesticulate.installFonts();
        Gesticulate.installTheme(isDarkMode);
        Gesticulate.setDefaultProperties();
    }

    public static void installTheme(boolean isDarkMode) {
        if (MAC_OS_X) {
            FlatLaf.setSystemColorGetter(name -> name.equals("accentColor") ? Gesticulate.fromRGBCode("#3e72d4") : null);
        }
        if (MAC_OS_X && isDarkMode) {
            Gesticulate.installMacDark();
            FlatMacDarkLaf.setup();
        } else if (MAC_OS_X && !isDarkMode) {
            Gesticulate.installMacLight();
            FlatMacLightLaf.setup();
        } else if (!MAC_OS_X && isDarkMode) {
            Gesticulate.installWinDark();
            FlatDarkLaf.setup();
        } else if (!MAC_OS_X && !isDarkMode) {
            Gesticulate.installWinLight();
            FlatLightLaf.setup();
        }
    }

    private static void installMacDark() {
        HashMap<String, String> darkModeAdjustments = new HashMap<String, String>();
        darkModeAdjustments.put("Button.background", "#3a3a3a");
        darkModeAdjustments.put("ToggleButton.background", "#3a3a3a");
        darkModeAdjustments.put("ToggleButton.selectedBackground", "#535353");
        darkModeAdjustments.put("ComboBox.background", "#333333");
        darkModeAdjustments.put("ComboBox.popupBackground", "#333333");
        darkModeAdjustments.put("PopupMenu.borderColor", "#333333");
        darkModeAdjustments.put("Component.borderColor", "#333333");
        FlatLaf.setGlobalExtraDefaults(darkModeAdjustments);
    }

    private static void installMacLight() {
        HashMap<String, String> lightModeAdjustments = new HashMap<String, String>();
        lightModeAdjustments.put("ToggleButton.selectedBackground", "#e4e4e4");
        lightModeAdjustments.put("ComboBox.background", "#ffffff");
        lightModeAdjustments.put("ComboBox.popupBackground", "#ffffff");
        lightModeAdjustments.put("PopupMenu.borderColor", "#ffffff");
        lightModeAdjustments.put("PopupMenu.background", "#ffffff");
        FlatLaf.setGlobalExtraDefaults(lightModeAdjustments);
    }

    private static void installWinDark() {
        HashMap<String, String> darkModeAdjustments = new HashMap<String, String>();
        darkModeAdjustments.put("@background", "#1e1e1e");
        darkModeAdjustments.put("@foreground", "#e0e0e0");
        darkModeAdjustments.put("@accentColor", "#107aff");
        darkModeAdjustments.put("@accentFocusColor", "#176896");
        darkModeAdjustments.put("CheckBox.icon.style", "filled");
        darkModeAdjustments.put("CheckBox.icon[filled].selectedBorderColor", "tint(@background,19%)");
        darkModeAdjustments.put("CheckBox.icon[filled].selectedBackground", "lighten(@background,5%)");
        darkModeAdjustments.put("CheckBox.icon[filled].checkmarkColor", "@foreground");
        darkModeAdjustments.put("RadioButton.icon.style", "filled");
        darkModeAdjustments.put("RadioButton.icon[filled].centerDiameter", "6");
        FlatLaf.setGlobalExtraDefaults(darkModeAdjustments);
    }

    private static void installWinLight() {
        HashMap<String, String> lightModeAdjustments = new HashMap<String, String>();
        lightModeAdjustments.put("@background", "#f6f6f6");
        lightModeAdjustments.put("@foreground", "over(#000000d8,@background)");
        lightModeAdjustments.put("@accentColor", "#007aff");
        lightModeAdjustments.put("@accentFocusColor", "#0067f47f");
        lightModeAdjustments.put("CheckBox.icon.style", "filled");
        lightModeAdjustments.put("CheckBox.icon[filled].selectedBorderColor", "tint(@accentBase2Color,20%)");
        lightModeAdjustments.put("CheckBox.icon[filled].selectedBackground", "lighten(@background,5%)");
        lightModeAdjustments.put("CheckBox.icon[filled].checkmarkColor", "@foreground");
        lightModeAdjustments.put("RadioButton.icon.style", "filled");
        lightModeAdjustments.put("RadioButton.icon[filled].centerDiameter", "6");
        FlatLaf.setGlobalExtraDefaults(lightModeAdjustments);
    }

    private static void installFonts() {
        FlatInterFont.install();
        FlatRobotoMonoFont.install();
        FlatLaf.setPreferredFontFamily((String)"Inter");
        FlatLaf.setPreferredLightFontFamily((String)"Inter Light");
        FlatLaf.setPreferredSemiboldFontFamily((String)"Inter SemiBold");
        FlatLaf.setPreferredMonospacedFontFamily((String)"Roboto Mono");
    }

    private static void setDefaultProperties() {
        if (MAC_OS_X) {
            UIManager.put("Button.arc", 8);
            UIManager.put("Component.arc", 12);
            UIManager.put("CheckBox.arc", 6);
            UIManager.put("ProgressBar.arc", 6);
            UIManager.put("TabbedPane.tabArc", 12);
            UIManager.put("TabbedPane.tabSelectionArc", 6);
            UIManager.put("PopupMenu.roundedBorderWidth", 4);
            UIManager.put("ComboBox.roundedBorderWidth", 4);
            UIManager.put("ToolTip.roundedBorderWidth", 4);
            UIManager.put("Popup.roundedBorderWidth", 4);
        } else {
            UIManager.put("Button.arc", 3);
            UIManager.put("Component.arc", 3);
            UIManager.put("CheckBox.arc", 3);
            UIManager.put("ProgressBar.arc", 3);
            UIManager.put("TabbedPane.tabArc", 3);
            UIManager.put("TabbedPane.tabSelectionArc", 3);
            UIManager.put("PopupMenu.borderCornerRadius", 4);
            UIManager.put("ComboBox.borderCornerRadius", 4);
            UIManager.put("ToolTip.borderCornerRadius", 4);
            UIManager.put("Popup.borderCornerRadius", 4);
            UIManager.put("ComboBox.popupInsets", new Insets(1, 0, 1, 0));
            UIManager.put("ComboBox.selectionInsets", new Insets(0, 1, 0, 1));
            UIManager.put("ComboBox.selectionArc", 6);
            UIManager.put("@menuItemMargin", new Insets(3, 9, 3, 9));
            UIManager.put("MenuBar.selectionBackground", "darken(@menuBackground,15%,derived)");
            UIManager.put("MenuBar.selectionForeground", "@foreground");
            UIManager.put("MenuBar.selectionInsets", new Insets(1, 0, 1, 0));
            UIManager.put("MenuBar.selectionEmbeddedInsets", new Insets(3, 0, 3, 0));
            UIManager.put("MenuItem.selectionInsets", new Insets(0, 3, 0, 3));
            UIManager.put("MenuItem.selectionArc", 8);
        }
        UIManager.put("ScrollBar.showButtons", true);
        UIManager.put("ScrollBar.width", 14);
        UIManager.put("ScrollBar.thumbArc", 3);
        UIManager.put("MenuItem.margin", new Insets(4, 8, 4, 8));
        UIManager.put("CheckBoxMenuItem.margin", new Insets(4, 8, 4, 8));
        UIManager.put("RadioButtonMenuItem.margin", new Insets(4, 8, 4, 8));
        UIManager.put("TabbedPane.tabSelectionInsets", new Insets(0, 4, 0, 4));
        if (PC_WIN) {
            UIManager.put("JRootPane.useWindowDecorations", false);
            UIManager.put("JRootPane.menuBarEmbedded", true);
        }
        if (!MAC_OS_X) {
            UIManager.put("Component.arrowType", "triangle");
        }
    }

    private static Color fromRGBCode(String colorStr) {
        return new Color(Integer.parseInt(colorStr.substring(1, 3), 16), Integer.parseInt(colorStr.substring(3, 5), 16), Integer.parseInt(colorStr.substring(5, 7), 16), 255);
    }
}

