/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.im.InputMethodRequests;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.Optional;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.perspective.draw.CanvasView;
import net.perspective.draw.MainFrame;
import net.perspective.draw.MapController;
import net.perspective.draw.TextController;
import net.perspective.draw.enums.DrawingType;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.enums.Media;
import net.perspective.draw.enums.MouseHandlerType;
import net.perspective.draw.event.CanvasMouseListener;
import net.perspective.draw.event.EventHandler;
import net.perspective.draw.event.FigureMouseHandler;
import net.perspective.draw.event.MapMouseHandler;
import net.perspective.draw.event.RotationMouseHandler;
import net.perspective.draw.event.SelectionMouseHandler;
import net.perspective.draw.event.SketchMouseHandler;
import net.perspective.draw.event.TextMouseHandler;
import net.perspective.draw.event.keyboard.KeyboardHandler;
import net.perspective.draw.event.keyboard.MapKeyboardHandler;
import net.perspective.draw.event.keyboard.MovementHandler;
import net.perspective.draw.event.keyboard.TextKeyboardHandler;
import net.perspective.draw.geom.ArrowType;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Edge;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureFactory;
import net.perspective.draw.geom.FigureFactoryImpl;
import net.perspective.draw.geom.FigureType;
import net.perspective.draw.geom.Grouped;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.geom.StreetMap;
import net.perspective.draw.geom.Text;
import net.perspective.draw.maps.MapService;
import net.perspective.draw.maps.Mapping;
import net.perspective.draw.swing.EditMenuBean;
import net.perspective.draw.swing.ToolPanel;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.G2;

public class DrawingCanvas
extends JPanel
implements Printable {
    private MainFrame frame;
    private final CanvasView view = new CanvasView(this);
    private final CanvasMouseListener mouselistener;
    private final MapController mapController = new MapController(this, this.view);
    private MapService mapsource;
    private Optional<DrawingType> drawtype;
    private DrawItem marquee;
    private Grouped guides;
    private FigureFactory figurefactory;
    private ArrowType arrowtype;
    private EventHandler event;
    private KeyboardHandler keyhandler;
    private JPopupMenu popup;
    private MouseListener popuplistener;
    private EditMenuBean editMenuBean;
    private Stroke stroke;
    private Stroke plainstroke;
    private Color strokecolor;
    private Color fillcolor;
    private String fontfamily = "Serif";
    private int fontstyle = 0;
    private int fontsize = 14;
    private int transparency = 100;
    private boolean rotationMode;
    private boolean gridVisible = false;
    private boolean multiSelectEnabled;
    private boolean isOneToOne = false;
    private boolean isDropperEnabled;
    private boolean isGuideEnabled;
    private MouseHandlerType handlertype;
    private MouseHandlerType oldhandlertype;
    private ToolPanel toolpanel;
    private InputMethodRequests inputMethodRequestsHandler;
    static final double PIB_12 = 0.2617993877991494;

    public DrawingCanvas() {
        this.mouselistener = new CanvasMouseListener();
        this.drawtype = Optional.of(DrawingType.HORIZONTAL);
        this.stroke = new BasicStroke(2.0f, 1, 1);
        this.plainstroke = new BasicStroke(2.0f, 1, 1);
        this.strokecolor = Color.black;
        this.fillcolor = new Color(153, 204, 255);
        this.arrowtype = ArrowType.NONE;
        this.mapsource = MapService.STREETMAP;
        this.guides = new Grouped();
        this.figurefactory = new FigureFactoryImpl();
    }

    public DrawingCanvas(MainFrame frame) {
        this();
        this.frame = frame;
    }

    public void init() {
        this.setBackground(this.frame.getCanvasBackgroundColor());
        this.setOpaque(true);
        this.setFocusable(true);
        this.setLayout(null);
    }

    public void setTheme() {
        this.setBackground(this.frame.getThemeBackgroundColor());
        this.repaint();
    }

    public boolean isDarkMode() {
        return this.frame.isDarkTheme();
    }

    public Color getThemeFillColor() {
        return this.frame.getThemeFillColor();
    }

    public Color getThemeBackgroundColor() {
        return this.frame.getThemeBackgroundColor();
    }

    public Color getThemeAccentColor() {
        return this.frame.getThemeAccentColor();
    }

    public Color getCanvasBackgroundColor() {
        return this.frame.getCanvasBackgroundColor();
    }

    public CanvasView getView() {
        return this.view;
    }

    public MapController getMapController() {
        return this.mapController;
    }

    public void initializeHandlers() {
        this.handlertype = MouseHandlerType.SELECTION;
        this.oldhandlertype = MouseHandlerType.SELECTION;
        this.keyhandler = new MovementHandler(this);
        this.addMouseListener(this.mouselistener);
        this.addMouseMotionListener(this.mouselistener);
        this.event = new SelectionMouseHandler(this);
        this.mouselistener.setEventHandler(this.event);
        if (this.popup != null) {
            this.popuplistener = new PopupListener();
            this.addMouseListener(this.popuplistener);
        }
    }

    public void changeHandler(MouseHandlerType handler) {
        this.oldhandlertype = this.handlertype;
        this.handlertype = handler;
        this.removeMouseListener(this.popuplistener);
        this.removeMouseWheelListener(this.mouselistener);
        switch (handler) {
            case SELECTION: {
                this.event = new SelectionMouseHandler(this);
                this.setRotationMode(false);
                this.addMouseListener(this.popuplistener);
                this.getMapController().removeSlider();
                break;
            }
            case ROTATION: {
                this.event = new RotationMouseHandler(this);
                this.setRotationMode(true);
                this.getMapController().removeSlider();
                this.view.setSelected(-1);
                break;
            }
            case DRAWITEM: {
                this.event = new FigureMouseHandler(this);
                this.setRotationMode(false);
                this.getMapController().removeSlider();
                this.view.setSelected(-1);
                break;
            }
            case SKETCH: {
                this.event = new SketchMouseHandler(this);
                this.setRotationMode(false);
                this.getMapController().removeSlider();
                this.view.setSelected(-1);
                break;
            }
            case TEXT: {
                this.event = new TextMouseHandler(this);
                this.setRotationMode(false);
                this.addMouseListener(this.popuplistener);
                this.getMapController().removeSlider();
                this.view.setSelected(-1);
                break;
            }
            case MAP: {
                this.event = new MapMouseHandler(this);
                this.setRotationMode(false);
                this.addMouseWheelListener(this.mouselistener);
                break;
            }
            default: {
                this.event = new SelectionMouseHandler(this);
                this.setRotationMode(false);
                this.getMapController().removeSlider();
                this.view.setSelected(-1);
            }
        }
        this.mouselistener.setEventHandler(this.event);
        this.repaint();
    }

    public MouseHandlerType getHandlerType() {
        return this.handlertype;
    }

    public void setKeyboardHandler(KeyboardHandlerType handler) {
        this.keyhandler.remove(this);
        this.keyhandler = switch (handler) {
            default -> throw new MatchException(null, null);
            case KeyboardHandlerType.TEXT -> new TextKeyboardHandler(this);
            case KeyboardHandlerType.MOVE -> new MovementHandler(this);
            case KeyboardHandlerType.MAP -> new MapKeyboardHandler(this);
        };
    }

    public void setDropperTool(boolean selected) {
        if (!selected) {
            if (this.oldhandlertype.equals((Object)MouseHandlerType.SELECTION)) {
                this.changeHandler(this.handlertype);
            } else {
                this.changeHandler(this.oldhandlertype);
            }
            this.isDropperEnabled = false;
        } else {
            this.changeHandler(MouseHandlerType.SELECTION);
            this.isDropperEnabled = true;
        }
    }

    public boolean getDropperDisabled() {
        return !this.isDropperEnabled;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setBackground(Color.white);
        if (this.gridVisible) {
            G2.drawGridLayout(g2, this);
        }
        g2.setColor(this.frame.getThemeFillColor());
        g2.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.5f, 1.5f}, 0.0f));
        g2.drawLine(926, 0, 926, 1300);
        if (this.view.hasGuides()) {
            this.guides.draw(g2, this);
        }
        this.drawCanvas(g2, Media.SCREEN);
        if (this.view.getSelected() != -1) {
            for (Integer drawing : this.view.getMultiSelection()) {
                this.view.getDrawings().get(drawing).drawAnchors(g2, this);
            }
            if (this.rotationMode) {
                G2.drawRotationPivot(g2, this);
            }
        }
        if (this.view.isDrawing() && this.view.getNewItem().isPresent()) {
            this.view.getNewItem().get().sketch(g2, this);
        }
        if (this.view.isMarquee()) {
            this.getMarquee().draw(g2, this);
        }
    }

    public void drawCanvas(Graphics2D g2, Media media) {
        DrawItem item;
        List<DrawItem> drawings = this.view.getDrawings();
        int selected = this.view.getSelected();
        if (selected != -1 && !((item = drawings.get(selected)) instanceof Text)) {
            selected = -1;
        }
        int i = 0;
        for (DrawItem item2 : drawings) {
            if (selected == i && media.equals((Object)Media.SCREEN) && this.view.isEditing()) {
                G2.highlightText(g2, this, item2);
            }
            item2.draw(g2, this);
            ++i;
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(pf.getImageableX() + 20.0, pf.getImageableY() + 20.0);
        g2.transform(AffineTransform.getScaleInstance(0.6, 0.6));
        if (pi >= 1) {
            return 1;
        }
        this.drawCanvas(g2, Media.PRINT);
        return 0;
    }

    public TextLayout getTextLayout(DrawItem item) {
        TextLayout layout = ((Text)item).getLayout(this);
        return layout;
    }

    public void setPopup(JPopupMenu popup) {
        this.popup = popup;
    }

    public void snapUp(DrawItem item) {
        double y = item.getTop()[0].getY();
        double yinc = (double)((int)(y / 10.0 + 0.5) - 1) * 10.0 - y;
        item.moveTo(0.0, yinc);
    }

    public void snapDown(DrawItem item) {
        double y = item.getTop()[0].getY();
        double yinc = (double)((int)(y / 10.0 + 0.5) + 1) * 10.0 - y;
        item.moveTo(0.0, yinc);
    }

    public void snapLeft(DrawItem item) {
        double x = item.getTop()[0].getX();
        double xinc = (double)((int)(x / 10.0 + 0.5) - 1) * 10.0 - x;
        item.moveTo(xinc, 0.0);
    }

    public void snapRight(DrawItem item) {
        double x = item.getTop()[0].getX();
        double xinc = (double)((int)(x / 10.0 + 0.5) + 1) * 10.0 - x;
        item.moveTo(xinc, 0.0);
    }

    public void moveToWithIncrements(DrawItem item, double xinc, double yinc) {
        double x = item.getTop()[0].getX();
        double inc_xa = (double)Math.round(xinc / 10.0) * 10.0;
        double inc_xc = x - (double)Math.round(x / 10.0) * 10.0;
        double y = item.getTop()[0].getY();
        double inc_ya = (double)Math.round(yinc / 10.0) * 10.0;
        double inc_yc = y - (double)Math.round(y / 10.0) * 10.0;
        item.moveTo(inc_xa - inc_xc, inc_ya - inc_yc);
    }

    public void rotateLeft(DrawItem item) {
        double angle = item.getAngle();
        double theta = (double)((int)(Math.signum(angle) * 0.5) - 1) * 0.2617993877991494;
        double zeta = (double)Math.round(angle / 0.2617993877991494) * 0.2617993877991494 + theta;
        this.rotateTo(item, zeta - angle);
    }

    public void rotateRight(DrawItem item) {
        double angle = item.getAngle();
        double theta = (double)((int)(Math.signum(angle) * 0.5) + 1) * 0.2617993877991494;
        double zeta = (double)Math.round(angle / 0.2617993877991494) * 0.2617993877991494 + theta;
        this.rotateTo(item, zeta - angle);
    }

    public void rotateWithIncrements(DrawItem item, double theta) {
        double angle = item.getAngle();
        double inc_th = (double)Math.round(theta / 0.2617993877991494) * 0.2617993877991494;
        double zeta = angle - (double)Math.round(angle / 0.2617993877991494) * 0.2617993877991494;
        this.rotateTo(item, inc_th - zeta);
    }

    public void rotateTo(DrawItem item, double theta) {
        if (item instanceof Figure && !((Figure)item).getType().equals((Object)FigureType.LINE) || item instanceof Text || item instanceof Grouped || item instanceof Picture && !(item instanceof StreetMap)) {
            double angle = item.getAngle();
            double zeta = angle + theta;
            if (zeta > Math.PI) {
                item.setAngle(zeta - Math.PI * 2);
            } else if (zeta < -Math.PI) {
                item.setAngle(zeta + Math.PI * 2);
            } else {
                item.setAngle(zeta);
            }
        } else if (item instanceof Figure && ((Figure)item).getType().equals((Object)FigureType.LINE)) {
            CanvasPoint s = this.rotatePoint((Figure)item, item.getStart(), theta);
            CanvasPoint e = this.rotatePoint((Figure)item, item.getEnd(), theta);
            item.setStart(s.x, s.y);
            item.setEnd(e.x, e.y);
            ((Figure)item).setPoints(DrawingType.LINE);
            ((Figure)item).setPath();
        }
    }

    protected CanvasPoint rotatePoint(Figure figure, CanvasPoint p, double angle) {
        CanvasPoint centre = figure.rotationCentre();
        CanvasPoint point = new CanvasPoint(p.x, p.y);
        point.translate(-centre.x, -centre.y);
        if (angle != 0.0) {
            point.rotate(angle);
        }
        point.translate(centre.x, centre.y);
        return point;
    }

    public void setMapSource(MapService service) {
        this.mapsource = service;
        Mapping mapping = Mapping.getInstance();
        if (this.view.isMapping()) {
            mapping.setTileSource(mapping.getMapService(service));
            mapping.refresh();
        }
    }

    public MapService getMapSource() {
        return this.mapsource;
    }

    public void exitMapping() {
        this.view.updateSelectedItem();
        this.frame.getToolButtons().setButtonMode(0);
        this.view.setEditing(KeyboardHandlerType.MOVE);
        this.changeHandler(MouseHandlerType.SELECTION);
    }

    protected void editMapItem() {
        DrawItem item;
        if (this.view.getSelected() != -1 && (item = this.view.getDrawings().get(this.view.getSelected())) instanceof StreetMap) {
            this.changeHandler(MouseHandlerType.MAP);
            this.view.setEditing(KeyboardHandlerType.MAP);
            this.mapController.initMap();
        }
    }

    public void setDrawType(DrawingType type) {
        this.drawtype = Optional.ofNullable(type);
    }

    public Optional<DrawingType> getDrawType() {
        if (!this.drawtype.isPresent()) {
            return Optional.empty();
        }
        DrawingType type = this.drawtype.get();
        if (this.isOneToOne()) {
            switch (type) {
                case CIRCLE: {
                    break;
                }
                case ELLIPSE: {
                    type = DrawingType.CIRCLE;
                    break;
                }
                case SQUARE: {
                    break;
                }
                case RECTANGLE: {
                    type = DrawingType.SQUARE;
                    break;
                }
                case TRIANGLE: {
                    break;
                }
                case ISOSCELES: {
                    type = DrawingType.TRIANGLE;
                    break;
                }
                case HEXAGON: {
                    type = DrawingType.ISOHEX;
                    break;
                }
                case ISOHEX: {
                    break;
                }
                case PENTAGRAM: {
                    type = DrawingType.ISOGRAM;
                    break;
                }
                case ISOGRAM: {
                    break;
                }
            }
        }
        return Optional.of(type);
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setPlainStroke(Stroke stroke) {
        this.plainstroke = stroke;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public Stroke getPlainStroke() {
        return this.plainstroke;
    }

    public void setStrokeColor(Color color) {
        this.strokecolor = color;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public Color getStrokeColor() {
        return this.strokecolor;
    }

    public void setFillColor(Color fillcolor) {
        this.fillcolor = fillcolor;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public Color getFillColor() {
        return this.fillcolor;
    }

    public void setTransparency(int transparency) {
        this.transparency = transparency;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public int getTransparency() {
        return this.transparency;
    }

    public void setOneToOne(boolean isSet) {
        this.isOneToOne = isSet;
    }

    public boolean isOneToOne() {
        return this.isOneToOne;
    }

    public void setFontFamily(String fontfamily) {
        this.fontfamily = fontfamily;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public String getFontFamily() {
        return this.fontfamily;
    }

    public void updateFontStyle(int fontstyle) {
        this.fontstyle = fontstyle;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public void setFontStyle(int fontstyle) {
        this.fontstyle = fontstyle;
    }

    public int getFontStyle() {
        return this.fontstyle;
    }

    public void setFontSize(int fontsize) {
        this.fontsize = fontsize;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public int getFontSize() {
        return this.fontsize;
    }

    public void setArrow(ArrowType arrowtype) {
        this.arrowtype = arrowtype;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public ArrowType getArrow() {
        return this.arrowtype;
    }

    public void resetArrow() {
        this.arrowtype = ArrowType.NONE;
        if (this.getDropperDisabled()) {
            this.view.updateSelectedItem();
        }
    }

    public void setGrid(boolean gridVisible) {
        this.gridVisible = gridVisible;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setSnapTo(boolean gridVisible) {
        this.mouselistener.setSnapEnabled(gridVisible);
    }

    public void setGuideEnabled(boolean isGuideEnabled) {
        this.isGuideEnabled = isGuideEnabled;
    }

    public boolean isGuideEnabled() {
        return this.isGuideEnabled;
    }

    public void setMarquee(DrawItem marquee) {
        this.marquee = marquee;
    }

    public DrawItem getMarquee() {
        return this.marquee;
    }

    public void addGuide(boolean xy, Double p) {
        if (xy) {
            Edge guide = (Edge)this.figurefactory.createFigure(DrawingType.LINE);
            guide.setStart(0.0, p);
            guide.setEnd(925.0, p);
            guide.setPoints(DrawingType.LINE);
            guide.setEndPoints();
            guide.setPath();
            guide.setStroke(new BasicStroke(1.0f, 1, 1));
            guide.setColor(new Color(204, 102, 255));
            guide.setFillColor(new Color(48, 96, 255));
            guide.setTransparency(25);
            this.guides.addDrawItem(guide);
        } else {
            Edge guide = (Edge)this.figurefactory.createFigure(DrawingType.LINE);
            guide.setStart(p, 0.0);
            guide.setEnd(p, 1300.0);
            guide.setPoints(DrawingType.LINE);
            guide.setEndPoints();
            guide.setPath();
            guide.setStroke(new BasicStroke(1.0f, 1, 1));
            guide.setColor(new Color(204, 102, 255));
            guide.setFillColor(new Color(48, 96, 255));
            guide.setTransparency(25);
            this.guides.addDrawItem(guide);
        }
    }

    public void resetGuides() {
        this.guides = new Grouped();
    }

    public void setRotationMode(boolean rotationMode) {
        this.rotationMode = rotationMode;
    }

    public boolean isRotationMode() {
        return this.rotationMode;
    }

    public void setMultiSelectEnabled(boolean multiSelectEnabled) {
        this.multiSelectEnabled = multiSelectEnabled;
    }

    public boolean isMultiSelectEnabled() {
        return this.multiSelectEnabled;
    }

    public void setToolPanel(ToolPanel toolpanel) {
        this.toolpanel = toolpanel;
    }

    public ToolPanel getToolPanel() {
        return this.toolpanel;
    }

    protected void setEditMenuBean(EditMenuBean editMenuBean) {
        this.editMenuBean = editMenuBean;
    }

    protected void editTextItem() {
        DrawItem item;
        if (this.view.getSelected() != -1 && (item = this.view.getDrawings().get(this.view.getSelected())) instanceof Text) {
            Text text = (Text)item;
            TextController textController = this.view.getTextController();
            if (textController.isRichText()) {
                this.setFontStyle(0);
                this.getToolPanel().resetFormattingButtons();
            }
            textController.editItem(text);
            this.view.setEditing(KeyboardHandlerType.TEXT);
            this.repaint();
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.inputMethodRequestsHandler == null) {
            this.inputMethodRequestsHandler = new InputMethodRequestsHandler();
        }
        return this.inputMethodRequestsHandler;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (DrawingCanvas.this.view.getSelected() != -1 && !DrawingCanvas.this.view.isEditing() && DrawingCanvas.this.view.getDrawings().get(DrawingCanvas.this.view.getSelected()) instanceof Text) {
                    DrawingCanvas.this.editMenuBean.setTextItemSelected(true);
                } else {
                    DrawingCanvas.this.editMenuBean.setTextItemSelected(false);
                }
                if (DrawingCanvas.this.view.getSelected() != -1 && !DrawingCanvas.this.view.isMapping() && DrawingCanvas.this.view.getDrawings().get(DrawingCanvas.this.view.getSelected()) instanceof StreetMap) {
                    DrawingCanvas.this.editMenuBean.setMapItemSelected(true);
                } else {
                    DrawingCanvas.this.editMenuBean.setMapItemSelected(false);
                }
                DrawingCanvas.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class InputMethodRequestsHandler
    implements InputMethodRequests {
        InputMethodRequestsHandler() {
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo offset) {
            DrawItem drawItem;
            Rectangle r = new Rectangle();
            if (DrawingCanvas.this.view.isEditing() && (drawItem = DrawingCanvas.this.view.getDrawings().get(DrawingCanvas.this.view.getSelected())) instanceof Text) {
                Text item = (Text)drawItem;
                Point p = DrawingCanvas.this.getLocationOnScreen();
                p.translate((int)item.getStart().getX(), (int)(item.getStart().getY() + item.getEnd().getY()));
                r.translate(p.x, p.y);
                r.translate(DrawingCanvas.this.view.getTextController().getEditor().getCaretStart() * item.getSize() / 2, 0);
            }
            return r;
        }

        @Override
        public TextHitInfo getLocationOffset(int x, int y) {
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            return 0;
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public int getCommittedTextLength() {
            return 0;
        }

        @Override
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }
    }
}

