/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.perspective.draw.geom.DrawItem;

public class DrawItemTransferable
implements Transferable {
    String mimeType = "application/x-java-serialized-object;class=net.perspective.draw.geom.DrawItem";
    DataFlavor dataFlavor;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private static final Logger logger = Logger.getLogger(DrawItemTransferable.class.getName());

    public DrawItemTransferable(DrawItem item) {
        try {
            ObjectOutputStream i = new ObjectOutputStream(this.out);
            i.writeObject(item);
        }
        catch (IOException e) {
            logger.warning("I/O Exception");
        }
        finally {
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        try {
            this.dataFlavor = new DataFlavor(this.mimeType);
        }
        catch (ClassNotFoundException e) {
            logger.warning("mimeType failed in DrawItemTransferable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.out.toByteArray());
        try {
            DrawItem item;
            ObjectInputStream in = new ObjectInputStream(bin);
            DrawItem drawItem = item = (DrawItem)in.readObject();
            return drawItem;
        }
        catch (IOException e) {
            logger.warning("I/O Exception");
        }
        catch (ClassNotFoundException e) {
            logger.warning("ClassNotFound");
        }
        finally {
            try {
                bin.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{this.dataFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.dataFlavor.equals(flavor);
    }
}

