/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.harawata.appdirs.AppDirs;
import net.harawata.appdirs.AppDirsFactory;
import net.perspective.draw.Gesticulate;

public class ConfigSetup {
    private static final Logger logger = Logger.getLogger(Gesticulate.class.getName());
    public static Properties prefs = null;

    public String configDir() {
        AppDirs appDirs = AppDirsFactory.getInstance();
        return appDirs.getUserConfigDir("Gesticulate", null, "ctipper", true) + System.getProperty("file.separator");
    }

    public void setUserPreferences(Properties prefs) {
        AppDirs appDirs = AppDirsFactory.getInstance();
        Path paramPath = Paths.get(appDirs.getUserConfigDir("Gesticulate", null, "ctipper", true), "userprefs.properties");
        if (Files.exists(paramPath, LinkOption.NOFOLLOW_LINKS)) {
            this.setUserProperties(prefs);
        } else {
            Paths.get(this.configDir(), new String[0]).toFile().mkdirs();
            this.setUserProperties(prefs);
        }
    }

    public Properties getUserPreferences() {
        if (prefs == null) {
            prefs = new Properties();
            AppDirs appDirs = AppDirsFactory.getInstance();
            Path paramPath = Paths.get(appDirs.getUserConfigDir("Gesticulate", null, "ctipper", true), "userprefs.properties");
            if (Files.exists(paramPath, LinkOption.NOFOLLOW_LINKS)) {
                prefs = this.getUserProperties();
            } else {
                prefs.setProperty("darkTheme", "false");
            }
        }
        return prefs;
    }

    private void setUserProperties(Properties prefs) {
        try (FileWriter out = new FileWriter(this.configDir() + "userprefs.properties");){
            prefs.store(out, "---User Preferences---");
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private Properties getUserProperties() {
        Properties props = new Properties();
        try (FileReader fin = new FileReader(this.configDir() + "userprefs.properties");){
            props.load(fin);
        }
        catch (FileNotFoundException ex) {
            logger.fine("userprefs.properties not found.");
        }
        catch (IOException ex) {
            logger.warning("userprefs.properties not correct.");
        }
        return props;
    }
}

