/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.runtime.SwitchBootstraps;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.perspective.draw.CanvasItemTransferHandler;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.ImageItem;
import net.perspective.draw.TextController;
import net.perspective.draw.TextItemTransferHandler;
import net.perspective.draw.enums.KeyboardHandlerType;
import net.perspective.draw.geom.AcceptIcon;
import net.perspective.draw.geom.ArrowLine;
import net.perspective.draw.geom.ArrowType;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Figure;
import net.perspective.draw.geom.FigureType;
import net.perspective.draw.geom.Grouped;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.geom.Text;
import net.perspective.draw.network.Endpoint;
import net.perspective.draw.network.ModelSyncImpl;
import net.perspective.draw.network.NullSyncImpl;
import net.perspective.draw.network.Synchroniser;
import net.perspective.draw.swing.Dropper;
import net.perspective.draw.util.CanvasPoint;
import net.perspective.draw.util.RailwayStroke;
import org.jhotdraw.geom.DoubleStroke;

public class CanvasView
implements PropertyChangeListener {
    private final DrawingCanvas canvas;
    private final List<DrawItem> drawings;
    private final List<ImageItem> images;
    private final List<DrawItem> removed;
    private final ExecutorService executor;
    private final ExecutorService connector;
    private final Dropper dropper;
    private final Set<Integer> selectionIndex;
    private Optional<DrawItem> newitem;
    private TextController textController;
    private Synchroniser sync;
    private Endpoint endpoint;
    private boolean isDrawing;
    private boolean isEditing;
    private boolean isMapping;
    private boolean isMarquee;
    private boolean isSync;
    private boolean hasGuides;
    private static final Logger logger = Logger.getLogger(CanvasView.class.getName());

    public CanvasView(DrawingCanvas canvas) {
        this.canvas = canvas;
        this.drawings = new ArrayList<DrawItem>();
        this.images = new ArrayList<ImageItem>();
        this.newitem = Optional.empty();
        this.selectionIndex = new LinkedHashSet<Integer>();
        this.removed = new ArrayList<DrawItem>();
        this.dropper = new Dropper();
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MICROSECONDS, new LinkedBlockingQueue<Runnable>(1000));
        this.connector = Executors.newCachedThreadPool();
    }

    public void initializeView() {
        this.textController = new TextController(this, this.canvas);
    }

    public TextController getTextController() {
        return this.textController;
    }

    public void setDocument(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getDocument() {
        return this.endpoint;
    }

    public void setEnableSync(boolean isSync) {
        this.isSync = isSync;
        this.sync = isSync ? new ModelSyncImpl(this) : new NullSyncImpl(this);
    }

    public boolean getEnableSync() {
        return this.isSync;
    }

    public void initDocument() {
        CompletableFuture.runAsync(() -> {
            this.sync.register();
            this.sync.init();
        }, this.connector).thenRun(() -> SwingUtilities.invokeLater(this.canvas::repaint));
    }

    public void synchronise() {
        this.sync.synchronise();
    }

    public void unlinkDocument() {
        this.sync.expungePictures();
        this.sync.disconnect();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Object s = event.getNewValue();
        if (s instanceof Boolean && ((Boolean)s).booleanValue()) {
            this.setSelected(-1);
        }
        CompletableFuture.runAsync(() -> this.sync.update((Boolean)s), this.executor);
    }

    public void eraseQueuedPictures() {
        this.sync.expungePictures();
    }

    public void clearDocument() {
        CompletableFuture.runAsync(() -> this.sync.deleteAll(), this.executor).thenRun(this.sync::clear);
        this.canvas.repaint();
    }

    public void addItemToCanvas(DrawItem item) {
        item.updateProperties(this.canvas);
        this.appendItemToCanvas(item);
    }

    public void appendItemToCanvas(DrawItem item) {
        this.drawings.add(item);
        this.sync.addTo(this.drawings.indexOf(item));
        this.canvas.repaint();
    }

    public void copyItemToCanvas(DrawItem item) {
        this.drawings.add(item);
        this.sync.copyTo(this.drawings.indexOf(item));
        this.canvas.repaint();
    }

    public void deleteSelectedItem() {
        if (this.getSelected() != -1) {
            int selection = this.getSelected();
            this.sync.deleteFrom(selection);
            this.drawings.remove(selection);
        }
        this.canvas.repaint();
    }

    public void updateSelectedItem() {
        if (this.getSelected() != -1 && this.canvas.getDropperDisabled()) {
            DrawItem item = this.drawings.get(this.getSelected());
            if (!this.isMultiSelected() && !this.canvas.isMultiSelectEnabled()) {
                item.updateProperties(this.canvas);
            }
            if (item instanceof Figure && !(item instanceof ArrowLine)) {
                FigureType type = ((Figure)item).getType();
                if (this.canvas.getArrow() != ArrowType.NONE && (type.equals((Object)FigureType.CURVE) || type.equals((Object)FigureType.SKETCH) || type.equals((Object)FigureType.LINE))) {
                    item = new ArrowLine((Figure)item);
                    item.updateProperties(this.canvas);
                }
            } else if (item instanceof ArrowLine) {
                ArrowLine arrowLine = (ArrowLine)item;
                if (this.canvas.getArrow() == ArrowType.NONE) {
                    item = arrowLine.getLine();
                    item.updateProperties(this.canvas);
                } else {
                    item.updateProperties(this.canvas);
                }
            }
            this.drawings.set(this.getSelected(), item);
            for (Integer drawing : this.getMultiSelection()) {
                this.sync.updateTo(drawing);
            }
        } else if (this.getSelected() != -1 && !this.canvas.getDropperDisabled()) {
            DrawItem item;
            DrawItem drawItem = item = this.drawings.get(this.getSelected());
            Objects.requireNonNull(drawItem);
            DrawItem drawItem2 = drawItem;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Figure.class, Text.class}, (Object)drawItem2, n)) {
                case 0: {
                    Figure figure = (Figure)drawItem2;
                    this.figureDropper(figure);
                    break;
                }
                case 1: {
                    Text text = (Text)drawItem2;
                    this.textDropper(text);
                    break;
                }
            }
        }
        this.canvas.repaint();
    }

    private void figureDropper(Figure item) {
        String styleId;
        int strokeId = 2;
        Stroke stroke = item.getStroke();
        if (stroke instanceof RailwayStroke) {
            strokeId = 8;
        }
        if (stroke instanceof DoubleStroke) {
            DoubleStroke doubleStroke = (DoubleStroke)stroke;
            if (doubleStroke.getInnerWidth() == 3.0) {
                strokeId = 3;
            }
            if (doubleStroke.getInnerWidth() == 4.0) {
                strokeId = 4;
            }
            if (doubleStroke.getInnerWidth() == 10.0) {
                strokeId = 8;
            }
        }
        if (stroke instanceof BasicStroke) {
            strokeId = this.dropper.getStrokeIdBinary((BasicStroke)item.getStroke());
        }
        if (item instanceof ArrowLine) {
            ArrowLine arrowLine = (ArrowLine)item;
            styleId = this.dropper.getStyleSelector(arrowLine.getStroke(), arrowLine.getArrowType());
        } else {
            styleId = this.dropper.getStyleSelector(item.getStroke(), ArrowType.NONE);
        }
        logger.log(Level.FINEST, "strokeId {0} styleId {1}", new Object[]{strokeId, styleId});
        Color color = item.getColor();
        Color fillcolor = item.getFillColor();
        logger.log(Level.FINEST, "color: {0} fillcolor: {1}", new Object[]{this.canvas.getToolPanel().toRGBCode(color), this.canvas.getToolPanel().toRGBCode(fillcolor)});
        if (item instanceof ArrowLine) {
            ArrowLine arrowLine = (ArrowLine)item;
            this.canvas.setArrow(arrowLine.getArrowType());
        } else {
            this.canvas.setArrow(ArrowType.NONE);
        }
        this.canvas.getToolPanel().setStrokeCombo(strokeId);
        this.canvas.getToolPanel().setStyleCombo(styleId);
        this.canvas.getToolPanel().setColor(color);
        this.canvas.getToolPanel().setFillColor(fillcolor);
    }

    private void textDropper(Text item) {
        String fontFamily = item.getFont();
        int fontSize = item.getSize();
        logger.log(Level.FINEST, "font {0} size {1}", new Object[]{fontFamily, fontSize});
        Color color = item.getColor();
        logger.log(Level.FINEST, "color: {0}", new Object[]{this.canvas.getToolPanel().toRGBCode(color)});
        this.canvas.getToolPanel().setColor(color);
        this.canvas.getToolPanel().setFontCombo(fontFamily);
        this.canvas.getToolPanel().setSizeCombo(fontSize);
    }

    public void addItem(int index, DrawItem item) {
        if (index < this.drawings.size()) {
            this.drawings.add(index, item);
            logger.log(Level.INFO, "Create: Added item at Index: {0}", index);
        } else {
            this.drawings.add(item);
            logger.info("Create: Added item.");
        }
    }

    public void replaceItem(int index, DrawItem item) {
        if (index < this.drawings.size()) {
            this.drawings.set(index, item);
            logger.log(Level.INFO, "Update: Replaced item at Index: {0}", index);
        } else {
            this.drawings.add(item);
            logger.info("Update: Replaced item.");
        }
    }

    public DrawItem deleteItem(int index) {
        try {
            DrawItem deleted = this.drawings.get(index);
            this.removed.add(deleted);
            logger.log(Level.INFO, "Delete: Removed item at Index: {0}", index);
            return deleted;
        }
        catch (IndexOutOfBoundsException e) {
            logger.log(Level.WARNING, "Delete: {0}", e.getMessage());
            return null;
        }
    }

    public void removeItems() {
        for (DrawItem item : this.removed) {
            this.drawings.remove(item);
        }
        this.removed.clear();
    }

    public void callRepaint() {
        this.canvas.repaint();
    }

    public void sendBackwards() {
        if (this.getSelected() != -1) {
            DrawItem item = this.drawings.get(this.getSelected());
            if (this.getSelected() > 0) {
                int selection = this.getSelected();
                if (selection < 2) {
                    this.drawings.add(0, item);
                    this.sync.add(0);
                } else {
                    this.drawings.add(selection - 1, item);
                    this.sync.add(selection - 1);
                }
                this.sync.delete(selection + 1);
                this.drawings.remove(selection + 1);
                this.canvas.repaint();
            }
        }
    }

    public void sendToBack() {
        if (this.getSelected() != -1) {
            DrawItem item = this.drawings.get(this.getSelected());
            if (this.getSelected() != 0) {
                int selection = this.getSelected();
                this.drawings.add(0, item);
                this.sync.add(0);
                this.sync.delete(selection + 1);
                this.drawings.remove(selection + 1);
                this.canvas.repaint();
            }
        }
    }

    public void bringForwards() {
        if (this.getSelected() != -1) {
            DrawItem item = this.drawings.get(this.getSelected());
            if (this.getSelected() < this.drawings.size() - 1) {
                int selection = this.getSelected();
                if (selection >= this.drawings.size() - 2) {
                    this.drawings.add(item);
                } else {
                    this.drawings.add(selection + 2, item);
                }
                this.sync.add(selection + 2);
                this.sync.delete(selection);
                this.drawings.remove(selection);
                this.canvas.repaint();
            }
        }
    }

    public void bringToFront() {
        if (this.getSelected() != -1) {
            DrawItem item = this.drawings.get(this.getSelected());
            if (this.getSelected() != this.drawings.size() - 1) {
                int selection = this.getSelected();
                this.drawings.add(item);
                this.sync.add(this.drawings.size() - 1);
                this.sync.delete(selection);
                this.drawings.remove(selection);
                this.canvas.repaint();
            }
        }
    }

    public void groupSelection() {
        if (this.getSelected() != -1) {
            Grouped groupedItem = new Grouped();
            ArrayList<DrawItem> removals = new ArrayList<DrawItem>();
            ArrayList<Integer> selection = new ArrayList<Integer>();
            Integer selected = this.getBottomSelected();
            for (Integer index : this.getMultiSelection()) {
                groupedItem.addDrawItem(this.drawings.get(index));
                selection.add(index);
            }
            Collections.reverse(selection);
            for (Integer index : selection) {
                removals.add(this.drawings.get(index));
            }
            this.setSelected(-1);
            removals.remove(this.drawings.get(selected));
            this.drawings.set(selected, groupedItem);
            this.sync.updateTo(selected);
            for (DrawItem item : removals) {
                this.sync.delete(this.drawings.indexOf(item));
                this.drawings.remove(item);
            }
            this.canvas.repaint();
        }
    }

    public void ungroupSelection() {
        if (this.getSelected() != -1) {
            int selected = this.getBottomSelected();
            DrawItem item = this.drawings.get(selected);
            if (item instanceof Grouped) {
                Grouped grouped = (Grouped)item;
                boolean added = false;
                for (DrawItem shape : grouped.getDrawItems()) {
                    if (!added) {
                        this.drawings.set(selected, shape);
                        this.sync.updateTo(selected);
                        added = true;
                    } else {
                        this.drawings.add(selected, shape);
                        this.sync.copyTo(selected);
                    }
                    ++selected;
                }
                this.setSelected(-1);
            }
            this.canvas.repaint();
        }
    }

    public void toggleVertical() {
        if (this.getSelected() != -1) {
            Figure figure;
            FigureType type;
            DrawItem item = this.drawings.get(this.getSelected());
            if (item instanceof Text || item instanceof Grouped || item instanceof Picture) {
                item.setVertical(!item.isVertical());
            } else if (item instanceof Figure && !(type = (figure = (Figure)item).getType()).equals((Object)FigureType.LINE)) {
                item.setVertical(!item.isVertical());
            }
            this.canvas.repaint();
            this.canvas.requestFocusInWindow();
        }
    }

    public void insertDateAndTime(Text item) {
        ZonedDateTime zoned = ZonedDateTime.now();
        String timestamp = zoned.format(DateTimeFormatter.ofPattern("dd/MM/yyyy kk:mm"));
        this.getTextController().getEditor().insertText(timestamp);
        this.getTextController().getEditor().commitText(item);
    }

    public List<DrawItem> getDrawings() {
        return this.drawings;
    }

    public List<ImageItem> getImageItems() {
        return this.images;
    }

    public int getImageItemsSize() {
        return this.images.size();
    }

    public int setImageItem(ImageItem imageItem) {
        this.images.add(imageItem);
        return this.images.size() - 1;
    }

    public void setImageItem(int i, ImageItem imageItem) {
        this.images.set(i, imageItem);
    }

    public void addImageItem(ImageItem imageItem) {
        this.images.add(imageItem);
    }

    public ImageItem getImageItem(int index) {
        return this.images.get(index);
    }

    public void replaceImage(int index, BufferedImage image) {
        ImageItem item = this.images.get(index);
        item.setImage(image);
        this.images.set(index, item);
    }

    public void setSelected(int selection) {
        if (selection == -1) {
            this.selectionIndex.clear();
        } else {
            if (!this.canvas.isMultiSelectEnabled()) {
                this.selectionIndex.clear();
            }
            this.selectionIndex.add(selection);
        }
    }

    public int getSelected() {
        int i;
        if (!this.selectionIndex.isEmpty()) {
            Integer[] a = (Integer[])this.selectionIndex.toArray(Integer[]::new);
            i = a[0];
        } else {
            i = -1;
        }
        return i;
    }

    public int getBottomSelected() {
        int i;
        if (!this.selectionIndex.isEmpty()) {
            Integer[] a = (Integer[])this.selectionIndex.toArray(Integer[]::new);
            i = a[0];
            for (Integer as : a) {
                if (as >= i) continue;
                i = as;
            }
        } else {
            i = -1;
        }
        return i;
    }

    public Set<Integer> getMultiSelection() {
        return this.selectionIndex;
    }

    public boolean isMultiSelected() {
        return this.selectionIndex.size() > 1;
    }

    public void selectShapes(DrawItem item) {
        Shape b = item.bounds();
        Rectangle2D boundary = b.getBounds2D();
        for (DrawItem drawing : this.drawings) {
            Rectangle2D d = drawing.bounds().getBounds2D();
            if (!boundary.contains(d)) continue;
            this.setSelected(this.drawings.indexOf(drawing));
        }
    }

    public void setEditing(KeyboardHandlerType keyHandler) {
        switch (keyHandler) {
            case TEXT: {
                this.canvas.getToolPanel().enableDropperButton(false);
                this.setEditing(true);
                this.setMapping(false);
                if (this.canvas.isDarkMode()) {
                    AcceptIcon.setColor(AcceptIcon.ACCEPT_DARK);
                } else {
                    AcceptIcon.setColor(AcceptIcon.ACCEPT_NORMAL);
                }
                this.canvas.setTransferHandler(new TextItemTransferHandler());
                this.canvas.setKeyboardHandler(keyHandler);
                break;
            }
            case MOVE: {
                this.canvas.getToolPanel().enableDropperButton(true);
                this.setEditing(false);
                this.setMapping(false);
                AcceptIcon.setColor(this.canvas.getThemeFillColor());
                this.canvas.setTransferHandler(new CanvasItemTransferHandler());
                this.canvas.setKeyboardHandler(keyHandler);
                break;
            }
            case MAP: {
                this.canvas.getToolPanel().enableDropperButton(false);
                this.setEditing(false);
                this.setMapping(true);
                this.canvas.setTransferHandler(null);
                this.canvas.setKeyboardHandler(keyHandler);
                break;
            }
        }
    }

    public void setEditing(boolean isEditing) {
        this.isEditing = isEditing;
    }

    public boolean isEditing() {
        return this.isEditing;
    }

    public void setMapping(boolean isMapping) {
        this.isMapping = isMapping;
    }

    public boolean isMapping() {
        return this.isMapping;
    }

    public void enableRichText(boolean isRichText) {
        this.textController.enableRichText(isRichText);
    }

    public void setNewItem(DrawItem newitem) {
        this.newitem = Optional.ofNullable(newitem);
    }

    public Optional<DrawItem> getNewItem() {
        return this.newitem;
    }

    public void setDrawing(boolean isDrawing) {
        this.isDrawing = isDrawing;
    }

    public boolean isDrawing() {
        return this.isDrawing;
    }

    public void setMarquee(boolean isMarquee) {
        this.isMarquee = isMarquee;
    }

    public boolean isMarquee() {
        return this.isMarquee;
    }

    public void setGuides(boolean hasGuides) {
        this.hasGuides = hasGuides;
    }

    public boolean hasGuides() {
        return this.hasGuides;
    }

    public CanvasPoint[] getBounds() {
        ArrayList<CanvasPoint> points = new ArrayList<CanvasPoint>();
        CanvasPoint start = new CanvasPoint();
        CanvasPoint end = new CanvasPoint();
        for (DrawItem shape : this.drawings) {
            points.add(shape.getTop()[0]);
            points.add(shape.getBottom()[0]);
            points.add(shape.getUp()[0]);
            points.add(shape.getDown()[0]);
        }
        try {
            CanvasPoint topleft = (CanvasPoint)((CanvasPoint)points.get(0)).clone();
            CanvasPoint bottomright = (CanvasPoint)((CanvasPoint)points.get(1)).clone();
            for (CanvasPoint point : points) {
                topleft.x = Math.min(point.x, topleft.x);
                topleft.y = Math.min(point.y, topleft.y);
                bottomright.x = Math.max(point.x, bottomright.x);
                bottomright.y = Math.max(point.y, bottomright.y);
            }
            start = new CanvasPoint(topleft.x, topleft.y);
            end = new CanvasPoint(bottomright.x, bottomright.y);
        }
        catch (CloneNotSupportedException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        return new CanvasPoint[]{start, end};
    }
}

