/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import net.perspective.draw.DrawItemTransferable;
import net.perspective.draw.DrawingCanvas;
import net.perspective.draw.ImageItem;
import net.perspective.draw.geom.DrawItem;
import net.perspective.draw.geom.Picture;
import net.perspective.draw.geom.StreetMap;

public class CanvasItemTransferHandler
extends TransferHandler {
    String mimeType = "application/x-java-serialized-object;class=net.perspective.draw.geom.DrawItem";
    DataFlavor drawItemFlavor;
    String dataflavor = "";
    private DrawingCanvas canvas;
    private double shift;
    private final int pageWidth = 940;
    private final int pageHeight = 1330;
    private static final Logger logger = Logger.getLogger(CanvasItemTransferHandler.class.getName());

    public CanvasItemTransferHandler() {
        try {
            this.drawItemFlavor = new DataFlavor(this.mimeType);
        }
        catch (ClassNotFoundException e) {
            logger.warning("mimeType failed in CanvasItemTransferHandler");
        }
        this.shift = 20.0;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasDrawItemFlavor(flavors);
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        this.canvas = (DrawingCanvas)c;
        if (this.hasDrawItemFlavor(t.getTransferDataFlavors())) {
            try {
                if (this.dataflavor.equals("drawitem")) {
                    DrawItem item = (DrawItem)t.getTransferData(this.drawItemFlavor);
                    item.moveTo(this.shift, this.shift);
                    item = this.checkDrawings(item);
                    this.canvas.getView().appendItemToCanvas(item);
                } else if (this.dataflavor.equals("imageitem")) {
                    Image img = (Image)t.getTransferData(DataFlavor.imageFlavor);
                    BufferedImage image = this.toBufferedImage(img);
                    Picture picture = new Picture(this.shift, this.shift);
                    ImageItem item = new ImageItem(image);
                    item.setFormat("PNG");
                    int index = this.canvas.getView().setImageItem(item);
                    double width = image.getWidth();
                    double height = image.getHeight();
                    double scale = this.getScale(width, height);
                    logger.log(Level.FINER, "Image relative scale: {0}", scale);
                    picture.setImage(index, width, height);
                    picture.setScale(scale);
                    this.canvas.getView().setNewItem(picture);
                    this.canvas.getView().addItemToCanvas(picture);
                }
                this.shift += 20.0;
                logger.fine("Item added to canvas");
                return true;
            }
            catch (UnsupportedFlavorException e) {
                logger.warning("importData: unsupported data flavor");
            }
            catch (IOException e) {
                logger.warning("importData: I/O exception");
            }
        }
        logger.finer("ImportData");
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        this.canvas = (DrawingCanvas)c;
        int selected = this.canvas.getView().getSelected();
        if (selected == -1) {
            return null;
        }
        DrawItem data = this.canvas.getView().getDrawings().get(selected);
        logger.finer("Item createTransferable");
        return new DrawItemTransferable(data);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        this.canvas = (DrawingCanvas)c;
        if (action == 2) {
            this.canvas.getView().deleteSelectedItem();
            logger.fine("Removed selected Item");
            this.shift = 0.0;
        } else {
            logger.fine("Copied selected Item");
            this.shift = 20.0;
        }
        this.canvas = null;
        logger.finer("ExportDone");
    }

    protected boolean hasDrawItemFlavor(DataFlavor[] flavors) {
        for (DataFlavor f : flavors) {
            if (this.drawItemFlavor.equals(f)) {
                logger.finer(this.mimeType);
                this.dataflavor = "drawitem";
                return true;
            }
            if (!DataFlavor.imageFlavor.equals(f)) continue;
            logger.finer("image/x-java-image;class=java.awt.Image");
            this.dataflavor = "imageitem";
            return true;
        }
        return false;
    }

    private DrawItem checkDrawings(DrawItem drawing) {
        DrawItem item;
        if (drawing instanceof StreetMap) {
            StreetMap streetmap = (StreetMap)drawing;
            item = this.canvas.getMapController().copyMap(streetmap);
        } else {
            item = drawing;
        }
        return item;
    }

    private double getScale(double width, double height) {
        if (width <= 940.0 && height <= 1330.0) {
            return 1.0;
        }
        if (width <= 940.0 && height > 1330.0) {
            return 1064.0 / height;
        }
        if (width > 940.0 && height <= 1330.0) {
            return 752.0 / width;
        }
        if (width > 940.0 && height > 1330.0) {
            double ratio_w = 940.0 / width;
            double ratio_h = 1330.0 / height;
            if (ratio_w <= ratio_h) {
                return 752.0 / width;
            }
            return 1064.0 / height;
        }
        return 1.0;
    }

    public BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)img;
            return bufferedImage;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

