/*
 * Decompiled with CFR 0.152.
 */
package net.perspective.draw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.perspective.draw.util.FileUtils;

public class AboutBox
extends JDialog
implements ActionListener {
    protected JLabel titleLabel;
    protected JLabel[] aboutLabel;
    protected int aboutTop;
    protected int aboutLeft;
    protected Font titleFont;
    protected Font bodyFont;
    private JPanel bottomPanel;
    private JPanel textPanel;
    private JLabel copyright1;
    private JLabel copyright2;
    private Font subtitleFont;
    protected static int labelCount = 4;
    protected static int aboutWidth = 300;
    protected static int aboutHeight = 215;
    private static final boolean MAC_OS_X = System.getProperty("os.name").toLowerCase().startsWith("mac os x");

    public AboutBox() {
        this.initComponents();
    }

    private void initComponents() {
        this.titleFont = new Font("Inter", 1, 14);
        if (this.titleFont == null) {
            this.titleFont = new Font("SansSerif", 1, 14);
        }
        this.subtitleFont = new Font("Inter", 1, 11);
        if (this.subtitleFont == null) {
            this.subtitleFont = new Font("SansSerif", 1, 11);
        }
        this.bodyFont = new Font("Inter", 0, 10);
        if (this.bodyFont == null) {
            this.bodyFont = new Font("SansSerif", 0, 10);
        }
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.aboutLabel = new JLabel[labelCount];
        this.aboutLabel[0] = new JLabel("Gesticulate");
        this.aboutLabel[0].setFont(this.titleFont);
        this.aboutLabel[1] = new JLabel("A freehand drawing tool");
        this.aboutLabel[1].setFont(this.subtitleFont);
        this.aboutLabel[2] = new JLabel("Version 2.0.14.9.2");
        this.aboutLabel[2].setFont(this.bodyFont);
        String[] elements = System.getProperty("java.specification.version").split("\\.");
        this.aboutLabel[3] = Integer.parseInt(elements[0]) < 2 ? new JLabel("JRE " + System.getProperty("java.version")) : new JLabel("JRE " + System.getProperty("java.runtime.version"));
        this.aboutLabel[3].setFont(this.bodyFont);
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new BoxLayout(this.textPanel, 1));
        this.textPanel.add(Box.createVerticalStrut(5));
        for (int i = 0; i < labelCount; ++i) {
            this.aboutLabel[i].setAlignmentX(0.5f);
            this.textPanel.add(Box.createVerticalStrut(10));
            this.textPanel.add(this.aboutLabel[i]);
        }
        this.getContentPane().add((Component)this.textPanel, "Center");
        JButton ok = new JButton("OK");
        ok.setAlignmentX(0.5f);
        ok.addActionListener(e -> this.setVisible(false));
        this.copyright1 = new JLabel("Copyright \u00a9 2025 Christopher Tipper");
        this.copyright1.setFont(this.bodyFont);
        this.copyright1.setAlignmentX(0.5f);
        this.copyright2 = new JLabel("All rights reserved.");
        this.copyright2.setFont(this.bodyFont);
        this.copyright2.setAlignmentX(0.5f);
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.bottomPanel.add(this.copyright1);
        if (MAC_OS_X) {
            this.bottomPanel.add(Box.createVerticalStrut(1));
        }
        this.bottomPanel.add(this.copyright2);
        this.bottomPanel.add(Box.createVerticalStrut(5));
        this.bottomPanel.add(ok);
        this.bottomPanel.add(Box.createVerticalStrut(10));
        this.getContentPane().add((Component)this.bottomPanel, "Last");
        ImageIcon icon = FileUtils.createMultiDpiImageIcon("/gesticulate-48.png");
        JLabel image = new JLabel(icon);
        image.setPreferredSize(new Dimension(65, 48));
        image.setHorizontalAlignment(4);
        this.getContentPane().add((Component)image, "Before");
        JPanel dummyPanel = new JPanel();
        dummyPanel.setPreferredSize(new Dimension(65, 48));
        this.getContentPane().add((Component)dummyPanel, "After");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.pack();
        this.setSize(aboutWidth, aboutHeight);
    }

    @Override
    public void setLocation(int left, int top) {
        this.aboutLeft = left - aboutWidth / 2;
        this.aboutTop = top - aboutHeight / 2;
        super.setLocation(this.aboutLeft, this.aboutTop);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            AboutBox.this.setVisible(false);
        }
    }
}

